---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-jsonable_encoder

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/encoders.py` - jsonable_encoder関数定義（111-346行目）
- E-02: `fastapi/encoders.py` - ENCODERS_BY_TYPE辞書（67-94行目）
- E-03: `fastapi/encoders.py` - decimal_encoder関数（42-64行目）
- E-04: `fastapi/encoders.py` - isoformat関数（36-37行目）
- E-05: `fastapi/routing.py` - jsonable_encoderのimport（42行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義（33行目）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - Swagger UI関連（6行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PythonオブジェクトをJSON互換形式に変換 | E-01（201-212行目のdocstring） | ○ |
| C-02 | BaseModelはmodel_dump()で変換 | E-01（225-240行目） | ○ |
| C-03 | dataclassはasdict()で変換 | E-01（241-254行目） | ○ |
| C-04 | Enumはvalue属性を取得 | E-01（255-256行目） | ○ |
| C-05 | PurePathはstr()で変換 | E-01（257-258行目） | ○ |
| C-06 | datetimeはisoformat()で変換 | E-02, E-04（70-72行目） | ○ |
| C-07 | UUIDはstr()で変換 | E-02（91行目） | ○ |
| C-08 | Decimalはint/floatに変換 | E-02, E-03（74行目、42-64行目） | ○ |
| C-09 | カスタムエンコーダーが適用可能 | E-01（213-220行目） | ○ |
| C-10 | sqlalchemy_safeで_sa属性を除外 | E-01（271-276行目） | ○ |
| C-11 | exclude_noneでNone値を除外 | E-01（277行目） | ○ |
| C-12 | by_aliasでエイリアス名を使用 | E-01（138-149行目、230行目） | ○ |
| C-13 | Pydantic v1モデルは例外発生 | E-01（321-325行目） | ○ |
| C-14 | dict型は再帰的に処理 | E-01（263-297行目） | ○ |
| C-15 | list/set等は再帰的に処理 | E-01（298-314行目） | ○ |
| C-16 | ENCODERS_BY_TYPEに型別変換ルール | E-02（67-94行目） | ○ |
| C-17 | dict/varsでフォールバック変換 | E-01（326-346行目） | ○ |
| C-18 | Swagger UIで内部使用 | E-05, E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主要機能がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ENCODERS_BY_TYPEの型一覧が正確か確認
- [ ] 再帰処理のフローが正しく記述されているか確認
- [ ] パラメータのデフォルト値が正確か確認
