---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-Middleware基盤

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/middleware/__init__.py` - Middleware再エクスポート（1行目）
- E-02: `fastapi/middleware/asyncexitstack.py` - AsyncExitStackMiddleware定義（1-18行目）
- E-03: `fastapi/applications.py` - ミドルウェア関連import（35-38行目）
- E-04: `fastapi/applications.py` - user_middleware初期化（992-995行目）
- E-05: `fastapi/applications.py` - build_middleware_stack関数（998行目）
- E-06: `fastapi/applications.py` - middleware組み立て（1011-1014行目）
- E-07: `fastapi/applications.py` - ミドルウェア逆順ラップ（1042行目）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義（36行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MiddlewareクラスはStarletteから再エクスポート | E-01（1行目） | ○ |
| C-02 | user_middlewareリストでミドルウェアを管理 | E-04（992-993行目） | ○ |
| C-03 | build_middleware_stack()でスタック構築 | E-05（998行目） | ○ |
| C-04 | ServerErrorMiddlewareが最外層 | E-03（37行目import）, E-06 | ○ |
| C-05 | ExceptionMiddlewareが内側で例外処理 | E-03（38行目import） | ○ |
| C-06 | AsyncExitStackMiddlewareがリソース管理 | E-02（6-7行目のコメント） | ○ |
| C-07 | ミドルウェアは登録順の逆順で実行 | E-07（1042行目のreversed） | ○ |
| C-08 | AsyncExitStackMiddlewareはyield依存性のクリーンアップ用 | E-02（6-7行目のコメント） | ○ |
| C-09 | context_nameパラメータでスコープ名を指定 | E-02（10-11行目） | ○ |
| C-10 | AsyncExitStack内でappを呼び出し | E-02（15-18行目） | ○ |
| C-11 | BaseHTTPMiddlewareをサポート | E-03（36行目import） | ○ |
| C-12 | @app.middleware("http")デコレータ対応 | E-03（4578-4619行目付近のmiddleware関数） | ○ |
| C-13 | Starletteミドルウェアとの互換性 | E-01, E-03 | ○ |
| C-14 | 機能番号35、カテゴリ「ミドルウェア」 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主要機能がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Middlewareの再エクスポートが正しいか確認
- [ ] ミドルウェアスタックの構築順序が正確か確認
- [ ] AsyncExitStackMiddlewareの役割が正しく記述されているか確認
