---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-generate_unique_id

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. **計算ロジック**：具体例との整合性確認推奨
  2. **generate_operation_id_for_pathの非推奨**：警告メッセージ確認
  3. **route.methodsのassert**：エラー発生ケースの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/utils.py` 123-128行目
- E-02: `fastapi/utils.py` 108-120行目（generate_operation_id_for_path）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 48行目
- E-04: `fastapi/routing.py` 55行目（インポート）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントの一意なIDを生成する機能 | E-03（"エンドポイントの一意なIDを生成"） | ○ |
| C-02 | OpenAPIのoperationIdに使用 | E-03（"OpenAPIのoperationIdに使用"） | ○ |
| C-03 | route.nameを取得して使用 | E-01（124行目: `route.name`） | ○ |
| C-04 | route.path_formatを取得して使用 | E-01（124行目: `route.path_format`） | ○ |
| C-05 | 非英数字を"_"に置換 | E-01（125行目: `re.sub(r"\W", "_", operation_id)`） | ○ |
| C-06 | HTTPメソッドを小文字で末尾に付加 | E-01（127行目: `list(route.methods)[0].lower()`） | ○ |
| C-07 | route.methodsにassertを行う | E-01（126行目: `assert route.methods`） | ○ |
| C-08 | route.methodsの最初の要素を使用 | E-01（127行目: `list(route.methods)[0]`） | ○ |
| C-09 | 関数シグネチャはroute: APIRouteを受け取りstrを返す | E-01（123行目: `def generate_unique_id(route: "APIRoute") -> str:`） | ○ |
| C-10 | generate_operation_id_for_pathは非推奨 | E-02（111-115行目: `warnings.warn`と`FastAPIDeprecationWarning`） | ○ |
| C-11 | routing.pyでgenerate_unique_idがインポートされる | E-04（`from fastapi.utils import generate_unique_id`） | ○ |
| C-12 | 計算ロジックの例が正しい | E-01（コード実行により検証可能） | ○ |
| C-13 | 正規表現でreモジュールを使用 | E-01（1行目: `import re`） | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 実装は明確でシンプル
- 0: 低リスク - 機能一覧との整合性確認済み
- 0: 低リスク - コード実装と設計書の記述が一致

## 6) レビュアーチェックリスト（最小）

- [ ] E-01のutils.py実装が設計書と一致しているか確認
- [ ] E-03の機能一覧との整合性を確認
- [ ] 計算ロジックの具体例が正しいか確認
- [ ] generate_operation_id_for_pathの非推奨警告を確認
- [ ] routing.pyでのgenerate_unique_id使用箇所を確認
