---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Queryパラメータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり、重点レビュー不要

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/params.py` - Queryクラス定義（222-301行目）
- E-02: `fastapi/param_functions.py` - Query関数定義（340-639行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ParamTypes.queryが存在する | E-01（21行目: `query = "query"`） | ○ |
| C-02 | QueryクラスはParamを継承 | E-01（222行目: `class Query(Param)`） | ○ |
| C-03 | Queryのin_はParamTypes.query | E-01（223行目: `in_ = ParamTypes.query`） | ○ |
| C-04 | QueryのdefaultはUndefined | E-01（227行目: `default: Any = Undefined`） | ○ |
| C-05 | Queryはデフォルト値を設定可能 | E-01（227行目: Pathと異なりdefault=...ではない） | ○ |
| C-06 | Query関数がparams.Queryを返す | E-02（609-639行目） | ○ |
| C-07 | alias引数が存在する | E-02（361-372行目） | ○ |
| C-08 | title引数が存在する | E-02（400-407行目） | ○ |
| C-09 | description引数が存在する | E-02（408-415行目） | ○ |
| C-10 | gt/ge/lt/le引数が存在する | E-02（416-449行目） | ○ |
| C-11 | min_length/max_length引数が存在する | E-02（451-466行目） | ○ |
| C-12 | pattern引数が存在する | E-02（467-474行目） | ○ |
| C-13 | examples引数が存在する | E-02（534-541行目） | ○ |
| C-14 | deprecated引数が存在する | E-02（566-575行目） | ○ |
| C-15 | include_in_schema引数が存在する | E-02（576-586行目） | ○ |
| C-16 | 機能カテゴリは「パラメータ」に分類される | E-03（行6） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Queryパラメータの任意/必須の仕様が正確に記載されているか確認
- [ ] バリデーションパラメータの説明が正確か確認
- [ ] リスト型対応の記述が実装と一致しているか確認
