---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Headerパラメータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり、重点レビュー不要

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/params.py` - Headerクラス定義（304-385行目）
- E-02: `fastapi/param_functions.py` - Header関数定義（642-953行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ParamTypes.headerが存在する | E-01（22行目: `header = "header"`） | ○ |
| C-02 | HeaderクラスはParamを継承 | E-01（304行目: `class Header(Param)`） | ○ |
| C-03 | Headerのin_はParamTypes.header | E-01（305行目: `in_ = ParamTypes.header`） | ○ |
| C-04 | convert_underscoresのデフォルトはTrue | E-01（317行目: `convert_underscores: bool = True`） | ○ |
| C-05 | convert_underscoresがインスタンス変数に保存 | E-01（353行目: `self.convert_underscores = convert_underscores`） | ○ |
| C-06 | Header関数がparams.Headerを返す | E-02（922-953行目） | ○ |
| C-07 | alias引数が存在する | E-02（663-674行目） | ○ |
| C-08 | title引数が存在する | E-02（713-720行目） | ○ |
| C-09 | description引数が存在する | E-02（721-728行目） | ○ |
| C-10 | gt/ge/lt/le引数が存在する | E-02（729-762行目） | ○ |
| C-11 | min_length/max_length引数が存在する | E-02（763-778行目） | ○ |
| C-12 | pattern引数が存在する | E-02（779-786行目） | ○ |
| C-13 | deprecated引数が存在する | E-02（879-888行目） | ○ |
| C-14 | 機能カテゴリは「パラメータ」に分類される | E-03（行7） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] convert_underscoresの動作が正確に記載されているか確認
- [ ] HTTPヘッダー名の大文字小文字不問の仕様を確認
- [ ] セキュリティ考慮事項が十分か確認
