---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-Bodyパラメータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり、重点レビュー不要

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/params.py` - Bodyクラス定義（470-579行目）
- E-02: `fastapi/param_functions.py` - Body関数定義（1258-1582行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BodyクラスはFieldInfoを継承 | E-01（470行目: `class Body(FieldInfo)`） | ○ |
| C-02 | embedパラメータが存在する | E-01（477行目: `embed: Union[bool, None] = None`） | ○ |
| C-03 | media_typeのデフォルトはapplication/json | E-01（478行目: `media_type: str = "application/json"`） | ○ |
| C-04 | self.embedにembedを保存 | E-01（518行目: `self.embed = embed`） | ○ |
| C-05 | self.media_typeにmedia_typeを保存 | E-01（519行目: `self.media_type = media_type`） | ○ |
| C-06 | Body関数がparams.Bodyを返す | E-02（1550-1582行目） | ○ |
| C-07 | Body関数にembedパラメータがある | E-02（1279-1292行目） | ○ |
| C-08 | Body関数にmedia_typeパラメータがある | E-02（1293-1301行目） | ○ |
| C-09 | alias引数が存在する | E-02（1302-1313行目） | ○ |
| C-10 | title引数が存在する | E-02（1341-1348行目） | ○ |
| C-11 | description引数が存在する | E-02（1349-1356行目） | ○ |
| C-12 | gt/ge/lt/le引数が存在する | E-02（1357-1390行目） | ○ |
| C-13 | examples引数が存在する | E-02（1475-1482行目） | ○ |
| C-14 | deprecated引数が存在する | E-02（1507-1516行目） | ○ |
| C-15 | 機能カテゴリは「パラメータ」に分類される | E-03（行9） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] embedパラメータの動作が正確に記載されているか確認
- [ ] Pydanticモデルとの連携説明が十分か確認
- [ ] 複数Bodyパラメータ時の動作が明確か確認
