---
generated_at: 2026-01-22 19:28:00
metrics:
  claims_total: 5
  claims_with_evidence: 5
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：5 / 5、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/openapi/docs.py` - get_swagger_ui_html関数（26-158行目）
- E-02: `fastapi/openapi/docs.py` - get_redoc_html関数（161-253行目）
- E-03: `fastapi/openapi/docs.py` - get_swagger_ui_oauth2_redirect_html関数（256-345行目）
- E-04: `docs_src/templates/templates/item.html` - Jinja2テンプレートファイル
- E-05: `docs_src/templates/tutorial001_py39.py` - テンプレート使用サンプル
- E-06: `fastapi/applications.py` - FastAPIクラス（openapi_url, docs_url, redoc_url設定）
- E-07: `docs_src/bigger_applications/app_py39/main.py` - サンプルアプリケーション

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Swagger UI画面が/docsで提供される | E-01, E-06 | ○ |
| C-02 | ReDoc画面が/redocで提供される | E-02, E-06 | ○ |
| C-03 | OAuth2リダイレクト画面が存在する | E-03, E-06 | ○ |
| C-04 | アイテム詳細画面（テンプレートサンプル）が存在する | E-04, E-05 | ○ |
| C-05 | OpenAPI JSONが/openapi.jsonで提供される | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての画面はソースコードから直接確認可能
- 注意点：本プロジェクトはFastAPIフレームワーク自体であり、通常のWebアプリケーションとは異なる。画面機能は主にAPIドキュメント用途に限定される

## 6) レビュアーチェックリスト（最小）
- [ ] Swagger UI（/docs）の画面定義が正確か確認（E-01, E-06参照）
- [ ] ReDoc（/redoc）の画面定義が正確か確認（E-02, E-06参照）
- [ ] テンプレートサンプル（item.html）の内容が正確か確認（E-04, E-05参照）
- [ ] フレームワークとサンプルコードの区別が明確か確認
- [ ] 画面遷移図のmermaid記法が正しく表示されるか確認
