# 画面遷移図

FastAPIフレームワークが提供する画面およびサンプルアプリケーションの画面遷移図です。

## フレームワーク組み込み画面

```mermaid
flowchart TB
    subgraph FastAPI["FastAPI アプリケーション"]
        ROOT["/（ルート）"]

        subgraph Docs["ドキュメント機能"]
            SWAGGER["/docs<br/>Swagger UI"]
            REDOC["/redoc<br/>ReDoc"]
            OPENAPI["/openapi.json<br/>OpenAPI スキーマ"]
            OAUTH2["/docs/oauth2-redirect<br/>OAuth2 リダイレクト"]
        end

        subgraph API["APIエンドポイント"]
            API_ENDPOINTS["各種APIエンドポイント<br/>（アプリケーション定義）"]
        end
    end

    ROOT --> SWAGGER
    ROOT --> REDOC
    ROOT --> API_ENDPOINTS

    SWAGGER --> OPENAPI
    REDOC --> OPENAPI
    SWAGGER --> OAUTH2
    SWAGGER --> API_ENDPOINTS
```

## サンプルアプリケーション（docs_src/templates）

```mermaid
flowchart LR
    subgraph Templates["テンプレートサンプル"]
        ITEM_LIST["アイテム一覧<br/>（想定）"]
        ITEM_DETAIL["/items/{id}<br/>アイテム詳細画面"]
    end

    ITEM_LIST --> ITEM_DETAIL
    ITEM_DETAIL --> ITEM_DETAIL
```

## サンプルアプリケーション（docs_src/bigger_applications）

```mermaid
flowchart TB
    subgraph BiggerApp["大規模アプリケーションサンプル"]
        APP_ROOT["/（ルート）<br/>Hello Bigger Applications!"]

        subgraph Users["ユーザー関連"]
            USERS_LIST["/users/<br/>ユーザー一覧"]
            USER_ME["/users/me<br/>現在のユーザー"]
            USER_DETAIL["/users/{username}<br/>ユーザー詳細"]
        end

        subgraph Items["アイテム関連"]
            ITEMS_LIST["/items/<br/>アイテム一覧"]
            ITEM_DETAIL_BIG["/items/{item_id}<br/>アイテム詳細"]
            ITEM_UPDATE["/items/{item_id}<br/>アイテム更新（PUT）"]
        end

        subgraph Admin["管理者機能"]
            ADMIN_UPDATE["/admin/<br/>管理者更新"]
        end
    end

    APP_ROOT --> USERS_LIST
    APP_ROOT --> ITEMS_LIST
    APP_ROOT --> ADMIN_UPDATE

    USERS_LIST --> USER_ME
    USERS_LIST --> USER_DETAIL

    ITEMS_LIST --> ITEM_DETAIL_BIG
    ITEM_DETAIL_BIG --> ITEM_UPDATE
```

## 画面遷移の説明

### フレームワーク組み込み画面
| 遷移元 | 遷移先 | 遷移条件 |
|--------|--------|----------|
| ルート | Swagger UI | `/docs` へアクセス |
| ルート | ReDoc | `/redoc` へアクセス |
| Swagger UI | OpenAPI JSON | 自動的にスキーマを読み込み |
| Swagger UI | OAuth2リダイレクト | OAuth2認証フロー実行時 |
| ReDoc | OpenAPI JSON | 自動的にスキーマを読み込み |

### サンプルアプリケーション（bigger_applications）
| 遷移元 | 遷移先 | 遷移条件 |
|--------|--------|----------|
| ルート | ユーザー一覧 | `/users/` へアクセス |
| ルート | アイテム一覧 | `/items/` へアクセス |
| ルート | 管理者更新 | `/admin/` へPOST |
| ユーザー一覧 | 現在のユーザー | `/users/me` へアクセス |
| ユーザー一覧 | ユーザー詳細 | `/users/{username}` へアクセス |
| アイテム一覧 | アイテム詳細 | `/items/{item_id}` へアクセス |
| アイテム詳細 | アイテム更新 | `/items/{item_id}` へPUT |

## 注記

1. このプロジェクトはFastAPIフレームワーク自体のソースコードであり、通常のWebアプリケーションとは異なります
2. 画面（HTML表示）は主にドキュメント機能（Swagger UI、ReDoc）として提供されています
3. `docs_src/` 配下のコードはドキュメント用のサンプルコードです
4. 実際のアプリケーションでは、FastAPIを使用して独自の画面やAPIを構築します
