---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全てのマッピングに根拠があり、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `fastapi/openapi/docs.py`（get_swagger_ui_html, get_redoc_html, get_swagger_ui_oauth2_redirect_html関数）
- E-04: `fastapi/applications.py`（FastAPIクラス、openapi関数）
- E-05: `fastapi/openapi/utils.py`（get_openapi関数）
- E-06: `docs_src/templates/templates/item.html`（Jinja2テンプレートサンプル）
- E-07: `fastapi/templating.py`（Jinja2Templates）
- E-08: `fastapi/staticfiles.py`（StaticFiles）
- E-09: `fastapi/security/oauth2.py`（OAuth2認証）
- E-10: `fastapi/encoders.py`（jsonable_encoder）
- E-11: `fastapi/responses.py`（HTMLResponse, JSONResponse）
- E-12: `fastapi/routing.py`（APIRouter）
- E-13: `fastapi/param_functions.py`（Path, Query等のパラメータ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Swagger UIはOpenAPIスキーマ生成機能を使用する | E-03, E-04, E-05 | ○ |
| C-02 | Swagger UIはSwagger UI機能（get_swagger_ui_html）を主機能として使用する | E-03 | ○ |
| C-03 | Swagger UIはOAuth2認証を補助機能として使用する | E-03, E-09 | ○ |
| C-04 | Swagger UIはOAuth2リダイレクト機能を補助機能として使用する | E-03 | ○ |
| C-05 | Swagger UIはjsonable_encoderを補助機能として使用する | E-03, E-10 | ○ |
| C-06 | Swagger UIはHTMLResponseを使用してAPI連携する | E-03, E-11 | ○ |
| C-07 | ReDocはOpenAPIスキーマ生成機能を使用する | E-03, E-04, E-05 | ○ |
| C-08 | ReDocはReDoc機能（get_redoc_html）を主機能として使用する | E-03 | ○ |
| C-09 | ReDocはHTMLResponseを使用してAPI連携する | E-03, E-11 | ○ |
| C-10 | OAuth2リダイレクト画面はOAuth2リダイレクト機能を主機能として使用する | E-03 | ○ |
| C-11 | OAuth2リダイレクト画面はOAuth2認証を補助機能として使用する | E-03, E-09 | ○ |
| C-12 | OAuth2リダイレクト画面はHTMLResponseを使用してAPI連携する | E-03, E-11 | ○ |
| C-13 | アイテム詳細画面はJinja2Templatesを主機能として使用する | E-06, E-07 | ○ |
| C-14 | アイテム詳細画面はStaticFilesを補助機能として使用する | E-06, E-08 | ○ |
| C-15 | アイテム詳細画面はPathパラメータを補助機能として使用する | E-06, E-13 | ○ |
| C-16 | アイテム詳細画面はHTMLResponseを使用してAPI連携する | E-06, E-11 | ○ |
| C-17 | OpenAPI JSONはOpenAPIスキーマ生成を主機能として使用する | E-04, E-05 | ○ |
| C-18 | OpenAPI JSONはFastAPIアプリケーション設定を補助機能として使用する | E-04 | ○ |
| C-19 | OpenAPI JSONはAPIRouterの情報を補助機能として使用する | E-04, E-12 | ○ |
| C-20 | OpenAPI JSONはJSONResponseを使用してAPI連携する | E-04, E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 補足：画面一覧と機能一覧が既に生成されており、それらの情報を基にマッピングを作成したため、全ての主張に根拠があります

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのマッピングがソースコードと既存ドキュメントに基づいて検証済み
- 注意点：サンプルコード（docs_src/templates/）は本番コードではなくドキュメント用サンプルであるため、実際のアプリケーションでの使用時は確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧の全5画面に対するマッピングが網羅されているか確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
- [ ] 機能一覧の機能Noと機能名が正確に参照されているか確認
- [ ] 関連する操作・処理の説明がソースコードの実装と一致しているか確認
