# 画面設計書 1-Swagger UI

## 概要

本ドキュメントは、FastAPIフレームワークが提供するSwagger UIベースのインタラクティブAPIドキュメント画面の設計仕様を記載する。

### 本画面の処理概要

Swagger UIは、OpenAPI仕様に基づいてAPIエンドポイントを視覚的に表示し、ブラウザ上から直接APIをテスト実行できるインタラクティブなドキュメント画面である。

**業務上の目的・背景**：API開発において、フロントエンド開発者やAPI利用者がエンドポイントの仕様を正確に把握し、実際にリクエストを送信してレスポンスを確認できる環境が必要である。Swagger UIは、OpenAPIスキーマを自動的に読み込み、各エンドポイントのパラメータ、リクエストボディ、レスポンス形式を視覚化することで、APIドキュメントの作成コストを削減し、開発者間のコミュニケーションを効率化する。

**画面へのアクセス方法**：FastAPIアプリケーションのベースURL + `/docs` でアクセス可能。例えば `http://localhost:8000/docs` でSwagger UIが表示される。`openapi_url`設定がNoneの場合は自動的に無効化される。

**主要な操作・処理内容**：
1. OpenAPIスキーマ（/openapi.json）の自動読み込みと画面表示
2. 各APIエンドポイントの展開・折りたたみ表示
3. パラメータ入力フォームへの値入力
4. 「Try it out」ボタンによるAPIの実行テスト
5. リクエスト/レスポンスの詳細表示
6. OAuth2認証フローの実行（Authorizeボタン）

**画面遷移**：
- 遷移元: ルート画面、直接URLアクセス
- 遷移先: OAuth2リダイレクト画面（認証フロー時）、各APIエンドポイント（テスト実行時）
- 関連画面: OpenAPI JSON（スキーマ読み込み元）

**権限による表示制御**：Swagger UI自体へのアクセス制御はFastAPIのデフォルトでは行われない。ただし、OAuth2認証を設定している場合、認証が必要なエンドポイントのテスト実行時には認証トークンの取得が必要となる。`docs_url=None`を設定することで、画面自体を無効化可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | OpenAPIスキーマ生成 | 主機能 | Swagger UIの表示に必要なOpenAPIスキーマを生成。/openapi.jsonから取得したスキーマを基にAPIドキュメントを動的に構築 |
| 21 | Swagger UI | 主機能 | /docsエンドポイントでインタラクティブなAPIドキュメント画面を表示。get_swagger_ui_html関数でHTML生成 |
| 13 | OAuth2認証 | 補助機能 | Swagger UI上でOAuth2認証フローをテスト可能。認証トークンの取得と保持 |
| 23 | OAuth2リダイレクト | 補助機能 | Swagger UIからのOAuth2認証時のリダイレクト処理をサポート |
| 32 | jsonable_encoder | 補助機能 | Swagger UIの設定パラメータをJSON互換形式に変換 |
| 3 | Request/Response処理 | API連携 | HTMLResponseを使用してSwagger UIのHTML画面を返却 |

## 画面種別

ドキュメント / インタラクティブテスト

## URL/ルーティング

| パス | HTTPメソッド | 説明 |
|------|-------------|------|
| `/docs` | GET | Swagger UI画面を表示（デフォルト） |

※ `docs_url`パラメータで変更可能（例: `FastAPI(docs_url="/documentation")`）

## 入出力項目

### リクエスト（画面表示時）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| - | - | - | パラメータなし（GETリクエスト） |

### 画面上の入力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| パスパラメータ | 各種 | APIエンドポイントで定義されたパスパラメータ |
| クエリパラメータ | 各種 | APIエンドポイントで定義されたクエリパラメータ |
| リクエストボディ | JSON | APIエンドポイントで定義されたリクエストボディ |
| ヘッダー | 文字列 | カスタムヘッダー値 |
| 認証情報 | 各種 | OAuth2トークン、APIキー等 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| タイトル | アプリケーション名 + " - Swagger UI" |
| バージョン | OpenAPIスキーマで定義されたAPIバージョン |
| 説明 | APIの概要説明（description） |
| サーバー選択 | 利用可能なサーバーURL一覧 |
| エンドポイント一覧 | HTTPメソッド、パス、概要の一覧 |
| タグ | エンドポイントをグループ化するタグ |
| スキーマ | リクエスト/レスポンスのデータ構造定義 |

## イベント仕様

### 1-画面初期表示

1. ブラウザが`/docs`にGETリクエストを送信
2. FastAPIが`swagger_ui_html`関数を実行
3. `get_swagger_ui_html`関数がHTML文字列を生成
4. HTMLResponseとしてブラウザに返却
5. ブラウザがSwagger UI JavaScriptを読み込み
6. JavaScriptが`/openapi.json`からスキーマを取得
7. スキーマに基づいてUIをレンダリング

### 2-APIテスト実行（Try it out）

1. ユーザーがエンドポイントを展開
2. 「Try it out」ボタンをクリック
3. パラメータを入力
4. 「Execute」ボタンをクリック
5. Swagger UIがAPIリクエストを送信
6. レスポンスを受信して画面に表示

### 3-OAuth2認証（Authorize）

1. 「Authorize」ボタンをクリック
2. 認証ダイアログが表示
3. 認証情報を入力
4. OAuth2プロバイダーにリダイレクト
5. `/docs/oauth2-redirect`で認証コードを受信
6. トークンを取得してSwagger UIに保存

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | Swagger UI自体はデータベースを使用しない |

※ APIテスト実行時は、各エンドポイントの仕様に従う

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 情報 | "Loading..." | OpenAPIスキーマ読み込み中 |
| エラー | "Failed to load API definition." | スキーマ読み込み失敗時 |
| 成功 | レスポンスコード（200等） | APIテスト成功時 |
| エラー | レスポンスコード（4xx, 5xx） | APIテストエラー時 |
| 警告 | "Authorization may be unsafe..." | OAuth2の状態不一致時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|----------|
| OpenAPIスキーマ取得失敗 | エラーメッセージを表示し、ドキュメント表示不可 |
| JavaScript読み込み失敗 | CDNからの読み込み失敗時、画面が正常に表示されない |
| 認証エラー | OAuth2認証失敗時、エラーメッセージを表示 |
| ネットワークエラー | APIテスト実行時の通信エラーを表示 |

## 備考

- Swagger UIのJavaScript/CSSはデフォルトでCDN（jsdelivr）から読み込まれる
- セルフホスティング環境では`swagger_js_url`、`swagger_css_url`パラメータでカスタマイズ可能
- `swagger_ui_parameters`でSwagger UIの動作をカスタマイズ可能（deepLinking、layout等）
- 本番環境では`docs_url=None`を設定してSwagger UIを無効化することが推奨される場合がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Swagger UIの設定パラメータと生成されるHTMLの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docs.py | `fastapi/openapi/docs.py` | swagger_ui_default_parameters（8-23行目）でデフォルト設定を確認 |

**読解のコツ**: `swagger_ui_default_parameters`はdict型で、Swagger UIの初期化パラメータを定義。`dom_id`、`layout`、`deepLinking`等の設定がSwagger UIの動作に影響する。

#### Step 2: エントリーポイントを理解する

FastAPIアプリケーション初期化時のSwagger UIルート登録処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | setup関数（1079-1130行目）でルート登録処理を確認 |

**主要処理フロー**:
1. **1093行目**: `if self.openapi_url and self.docs_url:` - OpenAPIとdocsが有効な場合のみ処理
2. **1095-1107行目**: `swagger_ui_html`関数を定義し、リクエスト時の処理を記述
3. **1109行目**: `self.add_route(self.docs_url, swagger_ui_html, ...)` - ルートを登録

#### Step 3: HTML生成処理を理解する

`get_swagger_ui_html`関数の実装を確認し、HTMLの生成ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docs.py | `fastapi/openapi/docs.py` | get_swagger_ui_html関数（26-158行目）でHTML生成処理を確認 |

**主要処理フロー**:
- **113行目**: デフォルトパラメータをコピー
- **114-115行目**: カスタムパラメータがあればマージ
- **117-133行目**: HTML文字列のベース部分を生成
- **135-136行目**: パラメータをJSON形式で展開
- **138-139行目**: OAuth2リダイレクトURLの設定
- **141-146行目**: SwaggerUIBundleの初期化スクリプト生成
- **148-151行目**: OAuth初期化処理の追加
- **158行目**: HTMLResponseとして返却

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ FastAPI.setup()  [applications.py:1079]
           │
           ├─ openapi()  [applications.py:1084]
           │      └─ JSONResponse(self.openapi())
           │
           ├─ swagger_ui_html()  [applications.py:1095]
           │      └─ get_swagger_ui_html()  [docs.py:26]
           │             ├─ swagger_ui_default_parameters.copy()
           │             ├─ jsonable_encoder()  [encoders.py]
           │             └─ HTMLResponse()  [starlette.responses]
           │
           └─ swagger_ui_redirect()  [applications.py:1113]
                  └─ get_swagger_ui_oauth2_redirect_html()  [docs.py:256]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTPリクエスト            FastAPI.setup()                  HTMLResponse
GET /docs ──────────────▶ swagger_ui_html() ─────────────▶ Swagger UI HTML
                               │
                               ▼
                         get_swagger_ui_html()
                               │
                               ▼
                         HTML文字列生成
                         （CSS/JSのCDN URL、
                           OpenAPI URL、
                           設定パラメータを埋め込み）

Swagger UI (ブラウザ)    JavaScript処理                   API呼び出し
画面読み込み ───────────▶ SwaggerUIBundle.init() ────────▶ GET /openapi.json
                               │
                               ▼
                         スキーマ解析・UI描画
                               │
                               ▼
ユーザー操作              Try it out                      APIエンドポイント
(Execute) ─────────────▶ fetch() ─────────────────────▶ 各APIエンドポイント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docs.py | `fastapi/openapi/docs.py` | ソース | Swagger UI/ReDoc/OAuth2リダイレクトのHTML生成関数 |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリケーションクラス、ルーティング設定 |
| encoders.py | `fastapi/encoders.py` | ソース | jsonable_encoder関数（設定値のJSON変換） |
| responses.py | `starlette/responses.py` | 外部ライブラリ | HTMLResponse、JSONResponseクラス |
| swagger-ui-bundle.js | CDN | 外部リソース | Swagger UIのJavaScriptライブラリ |
| swagger-ui.css | CDN | 外部リソース | Swagger UIのスタイルシート |
