# 画面設計書 2-ReDoc

## 概要

本ドキュメントは、FastAPIフレームワークが提供するReDocベースの代替APIドキュメント画面の設計仕様を記載する。

### 本画面の処理概要

ReDocは、OpenAPI仕様に基づいてAPIドキュメントを読みやすい形式で表示する代替ドキュメント画面である。Swagger UIと比較して、より静的でドキュメント閲覧に特化したインターフェースを提供する。

**業務上の目的・背景**：API仕様のドキュメントを提供する際、開発者によってはSwagger UIのインタラクティブな機能よりも、シンプルで読みやすいドキュメント形式を好む場合がある。ReDocは、OpenAPIスキーマを美しく整形されたドキュメントとして表示し、APIの仕様を理解するための閲覧体験を重視している。三カラムレイアウトにより、エンドポイント一覧、詳細説明、リクエスト/レスポンス例を同時に確認できる。

**画面へのアクセス方法**：FastAPIアプリケーションのベースURL + `/redoc` でアクセス可能。例えば `http://localhost:8000/redoc` でReDocが表示される。`openapi_url`設定がNoneの場合は自動的に無効化される。

**主要な操作・処理内容**：
1. OpenAPIスキーマ（/openapi.json）の自動読み込みと画面表示
2. 左サイドバーでのAPIエンドポイント一覧のナビゲーション
3. エンドポイント詳細の表示（パラメータ、リクエストボディ、レスポンス）
4. 検索機能によるエンドポイントの絞り込み
5. コードサンプルの表示（各種言語対応）
6. スキーマ定義の展開・折りたたみ表示

**画面遷移**：
- 遷移元: ルート画面、直接URLアクセス
- 遷移先: なし（ReDocは閲覧専用のため画面遷移なし）
- 関連画面: OpenAPI JSON（スキーマ読み込み元）

**権限による表示制御**：ReDoc自体へのアクセス制御はFastAPIのデフォルトでは行われない。`redoc_url=None`を設定することで、画面自体を無効化可能。認証保護が必要な場合は、ミドルウェアやルートの依存関係で制御する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | OpenAPIスキーマ生成 | 主機能 | ReDocの表示に必要なOpenAPIスキーマを生成。/openapi.jsonから取得したスキーマを基にドキュメントを構築 |
| 22 | ReDoc | 主機能 | /redocエンドポイントで読みやすいAPIドキュメント画面を表示。get_redoc_html関数でHTML生成 |
| 3 | Request/Response処理 | API連携 | HTMLResponseを使用してReDocのHTML画面を返却 |

## 画面種別

ドキュメント / 閲覧専用

## URL/ルーティング

| パス | HTTPメソッド | 説明 |
|------|-------------|------|
| `/redoc` | GET | ReDoc画面を表示（デフォルト） |

※ `redoc_url`パラメータで変更可能（例: `FastAPI(redoc_url="/redocumentation")`）

## 入出力項目

### リクエスト（画面表示時）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| - | - | - | パラメータなし（GETリクエスト） |

### 画面上の入力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 検索キーワード | 文字列 | エンドポイントを絞り込むための検索文字列 |

※ ReDocは閲覧専用のため、APIテスト実行用の入力項目はない

## 表示項目

| 項目名 | 説明 |
|--------|------|
| タイトル | アプリケーション名 + " - ReDoc" |
| バージョン | OpenAPIスキーマで定義されたAPIバージョン |
| 説明 | APIの概要説明（description） |
| 左サイドバー | エンドポイント一覧のナビゲーションメニュー |
| 中央ペイン | 選択したエンドポイントの詳細説明 |
| 右ペイン | リクエスト/レスポンス例とコードサンプル |
| スキーマ定義 | データモデルの構造定義 |
| タグ | エンドポイントをグループ化するタグ |

## イベント仕様

### 1-画面初期表示

1. ブラウザが`/redoc`にGETリクエストを送信
2. FastAPIが`redoc_html`関数を実行
3. `get_redoc_html`関数がHTML文字列を生成
4. HTMLResponseとしてブラウザに返却
5. ブラウザがReDoc JavaScriptを読み込み
6. JavaScriptが`/openapi.json`からスキーマを取得
7. スキーマに基づいてドキュメントをレンダリング

### 2-エンドポイント選択

1. ユーザーが左サイドバーでエンドポイントをクリック
2. 中央ペインに詳細情報をスクロール表示
3. URLフラグメントが更新（deep linking対応）

### 3-検索実行

1. ユーザーが検索ボックスにキーワードを入力
2. 左サイドバーのエンドポイント一覧がフィルタリング
3. マッチするエンドポイントのみ表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | ReDocはデータベースを使用しない |

※ ReDocは閲覧専用の静的ドキュメント表示であり、データベース操作は発生しない

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 情報 | "Loading..." | OpenAPIスキーマ読み込み中 |
| エラー | "Failed to load API definition." | スキーマ読み込み失敗時 |
| 警告 | "ReDoc requires Javascript to function." | JavaScriptが無効な場合（noscriptタグ） |

## 例外処理

| 例外状況 | 処理内容 |
|---------|----------|
| OpenAPIスキーマ取得失敗 | エラーメッセージを表示し、ドキュメント表示不可 |
| JavaScript読み込み失敗 | CDNからの読み込み失敗時、画面が正常に表示されない |
| JavaScript無効 | noscriptタグ内のメッセージを表示 |

## 備考

- ReDocのJavaScriptはデフォルトでCDN（jsdelivr）から読み込まれる
- セルフホスティング環境では`redoc_js_url`パラメータでカスタマイズ可能
- `with_google_fonts`パラメータでGoogle Fontsの読み込みを制御可能（デフォルトTrue）
- ReDocはSwagger UIと異なり、APIのテスト実行機能は持たない
- 閲覧用ドキュメントとして、PDFやHTML出力用途にも適している

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ReDocが生成するHTMLの構造とカスタマイズ可能なパラメータを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docs.py | `fastapi/openapi/docs.py` | get_redoc_html関数のパラメータ定義（161-208行目） |

**読解のコツ**: ReDocはSwagger UIと比較してシンプルな構造。主要パラメータは`openapi_url`、`title`、`redoc_js_url`、`redoc_favicon_url`、`with_google_fonts`の5つ。

#### Step 2: エントリーポイントを理解する

FastAPIアプリケーション初期化時のReDocルート登録処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | setup関数内のReDoc設定（1121-1130行目） |

**主要処理フロー**:
1. **1121行目**: `if self.openapi_url and self.redoc_url:` - OpenAPIとredocが有効な場合のみ処理
2. **1123-1128行目**: `redoc_html`関数を定義し、リクエスト時の処理を記述
3. **1130行目**: `self.add_route(self.redoc_url, redoc_html, ...)` - ルートを登録

#### Step 3: HTML生成処理を理解する

`get_redoc_html`関数の実装を確認し、HTMLの生成ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docs.py | `fastapi/openapi/docs.py` | get_redoc_html関数（161-253行目）でHTML生成処理を確認 |

**主要処理フロー**:
- **219-227行目**: HTML文字列のhead部分を生成（title、メタタグ）
- **228-231行目**: Google Fonts読み込みの条件分岐
- **232-243行目**: favicon、スタイル設定を追加
- **244-247行目**: noscript警告メッセージ
- **248行目**: `<redoc spec-url="{openapi_url}">` - ReDocコンポーネントの配置
- **249行目**: ReDoc JavaScriptの読み込み
- **253行目**: HTMLResponseとして返却

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ FastAPI.setup()  [applications.py:1079]
           │
           └─ redoc_html()  [applications.py:1123]
                  └─ get_redoc_html()  [docs.py:161]
                         ├─ HTML文字列構築
                         │    ├─ <title>タグ生成
                         │    ├─ Google Fonts読み込み（条件付き）
                         │    ├─ <redoc>コンポーネント配置
                         │    └─ ReDoc JS読み込み
                         │
                         └─ HTMLResponse()  [starlette.responses]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTPリクエスト            FastAPI.setup()                  HTMLResponse
GET /redoc ─────────────▶ redoc_html() ──────────────────▶ ReDoc HTML
                               │
                               ▼
                         get_redoc_html()
                               │
                               ▼
                         HTML文字列生成
                         （JSのCDN URL、
                           OpenAPI URL、
                           Google Fonts設定を埋め込み）

ReDoc (ブラウザ)         JavaScript処理                   画面表示
画面読み込み ───────────▶ ReDoc初期化 ───────────────────▶ GET /openapi.json
                               │
                               ▼
                         スキーマ解析・UI描画
                               │
                               ▼
ユーザー操作              ナビゲーション                   表示更新
(エンドポイント選択) ───▶ 画面スクロール ────────────────▶ URLフラグメント更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docs.py | `fastapi/openapi/docs.py` | ソース | get_redoc_html関数でReDoc HTMLを生成 |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリケーションクラス、ルーティング設定 |
| responses.py | `starlette/responses.py` | 外部ライブラリ | HTMLResponseクラス |
| redoc.standalone.js | CDN | 外部リソース | ReDocのJavaScriptライブラリ |
| Google Fonts | CDN | 外部リソース | Montserrat、Robotoフォント（オプション） |
