# 画面設計書 3-OAuth2リダイレクト

## 概要

本ドキュメントは、FastAPIフレームワークが提供するSwagger UIのOAuth2認証フロー用リダイレクト画面の設計仕様を記載する。

### 本画面の処理概要

OAuth2リダイレクト画面は、Swagger UIからOAuth2認証を実行した際に、認証プロバイダーからのコールバックを受け取り、認証コードまたはトークンをSwagger UIに引き渡すための中継画面である。この画面は通常ユーザーに表示されることはなく、バックグラウンドで自動的に処理が行われる。

**業務上の目的・背景**：OAuth2認証フローにおいて、認証プロバイダー（Google、GitHub、Auth0等）はユーザー認証後に指定されたリダイレクトURIにコールバックを送信する。Swagger UIで認証済みのAPIをテストするためには、このコールバックを適切に処理し、取得したトークンをSwagger UIに渡す仕組みが必要である。この画面はSwagger UI公式のoauth2-redirect.htmlをベースに、そのブリッジ役を担っている。

**画面へのアクセス方法**：通常、ユーザーが直接アクセスすることはない。Swagger UIの「Authorize」ボタンからOAuth2認証フローを開始すると、認証プロバイダーでの認証後に自動的にリダイレクトされる。デフォルトURLは `/docs/oauth2-redirect`。

**主要な操作・処理内容**：
1. 認証プロバイダーからのリダイレクトコールバックを受信
2. URLのハッシュフラグメントまたはクエリパラメータから認証コード/トークンを抽出
3. 状態（state）パラメータの検証によるCSRF対策
4. 親ウィンドウ（Swagger UI）への認証情報の引き渡し
5. ポップアップウィンドウの自動クローズ

**画面遷移**：
- 遷移元: 認証プロバイダー（Google、GitHub等）からのリダイレクト
- 遷移先: なし（ウィンドウが自動的にクローズ）
- 親画面: Swagger UI（認証情報を受け取る）

**権限による表示制御**：この画面自体には特別な権限制御はない。OAuth2認証フローの一部として機能し、認証の可否は認証プロバイダーと各APIエンドポイントの設定に依存する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | OAuth2リダイレクト | 主機能 | Swagger UIからのOAuth2認証フローで使用されるリダイレクト画面。get_swagger_ui_oauth2_redirect_html関数でHTML生成 |
| 13 | OAuth2認証 | 補助機能 | OAuth2認証コードの受け取りとトークン交換処理をサポート |
| 3 | Request/Response処理 | API連携 | HTMLResponseを使用してリダイレクト画面を返却 |

## 画面種別

認証 / リダイレクト処理

## URL/ルーティング

| パス | HTTPメソッド | 説明 |
|------|-------------|------|
| `/docs/oauth2-redirect` | GET | OAuth2リダイレクトを処理（デフォルト） |

※ `swagger_ui_oauth2_redirect_url`パラメータで変更可能

## 入出力項目

### リクエスト（リダイレクト時）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| code | 文字列 | 条件付き | Authorization Codeフロー時の認証コード |
| token | 文字列 | 条件付き | Implicit Grantフロー時のアクセストークン |
| state | 文字列 | 必須 | CSRF対策用の状態パラメータ |
| error | 文字列 | 条件付き | 認証エラー時のエラーコード |
| error_description | 文字列 | 条件付き | 認証エラー時のエラー説明 |
| error_uri | 文字列 | 条件付き | 認証エラー時の詳細情報URI |

### 出力（親ウィンドウへのコールバック）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| auth | オブジェクト | 認証情報（認証コードまたはトークン） |
| redirectUrl | 文字列 | リダイレクト先URL |
| isValid | 真偽値 | 状態パラメータの検証結果 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| タイトル | "Swagger UI: OAuth2 Redirect" |

※ この画面は視覚的なUIを持たず、JavaScriptによる処理のみを行う

## イベント仕様

### 1-リダイレクト受信とトークン処理

1. 認証プロバイダーから`/docs/oauth2-redirect`にリダイレクト
2. `get_swagger_ui_oauth2_redirect_html`関数がHTMLを生成
3. HTMLResponseとしてブラウザに返却
4. ブラウザがJavaScriptを実行

### 2-JavaScript処理（run関数）

1. `window.opener.swaggerUIRedirectOauth2`から親ウィンドウの認証オブジェクトを取得
2. URLのハッシュフラグメントまたはクエリパラメータを解析
3. パラメータをJSONオブジェクトに変換
4. 状態（state）パラメータを検証
5. フロータイプに応じた処理分岐:
   - **Authorization Codeフロー**: 認証コードを親ウィンドウにコールバック
   - **Implicit Grantフロー**: トークンを親ウィンドウにコールバック
6. エラーがあればエラーコールバックを実行
7. `window.close()`でポップアップを閉じる

### 3-状態パラメータの検証

1. 受信したstateパラメータを取得
2. 親ウィンドウに保存されている期待値（sentState）と比較
3. 不一致の場合、CSRF攻撃の可能性を警告
4. ただしフローは継続（警告のみ）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | OAuth2リダイレクト画面はデータベースを使用しない |

※ 認証トークンの保存は親ウィンドウ（Swagger UI）のメモリ上で行われる

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 警告 | "Authorization may be unsafe, passed state was changed in server. The passed state wasn't returned from auth server." | 状態パラメータ不一致時 |
| エラー | "[{error}]: {error_description}. {error_uri}" | 認証プロバイダーからエラーが返された場合 |
| エラー | "[Authorization failed]: no accessCode received from the server." | 認証コードが取得できなかった場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|----------|
| 状態パラメータ不一致 | 警告メッセージをエラーコールバック経由で表示、処理は継続 |
| 認証コード/トークン未取得 | エラーコールバックを実行、エラーメッセージを表示 |
| 認証プロバイダーからのエラー | エラーコードと説明をエラーコールバック経由で表示 |
| 親ウィンドウ参照不可 | JavaScript実行時エラー（親ウィンドウが閉じられている場合等） |

## 備考

- このHTMLはSwagger UI公式の`oauth2-redirect.html`（v4.14.0）をベースにしている
- 対応するOAuth2フロー：Authorization Code（accessCode）、Implicit Grant
- 親ウィンドウとの通信は`window.opener`経由で行われる
- ポップアップブロッカーが有効な場合、認証フローが中断される可能性がある
- セキュリティ上、状態パラメータの検証は重要だが、不一致時も処理を継続する設計

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OAuth2認証フローで受け渡されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docs.py | `fastapi/openapi/docs.py` | get_swagger_ui_oauth2_redirect_html関数内のJavaScript（256-344行目） |

**読解のコツ**: JavaScriptコード内の`oauth2`オブジェクトが中心的なデータ構造。`state`、`redirectUrl`、`auth`、`callback`、`errCb`プロパティを持つ。

#### Step 2: エントリーポイントを理解する

FastAPIアプリケーション初期化時のOAuth2リダイレクトルート登録処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | setup関数内のOAuth2リダイレクト設定（1111-1120行目） |

**主要処理フロー**:
1. **1111行目**: `if self.swagger_ui_oauth2_redirect_url:` - OAuth2リダイレクトURLが設定されている場合のみ
2. **1113-1114行目**: `swagger_ui_redirect`関数を定義
3. **1116-1119行目**: ルートを登録（`include_in_schema=False`でOpenAPIスキーマから除外）

#### Step 3: JavaScript処理ロジックを理解する

リダイレクト画面のJavaScript処理の詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docs.py | `fastapi/openapi/docs.py` | run関数の実装（272-331行目） |

**主要処理フロー**:
- **273-276行目**: 親ウィンドウから認証オブジェクトと状態を取得
- **278-282行目**: URLハッシュまたはクエリパラメータを解析
- **284-290行目**: パラメータをJSONオブジェクトに変換
- **292行目**: 状態パラメータの検証
- **294-298行目**: フロータイプの判定（accessCode、authorizationCode、authorization_code）
- **299-311行目**: 状態不一致時の警告処理
- **308-311行目**: 認証コード取得時のコールバック
- **312-326行目**: エラー処理
- **327-329行目**: Implicit Grantフロー時のコールバック
- **330行目**: ウィンドウクローズ

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ FastAPI.setup()  [applications.py:1079]
           │
           └─ swagger_ui_redirect()  [applications.py:1113]
                  └─ get_swagger_ui_oauth2_redirect_html()  [docs.py:256]
                         └─ HTMLResponse(html)  [starlette.responses]
                                │
                                ▼
                         [ブラウザでのJavaScript実行]
                                │
                                ├─ run()
                                │    ├─ window.opener.swaggerUIRedirectOauth2 取得
                                │    ├─ URLパラメータ解析
                                │    ├─ 状態検証
                                │    ├─ oauth2.callback() または oauth2.errCb()
                                │    └─ window.close()
                                │
                                └─ DOMContentLoaded イベント
                                     └─ run()
```

### データフロー図

```
[認証プロバイダー]         [OAuth2リダイレクト画面]        [Swagger UI]

認証完了後                  JavaScript処理                 親ウィンドウ
リダイレクト ─────────────▶ URLパラメータ解析 ───────────▶ oauth2.callback()
?code=xxx&state=yyy              │                              │
                                 ▼                              ▼
                         状態パラメータ検証                トークン保存
                                 │                              │
                                 ▼                              ▼
                         window.close()                   認証状態更新


[エラーケース]

認証エラー                 JavaScript処理                 Swagger UI
リダイレクト ─────────────▶ エラー情報解析 ────────────▶ oauth2.errCb()
?error=xxx&error_description=yyy                              │
                                                              ▼
                                                        エラー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docs.py | `fastapi/openapi/docs.py` | ソース | get_swagger_ui_oauth2_redirect_html関数でOAuth2リダイレクトHTMLを生成 |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリケーションクラス、OAuth2リダイレクトルート登録 |
| responses.py | `starlette/responses.py` | 外部ライブラリ | HTMLResponseクラス |
| swagger-ui-bundle.js | CDN（親画面） | 外部リソース | Swagger UIのOAuth2機能（window.opener経由で連携） |
