# 画面設計書 5-OpenAPI JSON

## 概要

本ドキュメントは、FastAPIフレームワークが提供するOpenAPI仕様のJSONスキーマを返すエンドポイントの設計仕様を記載する。

### 本画面の処理概要

OpenAPI JSONエンドポイントは、FastAPIアプリケーションのAPI仕様をOpenAPI 3.1.0形式のJSONスキーマとして返却する。このスキーマは、Swagger UIやReDocなどのドキュメント生成ツール、APIクライアント自動生成ツール、テストツールなど、様々なツールで利用される。ブラウザで直接アクセスすると、JSON形式のAPIスキーマが表示される。

**業務上の目的・背景**：OpenAPIスキーマは、API仕様の標準化と自動化において中心的な役割を果たす。このスキーマにより、APIドキュメントの自動生成、クライアントSDKの自動生成、APIの互換性チェック、テストの自動化などが可能となる。FastAPIは、Pythonの型ヒントとPydanticモデルから自動的にOpenAPIスキーマを生成することで、開発者の負担を軽減しながら正確なAPI仕様を維持する。

**画面へのアクセス方法**：FastAPIアプリケーションのベースURL + `/openapi.json` でアクセス可能。例えば `http://localhost:8000/openapi.json` でスキーマが取得できる。`openapi_url`パラメータで変更可能（例: `/api/v1/openapi.json`）。

**主要な操作・処理内容**：
1. FastAPIアプリケーションに登録された全ルートの解析
2. Pydanticモデルからのスキーマ定義の生成
3. セキュリティスキーム（認証設定）の収集
4. OpenAPI 3.1.0形式のJSONオブジェクト構築
5. JSONResponseとしての返却

**画面遷移**：
- 遷移元: Swagger UI（スキーマ読み込み）、ReDoc（スキーマ読み込み）、直接URLアクセス
- 遷移先: なし（データ返却のみ）
- 関連画面: Swagger UI、ReDoc（このスキーマを使用してUIを構築）

**権限による表示制御**：OpenAPI JSONエンドポイント自体へのアクセス制御はFastAPIのデフォルトでは行われない。`openapi_url=None`を設定することで、エンドポイントを無効化可能。本番環境でAPI仕様を非公開にしたい場合は、このオプションを使用するか、認証ミドルウェアを追加する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | OpenAPIスキーマ生成 | 主機能 | /openapi.jsonエンドポイントでOpenAPI仕様のJSONスキーマを返却。get_openapi関数でスキーマ生成 |
| 1 | FastAPIアプリケーション | 補助機能 | FastAPIアプリケーションの設定（タイトル、バージョン、説明等）をOpenAPIスキーマに反映 |
| 2 | APIRouter | 補助機能 | 登録されたすべてのルーター・エンドポイント情報をOpenAPIスキーマに含める |
| 3 | Request/Response処理 | API連携 | JSONResponseを使用してOpenAPIスキーマをJSON形式で返却 |

## 画面種別

API / スキーマ

## URL/ルーティング

| パス | HTTPメソッド | 説明 |
|------|-------------|------|
| `/openapi.json` | GET | OpenAPIスキーマをJSON形式で返却（デフォルト） |

※ `openapi_url`パラメータで変更可能（例: `FastAPI(openapi_url="/api/v1/openapi.json")`）

## 入出力項目

### リクエスト（スキーマ取得時）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| - | - | - | パラメータなし（GETリクエスト） |

### 出力（レスポンス）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Content-Type | ヘッダー | application/json |
| Body | JSON | OpenAPI 3.1.0形式のスキーマ |

## 表示項目

OpenAPIスキーマの主要な構成要素：

| 項目名 | JSONパス | 説明 |
|--------|----------|------|
| OpenAPIバージョン | openapi | OpenAPI仕様のバージョン（デフォルト: "3.1.0"） |
| API情報 | info | タイトル、バージョン、説明等のメタ情報 |
| サーバー | servers | 利用可能なサーバーURL一覧 |
| パス | paths | APIエンドポイントの定義 |
| コンポーネント | components | スキーマ定義、セキュリティスキーム等 |
| タグ | tags | エンドポイントのグループ化情報 |
| 外部ドキュメント | externalDocs | 追加のドキュメントへのリンク |
| Webhooks | webhooks | Webhook定義（OpenAPI 3.1.0の機能） |

## イベント仕様

### 1-スキーマ取得リクエスト

1. クライアント（ブラウザ、Swagger UI等）が`/openapi.json`にGETリクエストを送信
2. FastAPIが`openapi`関数を実行
3. `root_path`をサーバー情報に追加（必要な場合）
4. `self.openapi()`メソッドを呼び出してスキーマを生成
5. JSONResponseとしてクライアントに返却

### 2-スキーマ生成処理（内部）

1. `get_openapi`関数を呼び出し
2. アプリケーションの基本情報（title、version、description等）を収集
3. 登録されたすべてのルートを走査
4. 各ルートのパス、パラメータ、リクエストボディ、レスポンスを解析
5. Pydanticモデルからスキーマ定義を生成
6. セキュリティスキームを収集
7. OpenAPIオブジェクトを構築
8. `jsonable_encoder`でJSON互換形式に変換

### 3-キャッシュ機構

1. 初回リクエスト時にスキーマを生成
2. `self.openapi_schema`に生成結果をキャッシュ
3. 2回目以降のリクエストではキャッシュを返却
4. アプリケーション再起動までキャッシュが有効

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | OpenAPIスキーマ生成はデータベースを使用しない |

※ スキーマはアプリケーションのルート定義とPydanticモデルから動的に生成される

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| - | - | JSONデータのため表示メッセージなし |

## 例外処理

| 例外状況 | 処理内容 |
|---------|----------|
| openapi_url=None | エンドポイント自体が登録されない |
| title未設定 | AssertionError: "A title must be provided for OpenAPI" |
| version未設定 | AssertionError: "A version must be provided for OpenAPI" |
| スキーマ生成エラー | 500 Internal Server Error（Pydanticモデルのバリデーションエラー等） |

## 備考

- FastAPIはOpenAPI 3.1.0を生成（`openapi_version`属性で変更可能）
- スキーマはアプリケーション起動後に自動的に生成される
- キャッシュ機構により、2回目以降のリクエストは高速
- `app.openapi_schema`に直接値を設定することでスキーマをカスタマイズ可能
- `include_in_schema=False`を設定したルートはスキーマに含まれない
- Pydanticモデルの`json_schema_extra`でスキーマを拡張可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OpenAPIスキーマの構造と、FastAPIがどのようにスキーマを構築するかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | utils.py | `fastapi/openapi/utils.py` | get_openapi関数の戻り値構造（476-567行目） |

**読解のコツ**: OpenAPIスキーマはネストしたdict構造。主要なキーは`openapi`、`info`、`paths`、`components`。`paths`配下に各エンドポイントの詳細が定義される。

#### Step 2: エントリーポイントを理解する

FastAPIアプリケーション初期化時のOpenAPIルート登録処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | setup関数内のOpenAPI設定（1080-1092行目） |

**主要処理フロー**:
1. **1080行目**: `if self.openapi_url:` - OpenAPIが有効な場合のみ処理
2. **1081-1082行目**: サーバーURLの収集
3. **1084-1090行目**: `openapi`関数を定義（root_pathの動的追加処理含む）
4. **1092行目**: `self.add_route(self.openapi_url, openapi, ...)` - ルートを登録

#### Step 3: スキーマ生成メソッドを理解する

`FastAPI.openapi()`メソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | applications.py | `fastapi/applications.py` | openapi関数（1046-1077行目） |

**主要処理フロー**:
- **1060行目**: `if not self.openapi_schema:` - キャッシュチェック
- **1061-1076行目**: `get_openapi`関数を呼び出してスキーマを生成
- **1077行目**: `return self.openapi_schema` - キャッシュを返却

#### Step 4: get_openapi関数を理解する

スキーマ生成の詳細ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | utils.py | `fastapi/openapi/utils.py` | get_openapi関数（476-567行目） |

**主要処理フロー**:
- **493-503行目**: info オブジェクトの構築
- **504-506行目**: output オブジェクトの初期化（openapi version、info）
- **507-510行目**: components、paths、operation_idsの初期化
- **511-517行目**: フィールド定義の収集とスキーマ定義の生成
- **518-536行目**: 各ルートの解析とパス定義の構築
- **556-559行目**: components（schemas、securitySchemes）の設定
- **560-566行目**: paths、webhooks、tags、externalDocsの設定
- **567行目**: jsonable_encoderでJSON互換形式に変換して返却

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ FastAPI.setup()  [applications.py:1079]
           │
           └─ openapi()  [applications.py:1084]
                  └─ JSONResponse(self.openapi())
                         │
                         └─ FastAPI.openapi()  [applications.py:1046]
                                │
                                └─ get_openapi()  [utils.py:476]
                                       ├─ info構築（title、version、description等）
                                       ├─ get_fields_from_routes()  [utils.py]
                                       ├─ get_compat_model_name_map()  [utils.py]
                                       ├─ get_definitions()  [utils.py]
                                       ├─ ルート走査
                                       │    └─ get_openapi_path()  [utils.py:259]
                                       │           ├─ get_openapi_operation_metadata()
                                       │           ├─ get_openapi_operation_request_body()
                                       │           └─ get_openapi_security_definitions()
                                       └─ jsonable_encoder()  [encoders.py]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTPリクエスト            FastAPI.setup()                  JSONResponse
GET /openapi.json ──────▶ openapi() ─────────────────────▶ OpenAPIスキーマ
                               │
                               ▼
                         FastAPI.openapi()
                               │
                               ├─ キャッシュチェック
                               │    └─ 存在する場合 ──▶ キャッシュを返却
                               │
                               └─ 存在しない場合
                                    │
                                    ▼
                              get_openapi()
                                    │
                                    ├─ アプリ設定（title、version等）
                                    ├─ 全ルート情報
                                    ├─ Pydanticモデル定義
                                    └─ セキュリティ設定
                                         │
                                         ▼
                                   OpenAPIスキーマ構築
                                         │
                                         ▼
                                   jsonable_encoder()
                                         │
                                         ▼
                                   JSON互換dict


[スキーマ利用フロー]

Swagger UI                OpenAPIスキーマ                  画面表示
/docs ──────────────────▶ GET /openapi.json ─────────────▶ UI構築
                                │
ReDoc                           │
/redoc ─────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| applications.py | `fastapi/applications.py` | ソース | FastAPIクラス、openapi()メソッド、setup()メソッド |
| utils.py | `fastapi/openapi/utils.py` | ソース | get_openapi関数、get_openapi_path関数等 |
| models.py | `fastapi/openapi/models.py` | ソース | OpenAPI、Info、PathItem等のPydanticモデル |
| encoders.py | `fastapi/encoders.py` | ソース | jsonable_encoder関数 |
| routing.py | `fastapi/routing.py` | ソース | APIRouteクラス、ルート情報の管理 |
| responses.py | `starlette/responses.py` | 外部ライブラリ | JSONResponseクラス |
