---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-Swagger_UI.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **本番環境でのSwagger UI無効化推奨**：ベストプラクティスとしての記載であり、コード上の明示的な根拠なし
  2. **OAuth2状態不一致時の警告メッセージ**：oauth2-redirect.htmlのJavaScriptコード内に存在するが、正確なメッセージ文言の確認要
  3. **CDN読み込み失敗時の動作**：ブラウザ側の挙動であり、FastAPIコード上では制御していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/openapi/docs.py` - get_swagger_ui_html関数（26-158行目）
- E-02: `fastapi/openapi/docs.py` - swagger_ui_default_parameters（8-23行目）
- E-03: `fastapi/openapi/docs.py` - get_swagger_ui_oauth2_redirect_html関数（256-344行目）
- E-04: `fastapi/applications.py` - setup関数（1079-1130行目）
- E-05: `fastapi/applications.py` - docs_url定義（404-427行目）
- E-06: `fastapi/applications.py` - openapi_url定義（205-227行目）
- E-07: `fastapi/applications.py` - swagger_ui_oauth2_redirect_url定義（452-464行目）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.1の機能マッピング
- E-09: `docs/code-to-docs/画面一覧/画面遷移図.md` - Swagger UIの遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトURLは/docs | E-05 | ○ |
| C-02 | get_swagger_ui_html関数でHTML生成 | E-01 | ○ |
| C-03 | OpenAPIスキーマは/openapi.jsonから取得 | E-01, E-06 | ○ |
| C-04 | openapi_url=Noneで自動無効化 | E-05 | ○ |
| C-05 | docs_url=Noneで画面無効化可能 | E-05 | ○ |
| C-06 | OAuth2リダイレクトURLは/docs/oauth2-redirect | E-07 | ○ |
| C-07 | swagger_ui_default_parametersにデフォルト設定 | E-02 | ○ |
| C-08 | CDNはjsdelivrを使用 | E-01 | ○ |
| C-09 | タイトルはアプリ名 + " - Swagger UI" | E-04 | ○ |
| C-10 | setup関数でルート登録 | E-04 | ○ |
| C-11 | HTMLResponseで返却 | E-01 | ○ |
| C-12 | jsonable_encoderでパラメータ変換 | E-01 | ○ |
| C-13 | OAuth2認証フローをサポート | E-03, E-04 | ○ |
| C-14 | swagger_ui_parametersでカスタマイズ可能 | E-01 | ○ |
| C-15 | swagger_js_url/swagger_css_urlでカスタマイズ可能 | E-01 | ○ |
| C-16 | 関連機能の機能NoとMappingは正確 | E-08 | ○ |
| C-17 | 画面遷移情報は正確 | E-09 | ○ |
| C-18 | 本番環境ではdocs_url=None推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18「本番環境でのSwagger UI無効化推奨」はセキュリティベストプラクティスとしての一般的な推奨事項であり、FastAPIのソースコードやドキュメントに明示的な記載がない
  - 候補：FastAPI公式ドキュメント / セキュリティガイドライン / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードに基づいており、信頼性が高い
- 1: 中リスク - OAuth2関連の詳細動作は実際の認証プロバイダーとの連携テストが必要
- 0: 低リスク - URL/ルーティング情報は設定値から直接取得しており正確

## 6) レビュアーチェックリスト（最小）
- [ ] C-18: 本番環境でのSwagger UI無効化推奨について、組織のセキュリティポリシーと照合
- [ ] OAuth2認証フローの動作確認（実際の認証プロバイダーとの連携テスト）
- [ ] CDN依存の確認（オフライン環境やセルフホスティング要件の有無）
- [ ] swagger_ui_parametersのカスタマイズ要件の確認
