---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-ReDoc.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、優先レビュー項目なし
  2. ReDocの三カラムレイアウトの詳細はReDocライブラリ側の実装に依存
  3. 検索機能の詳細動作はReDocライブラリの仕様を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/openapi/docs.py` - get_redoc_html関数（161-253行目）
- E-02: `fastapi/applications.py` - setup関数内ReDoc設定（1121-1130行目）
- E-03: `fastapi/applications.py` - redoc_url定義（428-451行目）
- E-04: `fastapi/applications.py` - openapi_url定義（205-227行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.2の機能マッピング
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - ReDocの遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトURLは/redoc | E-03 | ○ |
| C-02 | get_redoc_html関数でHTML生成 | E-01 | ○ |
| C-03 | OpenAPIスキーマは/openapi.jsonから取得 | E-01, E-04 | ○ |
| C-04 | openapi_url=Noneで自動無効化 | E-03 | ○ |
| C-05 | redoc_url=Noneで画面無効化可能 | E-03 | ○ |
| C-06 | CDNはjsdelivrを使用 | E-01 | ○ |
| C-07 | タイトルはアプリ名 + " - ReDoc" | E-02 | ○ |
| C-08 | HTMLResponseで返却 | E-01 | ○ |
| C-09 | with_google_fontsでフォント読み込み制御 | E-01 | ○ |
| C-10 | redoc_js_urlでカスタマイズ可能 | E-01 | ○ |
| C-11 | noscriptタグでJavaScript無効時の警告表示 | E-01 | ○ |
| C-12 | redoc_favicon_urlでファビコン設定可能 | E-01 | ○ |
| C-13 | 関連機能の機能NoとMappingは正確 | E-05 | ○ |
| C-14 | 画面遷移情報は正確 | E-06 | ○ |
| C-15 | setup関数でルート登録 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対応する根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいており、信頼性が高い
- 0: 低リスク - ReDocの外部ライブラリ依存部分はFastAPIの制御範囲外だが、標準的な使用方法

## 6) レビュアーチェックリスト（最小）
- [ ] ReDocのバージョン（redoc@2）が最新の安定版であることを確認
- [ ] Google Fontsの読み込みがプライバシーポリシーに適合しているか確認
- [ ] セルフホスティング環境での動作要件を確認（CDN依存の有無）
- [ ] ReDocの三カラムレイアウトが想定通りに表示されるか確認（レスポンシブ対応含む）
