---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-OAuth2リダイレクト.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、優先レビュー項目なし
  2. OAuth2フローの詳細動作は実際の認証プロバイダーとの連携テストで確認推奨
  3. 状態パラメータ不一致時の警告メッセージはJavaScriptコードに埋め込み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/openapi/docs.py` - get_swagger_ui_oauth2_redirect_html関数（256-344行目）
- E-02: `fastapi/openapi/docs.py` - run関数のJavaScript（272-331行目）
- E-03: `fastapi/applications.py` - setup関数内OAuth2リダイレクト設定（1111-1120行目）
- E-04: `fastapi/applications.py` - swagger_ui_oauth2_redirect_url定義（452-464行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.3の機能マッピング
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - OAuth2リダイレクトの遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトURLは/docs/oauth2-redirect | E-04 | ○ |
| C-02 | get_swagger_ui_oauth2_redirect_html関数でHTML生成 | E-01 | ○ |
| C-03 | Swagger UI v4.14.0のoauth2-redirect.htmlがベース | E-01（コメント262行目） | ○ |
| C-04 | window.opener経由で親ウィンドウと通信 | E-02 | ○ |
| C-05 | URLハッシュまたはクエリパラメータから認証情報を抽出 | E-02 | ○ |
| C-06 | 状態パラメータ（state）の検証を実施 | E-02 | ○ |
| C-07 | 状態不一致時は警告メッセージを表示 | E-02（299-306行目） | ○ |
| C-08 | 対応フロー：accessCode、authorizationCode、authorization_code | E-02（294-298行目） | ○ |
| C-09 | window.close()でポップアップを閉じる | E-02（330行目） | ○ |
| C-10 | HTMLResponseで返却 | E-01 | ○ |
| C-11 | include_in_schema=FalseでOpenAPIスキーマから除外 | E-03 | ○ |
| C-12 | エラー時はoauth2.errCbコールバックを実行 | E-02（300-305行目、320-325行目） | ○ |
| C-13 | 認証成功時はoauth2.callbackを実行 | E-02（311行目、328行目） | ○ |
| C-14 | タイトルは"Swagger UI: OAuth2 Redirect" | E-01（267行目） | ○ |
| C-15 | 関連機能の機能NoとMappingは正確 | E-05 | ○ |
| C-16 | 画面遷移情報は正確 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対応する根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいており、信頼性が高い
- 1: 中リスク - OAuth2フローの実動作は認証プロバイダーとの連携テストが必要
- 0: 低リスク - セキュリティ上重要な状態パラメータ検証がコードに実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] OAuth2認証フローの実際の動作を認証プロバイダー（Google、GitHub等）で確認
- [ ] ポップアップブロッカー有効時の挙動を確認
- [ ] 状態パラメータ不一致時の警告メッセージがユーザーに適切に伝わるか確認
- [ ] 親ウィンドウがクローズされた場合のエラーハンドリングを確認
- [ ] 複数の認証フロータイプ（Authorization Code、Implicit Grant）での動作確認
