---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-OpenAPI_JSON.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、優先レビュー項目なし
  2. OpenAPIスキーマのカスタマイズ方法は公式ドキュメントを参照推奨
  3. キャッシュ機構の動作確認（アプリケーション再起動時のリセット）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/applications.py` - setup関数内OpenAPI設定（1080-1092行目）
- E-02: `fastapi/applications.py` - openapi関数（1046-1077行目）
- E-03: `fastapi/applications.py` - openapi_url定義（205-227行目）
- E-04: `fastapi/applications.py` - openapi_version定義（874-904行目）
- E-05: `fastapi/applications.py` - タイトル・バージョン必須チェック（906-908行目）
- E-06: `fastapi/openapi/utils.py` - get_openapi関数（476-567行目）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.5の機能マッピング
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.5の情報
- E-09: `docs/code-to-docs/画面一覧/画面遷移図.md` - OpenAPI JSONの遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトURLは/openapi.json | E-03 | ○ |
| C-02 | get_openapi関数でスキーマ生成 | E-02, E-06 | ○ |
| C-03 | OpenAPIバージョンはデフォルト3.1.0 | E-04 | ○ |
| C-04 | openapi_url=Noneでエンドポイント無効化 | E-03 | ○ |
| C-05 | title未設定時にAssertionError | E-05 | ○ |
| C-06 | version未設定時にAssertionError | E-05 | ○ |
| C-07 | JSONResponseで返却 | E-01 | ○ |
| C-08 | setup関数でルート登録 | E-01 | ○ |
| C-09 | キャッシュ機構（openapi_schema属性） | E-02 | ○ |
| C-10 | root_pathをサーバー情報に追加 | E-01 | ○ |
| C-11 | include_in_schema=Falseでスキーマから除外 | E-01 | ○ |
| C-12 | get_openapi_path関数でパス定義を構築 | E-06 | ○ |
| C-13 | jsonable_encoderでJSON互換形式に変換 | E-06 | ○ |
| C-14 | Pydanticモデルからスキーマ定義を生成 | E-06 | ○ |
| C-15 | セキュリティスキームを収集 | E-06 | ○ |
| C-16 | webhooksをサポート（OpenAPI 3.1.0） | E-06 | ○ |
| C-17 | 関連機能の機能NoとMappingは正確 | E-07 | ○ |
| C-18 | 画面一覧の情報は正確 | E-08, E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対応する根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいており、信頼性が高い
- 0: 低リスク - OpenAPIスキーマ生成はFastAPIの中核機能であり、十分にテストされている
- 0: 低リスク - キャッシュ機構により2回目以降のリクエストは高速

## 6) レビュアーチェックリスト（最小）
- [ ] アプリケーションのtitleとversionが適切に設定されていることを確認
- [ ] 本番環境でOpenAPIスキーマを公開する/しないの方針を確認
- [ ] カスタムスキーマが必要な場合、app.openapi_schemaへの直接設定方法を確認
- [ ] include_in_schema=Falseで非公開にすべきエンドポイントの確認
- [ ] OpenAPI 3.1.0の互換性（古いツールとの連携がある場合、openapi_versionの変更を検討）
