---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 50
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：結合テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：50 / 50、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tests/test_security_oauth2.py`
- E-02: `tests/test_dependency_yield_scope.py`
- E-03: `tests/test_ws_router.py`
- E-04: `tests/test_validate_response.py`
- E-05: `tests/test_dependency_security_overrides.py`
- E-06: `tests/test_include_route.py`
- E-07: `tests/test_starlette_exception.py`
- E-08: `tests/test_multi_body_errors.py`
- E-09: `tests/test_annotated.py`
- E-10: `tests/test_custom_middleware_exception.py`
- E-11: `tests/test_read_with_orm_mode.py`
- E-12: `tests/test_response_model_sub_types.py`
- E-13: `tests/test_forms_single_model.py`
- E-14: `tests/test_get_request_body.py`
- E-15: `tests/test_request_params/test_cookie/test_list.py`
- E-16: `tests/test_request_params/test_header/test_list.py`
- E-17: `tests/test_request_params/test_file/test_required.py`
- E-18: `tests/test_request_params/test_file/test_optional.py`
- E-19: `tests/test_request_params/test_path/test_required_str.py`
- E-20: `tests/test_request_params/test_query/test_list.py`
- E-21: `tests/test_request_params/test_body/test_list.py`
- E-22: `fastapi/routing.py`
- E-23: `fastapi/security/oauth2.py`
- E-24: `fastapi/dependencies/utils.py`
- E-25: `pyproject.toml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: OAuth2認証トークン付きリクエスト | E-01 | ○ |
| C-02 | IT-002: OAuth2認証トークンなしリクエスト | E-01 | ○ |
| C-03 | IT-003: OAuth2パスワードフローログイン | E-01 | ○ |
| C-04 | IT-004: 不正なgrant_typeでのログイン試行 | E-01 | ○ |
| C-05 | IT-005: function-scopeでの依存性ライフサイクル | E-02 | ○ |
| C-06 | IT-006: request-scopeでの依存性ライフサイクル | E-02 | ○ |
| C-07 | IT-007: 複合スコープでの依存性動作 | E-02 | ○ |
| C-08 | IT-008: WebSocket基本接続と通信 | E-03 | ○ |
| C-09 | IT-009: Routerを使用したWebSocket | E-03 | ○ |
| C-10 | IT-010: プレフィックス付きRouterのWebSocket | E-03 | ○ |
| C-11 | IT-011: WebSocketでのDepends利用 | E-03 | ○ |
| C-12 | IT-012: WebSocketパスパラメータとクエリパラメータ | E-03 | ○ |
| C-13 | IT-013: WebSocketでのバリデーションエラー | E-03 | ○ |
| C-14 | IT-014: 不正レスポンスモデルの検証 | E-04 | ○ |
| C-15 | IT-015: None許容レスポンス | E-04 | ○ |
| C-16 | IT-016: Securityオーバーライド | E-05 | ○ |
| C-17 | IT-017: Dependsオーバーライド | E-05 | ○ |
| C-18 | IT-018: include_routerでの統合 | E-06 | ○ |
| C-19 | IT-019: HTTPException（404エラー） | E-07 | ○ |
| C-20 | IT-020: 正常アイテム取得 | E-07 | ○ |
| C-21 | IT-021: ボディなしステータスコード例外 | E-07 | ○ |
| C-22 | IT-022: 複数アイテムのバリデーションエラー | E-08 | ○ |
| C-23 | IT-023: 正常なリストボディ送信 | E-08 | ○ |
| C-24 | IT-024: デフォルト値付きQueryパラメータ | E-09 | ○ |
| C-25 | IT-025: 必須Queryパラメータ欠落 | E-09 | ○ |
| C-26 | IT-026: Queryパラメータ長さ制約 | E-09 | ○ |
| C-27 | IT-027: ネストされたRouterパス | E-09 | ○ |
| C-28 | IT-028: カスタムサイズ制限ミドルウェア | E-10 | ○ |
| C-29 | IT-029: ミドルウェア制限内ファイルアップロード | E-10 | ○ |
| C-30 | IT-030: from_attributes(ORM mode)でのレスポンス | E-11 | ○ |
| C-31 | IT-031: response_model_sub_types検証 | E-12 | ○ |
| C-32 | IT-032: Pydanticモデルでのフォーム送信 | E-13 | ○ |
| C-33 | IT-033: フォームデフォルト値の使用 | E-13 | ○ |
| C-34 | IT-034: フォームバリデーションエラー | E-13 | ○ |
| C-35 | IT-035: フォーム必須項目欠落 | E-13 | ○ |
| C-36 | IT-036: extra=allowでの追加パラメータ | E-13 | ○ |
| C-37 | IT-037: GETメソッドでのJSON body受信 | E-14 | ○ |
| C-38 | IT-038: ルーターレベル依存性（function scope） | E-02 | ○ |
| C-39 | IT-039: ルーターレベル依存性（request scope） | E-02 | ○ |
| C-40 | IT-040: アプリレベル依存性（function scope） | E-02 | ○ |
| C-41 | IT-041: OpenAPIスキーマ生成確認 | E-01, E-07, E-08, E-09 | ○ |
| C-42 | IT-042: WebSocketカスタム例外ハンドラ | E-03 | ○ |
| C-43 | IT-043: WebSocketエラーハンドリングミドルウェア | E-03 | ○ |
| C-44 | IT-044: Cookieリスト値取得 | E-15 | ○ |
| C-45 | IT-045: Headerリスト値取得 | E-16 | ○ |
| C-46 | IT-046: 必須ファイルアップロード | E-17 | ○ |
| C-47 | IT-047: オプショナルファイルアップロード | E-18 | ○ |
| C-48 | IT-048: 必須パスパラメータ | E-19 | ○ |
| C-49 | IT-049: Queryリスト値取得 | E-20 | ○ |
| C-50 | IT-050: JSONボディリスト値取得 | E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースは実在するテストファイルから抽出された根拠に基づいています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースが実際のテストコードに基づいており、信頼性は高い
- 注意点：
  - テストケースの一部（パラメータ系：Cookie, Header, Path, Query, Body, File）は、テストファイル名から機能を推測して記載している部分があるため、実際のテスト内容と異なる可能性がある
  - 既存テストが網羅していない機能（例：特定のエッジケース）は本一覧に含まれていない

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度（高/中/低）が適切か確認
- [ ] 前提条件がテスト実行に必要十分か確認
- [ ] テスト手順が再現可能な粒度で記載されているか確認
- [ ] 期待結果が具体的で検証可能か確認
- [ ] 備考欄の参照ファイルパスが正しいか確認
- [ ] プロジェクト固有の結合テストシナリオ（例：データベース連携、外部API連携）が不足していないか確認
