# 通知設計書 1-メール通知

## 概要

本ドキュメントは、FastAPIのBackgroundTasksを使用してレスポンス送信後にバックグラウンドでメール通知を送信する機能の設計書である。

### 本通知の処理概要

FastAPIアプリケーションにおいて、HTTPレスポンスをクライアントに返却した後、非同期でバックグラウンドタスクとしてメール通知処理を実行する機能を提供する。この機能により、ユーザーへの応答速度を維持しながら、時間のかかる通知処理を遅延実行できる。

**業務上の目的・背景**：Webアプリケーションでは、ユーザーの操作に対して即座にレスポンスを返すことが重要である。しかし、メール送信などのI/O操作は時間がかかるため、同期的に処理するとレスポンス時間が長くなる。バックグラウンドタスクによる通知機能は、ユーザー体験を損なわずにメール通知を実現するための解決策である。

**通知の送信タイミング**：`/send-notification/{email}` エンドポイントへのPOSTリクエストが発生した際に、レスポンスを即座にクライアントに返却した後、バックグラウンドでメール通知処理が実行される。

**通知の受信者**：URLパスパラメータとして指定されたメールアドレス（`{email}`）が受信者となる。受信者はリクエスト時に動的に指定される。

**通知内容の概要**：通知メッセージは「notification for {email}: {message}」形式で構成され、指定されたメールアドレスと通知メッセージが含まれる。

**期待されるアクション**：受信者はメール通知を受け取り、通知内容に基づいて必要なアクション（確認、対応など）を行う。本機能はサンプル実装のため、実際のメール送信ではなくファイルへの書き込みで通知をシミュレートしている。

## 通知種別

メール通知（サンプル実装ではファイル書き込みによるシミュレーション）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（バックグラウンドタスク） |
| 優先度 | 中 |
| リトライ | なし（サンプル実装） |

### 送信先決定ロジック

リクエストURLのパスパラメータ `{email}` で指定されたメールアドレスに送信される。送信先の検証処理は含まれていない。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | 未設定（サンプル実装） |
| 送信元名称 | 未設定（サンプル実装） |
| 件名 | 未設定（サンプル実装） |
| 形式 | テキスト |

### 本文テンプレート

```
notification for {email}: {message}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| email | 送信先メールアドレス | URLパスパラメータ | Yes |
| message | 通知メッセージ | 関数引数（デフォルト: "some notification"） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API | POST /send-notification/{email} | なし（常に実行） | エンドポイントへのPOSTリクエスト |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 本サンプル実装では送信抑止条件は設定されていない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[POST /send-notification/email] --> B[send_notification関数呼び出し]
    B --> C[BackgroundTasks.add_task実行]
    C --> D[HTTPレスポンス返却]
    D --> E[バックグラウンドでwrite_notification実行]
    E --> F[log.txtにメッセージ書き込み]
    F --> G[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### ファイル出力

| ファイル名 | 操作 | 概要 |
|-----------|------|------|
| log.txt | 上書き（mode="w"） | 通知メッセージをファイルに書き込み |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル書き込みエラー | log.txtへの書き込み権限がない場合 | エラーは捕捉されない（サンプル実装） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- メールアドレスのバリデーションは実装されていない
- ファイルパスはハードコードされており、パストラバーサルのリスクはない
- 本番環境では適切なメールアドレス検証と送信制限の実装が必要

## 備考

- 本機能はFastAPIのBackgroundTasksのサンプル実装である
- 実際のメール送信処理は含まれておらず、ファイル書き込みでシミュレートしている
- StarletteのBackgroundTasksを継承して実装されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BackgroundTasksクラスの構造と、タスクとして登録される関数のシグネチャを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | background.py | `fastapi/background.py` | BackgroundTasksクラスの定義と継承関係を理解 |

**読解のコツ**: `BackgroundTasks`クラスはStarletteの`BackgroundTasks`を継承しており、`add_task`メソッドがオーバーライドされている点に注目する。

#### Step 2: エントリーポイントを理解する

HTTPエンドポイントの定義と、BackgroundTasksの依存性注入方式を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tutorial001_py39.py | `docs_src/background_tasks/tutorial001_py39.py` | エンドポイント定義とタスク登録の流れ |

**主要処理フロー**:
1. **行12**: `@app.post("/send-notification/{email}")` - POSTエンドポイントの定義
2. **行13**: `async def send_notification(email: str, background_tasks: BackgroundTasks)` - 依存性注入でBackgroundTasksを取得
3. **行14**: `background_tasks.add_task(write_notification, email, message="some notification")` - タスクの登録
4. **行15**: `return {"message": "Notification sent in the background"}` - 即座にレスポンス返却

#### Step 3: バックグラウンドタスク処理を理解する

実際に実行される通知処理の内容を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tutorial001_py39.py | `docs_src/background_tasks/tutorial001_py39.py` | write_notification関数の実装 |

**主要処理フロー**:
- **行6-9**: `write_notification`関数 - ファイルを開いてメッセージを書き込む

### プログラム呼び出し階層図

```
POST /send-notification/{email}
    │
    ├─ send_notification (async def)
    │      │
    │      ├─ BackgroundTasks.add_task()
    │      │      └─ タスクキューに write_notification を登録
    │      │
    │      └─ return {"message": "..."}
    │
    └─ [レスポンス送信後]
           └─ write_notification(email, message)
                  └─ open("log.txt", mode="w")
                         └─ write(content)
```

### データフロー図

```
[入力]               [処理]                    [出力]

{email}パラメータ ───▶ send_notification ───▶ HTTPレスポンス
       │                    │
       │                    ▼
       │              add_task(登録)
       │                    │
       │                    ▼ (レスポンス後)
       │              write_notification
       │                    │
       └──────────────────▶│
                           ▼
                        log.txt
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| background.py | `fastapi/background.py` | ソース | BackgroundTasksクラス定義 |
| tutorial001_py39.py | `docs_src/background_tasks/tutorial001_py39.py` | サンプル | メール通知のサンプル実装 |
| log.txt | カレントディレクトリ | 出力ファイル | 通知メッセージの書き込み先 |
