# 通知設計書 2-ログ記録通知

## 概要

本ドキュメントは、FastAPIのBackgroundTasksを使用してバックグラウンドでログファイルにメッセージを書き込むログ記録通知機能の設計書である。依存関係（Depends）と組み合わせた高度な使用パターンを提供する。

### 本通知の処理概要

FastAPIアプリケーションにおいて、依存関係（Depends）とBackgroundTasksを組み合わせ、複数のバックグラウンドタスクを登録してログファイルにメッセージを追記する機能を提供する。この機能により、依存関係内でもバックグラウンドタスクを追加でき、複数の非同期処理を組み合わせることができる。

**業務上の目的・背景**：アプリケーションの動作ログやユーザーアクティビティを非同期で記録することで、メインの処理フローをブロックせずにログ収集を行う。依存関係内でのタスク登録により、共通のログ処理を複数のエンドポイントで再利用できる設計を実現する。

**通知の送信タイミング**：`/send-notification/{email}` エンドポイントへのPOSTリクエスト時に、2つのタイミングでログが記録される。1つ目は依存関係`get_query`内でクエリパラメータが存在する場合、2つ目はエンドポイント関数内でメール送信処理の記録として実行される。

**通知の受信者**：ログファイル（log.txt）が出力先となる。システム管理者やログ分析担当者がファイルを参照することを想定している。

**通知内容の概要**：クエリパラメータの検出ログ「found query: {q}」とメッセージ送信ログ「message to {email}」の2種類のメッセージがログファイルに追記される。

**期待されるアクション**：システム管理者はログファイルを確認し、アプリケーションの動作状況やユーザーアクティビティを把握する。ログはアペンドモードで追記されるため、履歴として蓄積される。

## 通知種別

ログファイル記録（システム内部通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（バックグラウンドタスク） |
| 優先度 | 低 |
| リトライ | なし |

### 送信先決定ロジック

固定のログファイル（log.txt）に出力される。送信先の動的な決定ロジックは存在しない。

## 通知テンプレート

### ログメッセージの場合

| 項目 | 内容 |
|-----|------|
| 出力先 | log.txt |
| 書き込みモード | 追記（mode="a"） |
| 形式 | テキスト |

### 本文テンプレート

**クエリログ：**
```
found query: {q}
```

**メッセージログ：**
```
message to {email}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| q | クエリパラメータ | URLクエリパラメータ | No |
| email | 送信先メールアドレス | URLパスパラメータ | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API | POST /send-notification/{email} | クエリパラメータqが存在 | 依存関係内でクエリログを記録 |
| API | POST /send-notification/{email} | なし（常に実行） | エンドポイントでメッセージログを記録 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| クエリパラメータなし | q=Noneの場合、クエリログは記録されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[POST /send-notification/email?q=xxx] --> B[依存関係 get_query 実行]
    B --> C{クエリパラメータqが存在?}
    C -->|Yes| D[BackgroundTasks.add_task: クエリログ]
    C -->|No| E[スキップ]
    D --> F[send_notification関数実行]
    E --> F
    F --> G[BackgroundTasks.add_task: メッセージログ]
    G --> H[HTTPレスポンス返却]
    H --> I[バックグラウンドでwrite_log実行]
    I --> J[log.txtにメッセージ追記]
    J --> K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### ファイル出力

| ファイル名 | 操作 | 概要 |
|-----------|------|------|
| log.txt | 追記（mode="a"） | ログメッセージをファイルに追記 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル書き込みエラー | log.txtへの書き込み権限がない場合 | エラーは捕捉されない |
| ディスク容量不足 | ディスクが満杯の場合 | エラーは捕捉されない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ログファイルに書き込まれる内容（メールアドレス、クエリパラメータ）は機密情報となる可能性がある
- ファイルパスはハードコードされており、パストラバーサルのリスクはない
- 本番環境では適切なログローテーションとアクセス制御の実装が必要

## 備考

- 本機能はFastAPIのBackgroundTasksと依存関係の組み合わせサンプルである
- 依存関係内でBackgroundTasksを使用することで、共通処理の再利用が可能
- ログファイルは追記モード（mode="a"）で書き込まれ、履歴が蓄積される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BackgroundTasksクラスの構造と、Dependsによる依存性注入の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | background.py | `fastapi/background.py` | BackgroundTasksクラスの定義 |

**読解のコツ**: `BackgroundTasks`は複数のタスクを登録可能であり、依存関係と組み合わせることで柔軟なタスク管理ができる。

#### Step 2: エントリーポイントを理解する

エンドポイントと依存関係の定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tutorial002_an_py310.py | `docs_src/background_tasks/tutorial002_an_py310.py` | 依存関係とエンドポイントの連携 |

**主要処理フロー**:
1. **行13-17**: `get_query`依存関係 - クエリパラメータが存在する場合にログタスクを登録
2. **行20-26**: `send_notification`エンドポイント - メッセージログタスクを登録
3. **行22**: `Annotated[str, Depends(get_query)]` - 依存関係の注入

#### Step 3: ログ書き込み処理を理解する

実際に実行されるログ記録処理の内容を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tutorial002_an_py310.py | `docs_src/background_tasks/tutorial002_an_py310.py` | write_log関数の実装 |

**主要処理フロー**:
- **行8-10**: `write_log`関数 - 追記モードでファイルを開いてメッセージを書き込む

### プログラム呼び出し階層図

```
POST /send-notification/{email}?q=xxx
    │
    ├─ get_query (依存関係)
    │      │
    │      ├─ if q: BackgroundTasks.add_task(write_log, "found query...")
    │      │
    │      └─ return q
    │
    ├─ send_notification (async def)
    │      │
    │      ├─ BackgroundTasks.add_task(write_log, "message to...")
    │      │
    │      └─ return {"message": "Message sent"}
    │
    └─ [レスポンス送信後]
           └─ write_log(message) x N回
                  └─ open("log.txt", mode="a")
                         └─ write(message)
```

### データフロー図

```
[入力]               [処理]                    [出力]

{email}パラメータ ───▶ send_notification ───▶ HTTPレスポンス
                            │
?q=xxxパラメータ ───▶ get_query ─────────────┐
                            │                │
                            ▼                │
                      add_task(登録)         │
                            │                │
                            ▼ (レスポンス後) │
                      write_log ◀────────────┘
                            │
                            ▼
                        log.txt (追記)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| background.py | `fastapi/background.py` | ソース | BackgroundTasksクラス定義 |
| tutorial002_an_py310.py | `docs_src/background_tasks/tutorial002_an_py310.py` | サンプル | ログ記録通知のサンプル実装 |
| log.txt | カレントディレクトリ | 出力ファイル | ログメッセージの書き込み先 |
