# 通知設計書 3-翻訳PR通知

## 概要

本ドキュメントは、FastAPIリポジトリにおける翻訳PRがレビュー待ち状態になった際に、対応する言語のGitHub Discussionにコメントで通知を投稿する機能の設計書である。

### 本通知の処理概要

GitHub Actionsワークフローから実行されるPythonスクリプトにより、翻訳関連のPull Requestに特定のラベル（`awaiting-review`と`lang-all`）が付与された場合、該当する言語のDiscussionに新しいPRがあることをコメントで通知する機能を提供する。

**業務上の目的・背景**：FastAPIは多言語対応のドキュメントを持ち、世界中のコントリビューターが翻訳を行っている。翻訳PRはネイティブスピーカーによる2名以上のレビューが必要であり、レビュー待ちのPRを該当言語コミュニティに効率的に周知する必要がある。Discussionへの自動通知により、言語コミュニティのメンバーがレビュー待ちPRを迅速に認識でき、レビュープロセスが加速される。

**通知の送信タイミング**：PRに`awaiting-review`ラベルと`lang-all`ラベルが付与され、PRがオープン状態の場合にGitHub Actionsワークフローがトリガーされ、通知処理が実行される。競合状態を避けるため、0-10秒のランダムなスリープ後に通知が投稿される。

**通知の受信者**：対象言語のGitHub Discussion（翻訳カテゴリ）の購読者。Discussion番号は言語ラベル（例：`lang-ja`）に基づいて自動的に決定される。

**通知内容の概要**：「Good news everyone! There's a new translation PR to be reviewed: #{PR番号} by @{ユーザー名}. This requires 2 approvals from native speakers to be merged.」という形式のメッセージ。

**期待されるアクション**：言語コミュニティのメンバーは通知を確認し、該当PRへ移動してコードレビューを実施する。2名以上のネイティブスピーカーによる承認が必要。

## 通知種別

GitHub Discussion コメント

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（GitHub GraphQL API） |
| 優先度 | 中 |
| リトライ | なし（エラー時はスクリプト失敗） |

### 送信先決定ロジック

1. PRのラベルから言語コード（`lang-{code}`）を抽出
2. GitHub GraphQL APIで翻訳カテゴリの全Discussionを取得
3. 各Discussionのラベルと照合し、対応する言語のDiscussion IDを特定
4. 該当Discussionにコメントを投稿

## 通知テンプレート

### GitHub Discussionコメントの場合

| 項目 | 内容 |
|-----|------|
| 投稿先 | GitHub Discussion（翻訳カテゴリ） |
| 形式 | Markdown |
| 絵文字 | 使用あり |

### 本文テンプレート

```
Good news everyone! 😉 There's a new translation PR to be reviewed: #{pr.number} by @{pr.user.login}. 🎉 This requires 2 approvals from native speakers to be merged. 🤓
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| pr.number | PR番号 | GitHub PR API | Yes |
| pr.user.login | PR作成者のユーザー名 | GitHub PR API | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| GitHub Actions | PR labeled / PR opened | `awaiting-review`と`lang-all`ラベルが付与、PRがopen状態 | ラベル付与イベントでワークフロー実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既存通知あり | 同一PRに対する通知コメントが既に存在する場合 |
| 必須ラベルなし | `awaiting-review`または`lang-all`ラベルがない場合 |
| PR closed | PRがクローズされている場合 |
| 対応Discussion不明 | 言語に対応するDiscussionが見つからない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GitHub Actions トリガー] --> B[設定読み込み・GitHub認証]
    B --> C[PR情報取得]
    C --> D{lang-all と awaiting-review ラベルあり?}
    D -->|No| E[スキップ・終了]
    D -->|Yes| F[翻訳Discussion一覧取得]
    F --> G[言語→Discussion マッピング作成]
    G --> H{対応Discussion存在?}
    H -->|No| I[エラー・終了]
    H -->|Yes| J[既存コメント確認]
    J --> K{既に通知済み?}
    K -->|Yes| L[ログ出力・スキップ]
    K -->|No| M[0-10秒ランダムスリープ]
    M --> N[コメント投稿]
    N --> O[終了]
    L --> O
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| GitHub PR | PR情報取得 | PyGitHub経由 |
| GitHub Discussion | 通知先Discussion検索 | GraphQL API経由 |
| GitHub Discussion Comments | 既存通知確認 | GraphQL API経由 |

### テーブル別参照項目詳細

#### GitHub PR

| 参照項目 | 用途 | 取得条件 |
|---------|------|---------|
| number | PR番号 | イベント情報から取得 |
| state | PR状態 | open/closed判定 |
| user.login | 作成者 | メンション用 |
| labels | ラベル一覧 | 言語・状態判定 |

#### GitHub Discussion

| 参照項目 | 用途 | 取得条件 |
|---------|------|---------|
| id | Discussion ID | コメント投稿用 |
| number | Discussion番号 | ログ出力用 |
| title | タイトル | 識別用 |
| labels | ラベル | 言語マッピング用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| GitHub Discussion Comments | INSERT | 通知コメント投稿 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| GitHub API認証エラー | トークン無効・期限切れ | RuntimeError発生、スクリプト終了 |
| GraphQL APIエラー | レスポンスにerrors含む | RuntimeError発生、スクリプト終了 |
| Discussion未検出 | 言語に対応するDiscussionなし | RuntimeError発生、スクリプト終了 |
| イベントファイルなし | github_event_pathが存在しない | RuntimeError発生、スクリプト終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitHub API制限に依存 |
| 1日あたり上限 | GitHub API制限に依存 |

### 配信時間帯

制限なし（GitHub Actionsイベント駆動）

## セキュリティ考慮事項

- GitHub トークンはSecretStrで保護され、ログ出力時にマスキングされる
- 環境変数経由でトークンを取得（GITHUB_TOKEN）
- GraphQL APIへのリクエストにはBearer認証を使用
- pydantic_settingsによる設定値バリデーション

## 備考

- 同一PRに対する複数言語ラベルがある場合、各言語のDiscussionに通知される
- 競合状態を避けるため、0-10秒のランダムスリープを実行
- 通知カテゴリID（questions_translations_category_id）はハードコード
- PyGithubとhttpxの両方を使用（REST APIとGraphQL API）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Pydanticモデルによるデータ構造定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notify_translations.py | `scripts/notify_translations.py` | 行87-175: Pydanticモデル群の定義 |

**読解のコツ**: GraphQL APIのレスポンス構造に対応したネストしたPydanticモデルを理解する。`Comment`, `CommentsResponse`, `AllDiscussionsResponse`などの階層構造に注目。

#### Step 2: エントリーポイントを理解する

main関数の全体フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notify_translations.py | `scripts/notify_translations.py` | 行306-428: main関数 |

**主要処理フロー**:
1. **行307-312**: Settings読み込み、ログ設定
2. **行313-314**: GitHubクライアント初期化
3. **行322-327**: PR番号取得
4. **行329-334**: 競合回避のためのランダムスリープ
5. **行336-347**: PR取得と言語ラベル抽出
6. **行350-358**: Discussion一覧取得とマッピング作成
7. **行361-428**: 各言語のDiscussionに対する通知処理

#### Step 3: GraphQL API操作を理解する

GraphQL クエリとミューテーションの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notify_translations.py | `scripts/notify_translations.py` | 行21-84: GraphQLクエリ定義 |
| 3-2 | notify_translations.py | `scripts/notify_translations.py` | 行198-236: get_graphql_response関数 |
| 3-3 | notify_translations.py | `scripts/notify_translations.py` | 行284-303: create_comment/update_comment関数 |

**主要処理フロー**:
- **行21-41**: all_discussions_query - Discussion一覧取得クエリ
- **行43-60**: translation_discussion_query - コメント取得クエリ
- **行62-72**: add_comment_mutation - コメント追加ミューテーション
- **行284-292**: create_comment - コメント投稿処理

### プログラム呼び出し階層図

```
main()
    │
    ├─ Settings() - 環境変数読み込み
    │
    ├─ Github(token) - REST APIクライアント初期化
    │
    ├─ repo.get_pull(number) - PR情報取得
    │
    ├─ get_graphql_translation_discussions()
    │      └─ get_graphql_response(all_discussions_query)
    │             └─ httpx.post(github_graphql_url)
    │
    ├─ get_graphql_translation_discussion_comments()
    │      └─ get_graphql_response(translation_discussion_query)
    │             └─ httpx.post(github_graphql_url)
    │
    └─ create_comment()
           └─ get_graphql_response(add_comment_mutation)
                  └─ httpx.post(github_graphql_url)
```

### データフロー図

```
[入力]               [処理]                    [出力]

GitHub Event ───▶ Settings読み込み
      │                  │
      │                  ▼
      │            PR情報取得
      │                  │
      │                  ▼
      └───────▶ ラベル判定（lang-*, awaiting-review）
                         │
                         ▼
               Discussion一覧取得（GraphQL）
                         │
                         ▼
               言語→Discussion マッピング
                         │
                         ▼
               既存コメント確認（GraphQL）
                         │
                         ▼
               コメント投稿（GraphQL） ───▶ Discussion Comment
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notify_translations.py | `scripts/notify_translations.py` | ソース | 翻訳PR通知のメイン処理 |
| GitHub Actions Workflow | `.github/workflows/` | 設定 | ワークフロー定義（トリガー） |
