# 通知設計書 4-翻訳完了通知

## 概要

本ドキュメントは、FastAPIリポジトリにおける翻訳PRが承認またはクローズされた際に、GitHub Discussionの既存通知コメントを更新して完了を通知する機能の設計書である。

### 本通知の処理概要

GitHub Actionsワークフローから実行されるPythonスクリプトにより、翻訳PRが承認（`approved-1`ラベル付与）またはクローズされた場合、以前に投稿したレビュー待ち通知コメントを更新して完了状態に変更する機能を提供する。

**業務上の目的・背景**：翻訳PRのレビュープロセスが完了した際、Discussionに残っているレビュー待ち通知を更新することで、コミュニティメンバーが既に対応済みのPRを認識できるようにする。これにより、レビュー済みPRへの重複レビューを防ぎ、コミュニティの効率を向上させる。

**通知の送信タイミング**：PRが以下のいずれかの状態になった場合にトリガーされる：
1. PRがクローズされた（state = "closed"）
2. PRに`approved-1`ラベルが付与された（承認済み）

**通知の受信者**：対象言語のGitHub Discussion（翻訳カテゴリ）の購読者。以前に投稿された新規PR通知コメントが更新される。

**通知内容の概要**：既存の「Good news everyone! There's a new translation PR...」コメントを「~There's a new translation PR to be reviewed~ Good job! This is done.」形式に更新し、完了を示す。

**期待されるアクション**：言語コミュニティのメンバーは更新されたコメントを確認し、該当PRのレビューが完了したことを認識する。これ以上のレビュー対応は不要。

## 通知種別

GitHub Discussion コメント（更新）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（GitHub GraphQL API） |
| 優先度 | 低 |
| リトライ | なし（エラー時はスクリプト失敗） |

### 送信先決定ロジック

1. PRのラベルから言語コード（`lang-{code}`）を抽出
2. 対応する言語のDiscussionを特定
3. 該当Discussionの既存コメントから新規PR通知を検索
4. 見つかった通知コメントを完了状態に更新

## 通知テンプレート

### GitHub Discussionコメント（更新後）の場合

| 項目 | 内容 |
|-----|------|
| 投稿先 | GitHub Discussion（翻訳カテゴリ）の既存コメント |
| 形式 | Markdown（取り消し線使用） |
| 絵文字 | 使用あり |

### 本文テンプレート

```
~There's a new translation PR to be reviewed: #{pr.number} by @{pr.user.login}~ Good job! This is done. 🍰☕
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| pr.number | PR番号 | GitHub PR API | Yes |
| pr.user.login | PR作成者のユーザー名 | GitHub PR API | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| GitHub Actions | PR closed | PRがクローズ状態 | PRクローズイベント |
| GitHub Actions | PR labeled | `approved-1`ラベル付与 | 承認ラベル付与イベント |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既存通知なし | 新規PR通知コメントが存在しない場合 |
| 既に完了済み | done_translation_messageが既に存在する場合 |
| 必須ラベルなし | `lang-all`ラベルがない場合（翻訳PRでない） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GitHub Actions トリガー] --> B[設定読み込み・GitHub認証]
    B --> C[PR情報取得]
    C --> D{PRがclosedまたはapproved-1ラベルあり?}
    D -->|No| E[スキップ・終了]
    D -->|Yes| F[翻訳Discussion一覧取得]
    F --> G[言語→Discussion マッピング作成]
    G --> H[既存コメント検索]
    H --> I{既に完了通知済み?}
    I -->|Yes| J[ログ出力・スキップ]
    I -->|No| K{新規PR通知コメント存在?}
    K -->|No| L[ログ出力・スキップ]
    K -->|Yes| M[コメント更新]
    M --> N[終了]
    J --> N
    L --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| GitHub PR | PR情報取得 | PyGitHub経由 |
| GitHub Discussion | 通知先Discussion検索 | GraphQL API経由 |
| GitHub Discussion Comments | 既存通知検索 | GraphQL API経由 |

### テーブル別参照項目詳細

#### GitHub PR

| 参照項目 | 用途 | 取得条件 |
|---------|------|---------|
| number | PR番号 | イベント情報から取得 |
| state | PR状態 | closed判定 |
| user.login | 作成者 | メッセージ特定用 |
| labels | ラベル一覧 | approved-1判定 |

#### GitHub Discussion Comments

| 参照項目 | 用途 | 取得条件 |
|---------|------|---------|
| id | コメントID | 更新対象特定用 |
| body | コメント本文 | 通知メッセージ検索用 |
| url | コメントURL | ログ出力用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| GitHub Discussion Comments | UPDATE | 既存コメントを完了状態に更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| GitHub API認証エラー | トークン無効・期限切れ | RuntimeError発生、スクリプト終了 |
| GraphQL APIエラー | レスポンスにerrors含む | RuntimeError発生、スクリプト終了 |
| Discussion未検出 | 言語に対応するDiscussionなし | RuntimeError発生、スクリプト終了 |
| コメント未検出 | 更新対象コメントなし | 正常終了（更新スキップ） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitHub API制限に依存 |
| 1日あたり上限 | GitHub API制限に依存 |

### 配信時間帯

制限なし（GitHub Actionsイベント駆動）

## セキュリティ考慮事項

- GitHub トークンはSecretStrで保護され、ログ出力時にマスキングされる
- 環境変数経由でトークンを取得（GITHUB_TOKEN）
- GraphQL APIへのリクエストにはBearer認証を使用
- コメント更新は既存コメントの検索に基づき、不正な更新を防止

## 備考

- 翻訳PR通知（No.3）と同一のスクリプト（notify_translations.py）で実装
- コメント更新にはupdate_comment_mutationを使用
- 取り消し線（~テキスト~）によりMarkdownで完了を視覚的に表現
- 既に完了通知済みの場合は重複更新を防止

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

完了通知に使用されるメッセージ形式とコメント更新のレスポンス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notify_translations.py | `scripts/notify_translations.py` | 行93-103: UpdateCommentResponse関連モデル |

**読解のコツ**: updateDiscussionCommentミューテーションのレスポンス構造を理解する。Comment, UpdateDiscussionComment, UpdateCommentDataの階層に注目。

#### Step 2: エントリーポイントを理解する

main関数内の完了通知ロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notify_translations.py | `scripts/notify_translations.py` | 行411-423: 完了通知処理 |

**主要処理フロー**:
1. **行362**: done_translation_messageの定義
2. **行411**: `elif pr.state == "closed" or approved_label in label_strs` - 完了判定条件
3. **行413-416**: 既に完了済みかチェック
4. **行417-423**: コメント更新実行

#### Step 3: コメント更新処理を理解する

GraphQL ミューテーションによるコメント更新の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notify_translations.py | `scripts/notify_translations.py` | 行74-84: update_comment_mutation |
| 3-2 | notify_translations.py | `scripts/notify_translations.py` | 行295-303: update_comment関数 |

**主要処理フロー**:
- **行74-84**: GraphQLミューテーション定義（updateDiscussionComment）
- **行295-303**: update_comment関数 - comment_idとbodyを指定して更新

### プログラム呼び出し階層図

```
main()
    │
    ├─ Settings() - 環境変数読み込み
    │
    ├─ Github(token) - REST APIクライアント初期化
    │
    ├─ repo.get_pull(number) - PR情報取得
    │      │
    │      └─ pr.state, pr.get_labels() - 状態・ラベル取得
    │
    ├─ get_graphql_translation_discussions()
    │      └─ get_graphql_response(all_discussions_query)
    │
    ├─ get_graphql_translation_discussion_comments()
    │      └─ get_graphql_response(translation_discussion_query)
    │             └─ 既存コメント検索（new_translation_message, done_translation_message）
    │
    └─ update_comment() [完了通知]
           └─ get_graphql_response(update_comment_mutation)
                  └─ httpx.post(github_graphql_url)
```

### データフロー図

```
[入力]               [処理]                    [出力]

GitHub Event ───▶ PR情報取得
      │                  │
      │                  ▼
      │            状態判定（closed / approved-1）
      │                  │
      │                  ▼
      │            Discussion コメント検索
      │                  │
      │                  ▼
      │            既存通知コメント特定
      │                  │
      │                  ▼
      └───────▶ コメント更新（GraphQL） ───▶ 更新済みコメント

                  [更新前]
                  "Good news everyone! 😉 There's a new translation PR..."

                      │
                      ▼

                  [更新後]
                  "~There's a new translation PR...~ Good job! This is done. 🍰☕"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notify_translations.py | `scripts/notify_translations.py` | ソース | 翻訳通知のメイン処理（新規・完了両方） |
| GitHub Actions Workflow | `.github/workflows/` | 設定 | ワークフロー定義（トリガー） |
