# 通知設計書 5-新規サブスクリプション通知

## 概要

本ドキュメントは、FastAPIのOpenAPI Webhooks機能を使用して、ユーザーが新規サブスクリプションを登録した際に登録されたURLに対してPOSTリクエストを送信するWebhook通知の設計書である。

### 本通知の処理概要

FastAPIのOpenAPI Webhooks機能により、新規サブスクリプション登録イベントを外部システムに通知するためのAPI仕様を定義する。実際の通知送信処理は定義されておらず、OpenAPIスキーマでWebhookエンドポイントの仕様を文書化する機能を提供する。

**業務上の目的・背景**：SaaSやサブスクリプションベースのサービスでは、新規ユーザー登録時に外部システム（CRM、課金システム、分析ツールなど）へ通知する必要がある。Webhook機能により、サービス利用者（外部開発者）が自身のシステムで新規サブスクリプションイベントを受信し、必要な処理を実行できるようになる。

**通知の送信タイミング**：新規ユーザーがサブスクリプションを登録した際（概念的なイベント）。実装例ではWebhookの仕様定義のみが行われており、実際のトリガーロジックは含まれていない。

**通知の受信者**：APIを利用する外部開発者が、ダッシュボードで`new-subscription`イベント用に登録したURL。登録されたエンドポイントがWebhookの受信先となる。

**通知内容の概要**：サブスクリプション情報（ユーザー名、月額料金、開始日）を含むJSONペイロードがPOSTリクエストとして送信される。

**期待されるアクション**：Webhook受信者は通知を受け取り、以下のような処理を実行する：
- 顧客管理システムへの新規ユーザー追加
- ウェルカムメールの送信トリガー
- 課金システムとの同期
- 分析データの更新

## 通知種別

Webhook（HTTP POST通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（HTTP POST）※仕様定義のみ |
| 優先度 | 高（リアルタイム通知） |
| リトライ | 実装依存（仕様定義のみ） |

### 送信先決定ロジック

外部開発者がダッシュボードで`new-subscription`イベントに登録したURLに送信される。URLの管理方法は実装依存。

## 通知テンプレート

### Webhookリクエストの場合

| 項目 | 内容 |
|-----|------|
| HTTPメソッド | POST |
| Content-Type | application/json |
| エンドポイント名 | new-subscription |

### リクエストボディテンプレート

```json
{
  "username": "{username}",
  "monthly_fee": {monthly_fee},
  "start_date": "{start_date}"
}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| username | ユーザー名 | Subscriptionモデル | Yes |
| monthly_fee | 月額料金 | Subscriptionモデル | Yes |
| start_date | 開始日時 | Subscriptionモデル | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ビジネスイベント | 新規サブスクリプション登録 | なし（常に送信） | ユーザーがサービスに登録した際 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Webhook URL未登録 | 外部開発者がURLを登録していない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[新規サブスクリプション登録] --> B[Subscriptionデータ作成]
    B --> C{Webhook URL登録済み?}
    C -->|No| D[Webhook送信スキップ]
    C -->|Yes| E[Webhookペイロード構築]
    E --> F[HTTP POST送信]
    F --> G{送信成功?}
    G -->|Yes| H[完了]
    G -->|No| I[リトライ/エラー処理]
    I --> H
    D --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 仕様定義のみ（実装依存） |

### Subscriptionモデル

| 参照項目 | 用途 | データ型 |
|---------|------|---------|
| username | ユーザー識別 | str |
| monthly_fee | 課金情報 | float |
| start_date | 契約開始日 | datetime |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 仕様定義のみ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 接続タイムアウト | Webhook URLへの接続失敗 | 実装依存 |
| HTTPエラー | 4xx/5xxレスポンス | 実装依存 |
| ペイロード検証エラー | データ形式不正 | Pydanticバリデーション |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 実装依存 |
| リトライ間隔 | 実装依存 |
| リトライ対象エラー | 実装依存 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 実装依存 |
| 1日あたり上限 | 実装依存 |

### 配信時間帯

制限なし（イベント駆動）

## セキュリティ考慮事項

- Webhook URLはHTTPSを推奨
- 署名検証（HMAC等）による改ざん検知を推奨
- Webhookシークレットの安全な管理
- 個人情報（ユーザー名）の送信に注意

## 備考

- 本実装例はOpenAPI Webhooksの仕様定義機能のデモンストレーション
- 実際のWebhook送信ロジックは含まれていない
- OpenAPIドキュメントに`webhooks`セクションとして出力される
- `@app.webhooks.post("new-subscription")`でWebhook仕様を定義

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Webhookで送信されるサブスクリプションデータの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tutorial001_py39.py | `docs_src/openapi_webhooks/tutorial001_py39.py` | 行9-13: Subscriptionモデル定義 |

**読解のコツ**: PydanticのBaseModelを使用したデータモデル。`datetime`型の使用により、ISO 8601形式での日時シリアライズが行われる。

#### Step 2: エントリーポイントを理解する

Webhook仕様の定義方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tutorial001_py39.py | `docs_src/openapi_webhooks/tutorial001_py39.py` | 行15-21: Webhook定義 |

**主要処理フロー**:
1. **行6**: `app = FastAPI()` - FastAPIアプリケーション作成
2. **行15**: `@app.webhooks.post("new-subscription")` - Webhookエンドポイント定義
3. **行16-21**: `new_subscription`関数 - Webhook仕様の文書化用docstring

#### Step 3: 通常APIエンドポイントとの関係を理解する

Webhookと通常のAPIエンドポイントの違いを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tutorial001_py39.py | `docs_src/openapi_webhooks/tutorial001_py39.py` | 行23-25: 通常のGETエンドポイント |

**主要処理フロー**:
- **行23-25**: `/users/` - 通常のRESTエンドポイント（比較用）

### プログラム呼び出し階層図

```
FastAPI Application
    │
    ├─ app.webhooks.post("new-subscription")
    │      │
    │      └─ new_subscription(body: Subscription)
    │             └─ [OpenAPI仕様生成のみ - 実際の処理なし]
    │
    └─ @app.get("/users/")
           └─ read_users()
                  └─ return ["Rick", "Morty"]
```

### データフロー図

```
[概念的なフロー - 実装例では仕様定義のみ]

[イベント]            [処理]                    [出力]

新規ユーザー登録 ───▶ Subscriptionデータ生成
                            │
                            ▼
                     Webhook URL取得
                            │
                            ▼
                     HTTP POST送信 ───▶ 登録済みURL

                     [リクエストボディ]
                     {
                       "username": "johndoe",
                       "monthly_fee": 9.99,
                       "start_date": "2026-01-22T10:00:00"
                     }
```

### OpenAPIスキーマ出力例

```yaml
webhooks:
  new-subscription:
    post:
      summary: New Subscription
      description: |
        When a new user subscribes to your service we'll send you a POST request
        with this data to the URL that you register for the event `new-subscription`
        in the dashboard.
      requestBody:
        required: true
        content:
          application/json:
            schema:
              $ref: '#/components/schemas/Subscription'
      responses:
        '200':
          description: Successful Response
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tutorial001_py39.py | `docs_src/openapi_webhooks/tutorial001_py39.py` | サンプル | Webhook仕様定義の例 |
| FastAPI | `fastapi/applications.py` | フレームワーク | webhooksプロパティの提供 |
| OpenAPI | - | 仕様 | 生成されるOpenAPIドキュメント |
