# 通知設計書 7-ドキュメントデプロイステータス通知

## 概要

本ドキュメントは、FastAPIリポジトリにおけるPull Requestに対して、ドキュメントのデプロイ状態（pending/success/error）をGitHub Commitステータスとして通知する機能の設計書である。

### 本通知の処理概要

GitHub Actionsワークフローから実行されるPythonスクリプトにより、ドキュメントのデプロイ処理の進行状況をGitHub Commitステータスとして通知する。PRに含まれるコミットに対して、デプロイ状態（pending: デプロイ中、success: 成功、error: エラー）を表示し、レビュアーがデプロイ状況を把握できるようにする。

**業務上の目的・背景**：FastAPIのドキュメントはPR毎にプレビュー環境にデプロイされる。PRレビュアーはドキュメントの変更内容をプレビュー環境で確認する必要があるが、デプロイが完了しているかどうかを知る手段が必要である。Commitステータスにより、PRページ上でデプロイ状態を即座に確認でき、レビュープロセスの効率化が図れる。

**通知の送信タイミング**：GitHub Actionsワークフローの各ステージで状態が更新される：
1. デプロイ開始時: `pending`（Deploying Docs）
2. デプロイ成功時: `success`（Docs Deployed / No Docs Changes）
3. デプロイ失敗時: `error`（Error Deploying Docs）

**通知の受信者**：PRの作成者およびレビュアー。GitHub PRページのステータスチェック欄に表示され、Commitステータスとしても確認可能。

**通知内容の概要**：Commitステータスとして以下の情報が通知される：
- state: pending/success/error
- description: 状態の説明文
- context: "deploy-docs"
- target_url: GitHub Actionsの実行URL

**期待されるアクション**：
- pending: デプロイ完了まで待機
- success: プレビューリンクでドキュメントを確認、レビュー実施
- error: デプロイエラーの原因調査、修正

## 通知種別

GitHub Commitステータス

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（GitHub REST API） |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

1. PRのhead.shaからコミットを特定
2. 該当コミットに対してステータスを作成
3. PRページのステータスチェック欄に自動反映

## 通知テンプレート

### Commitステータスの場合

| 項目 | 内容 |
|-----|------|
| 通知先 | GitHub Commitステータス |
| context | deploy-docs |
| target_url | GitHub Actionsの実行URL |

### ステータスメッセージ一覧

| state | description | 条件 |
|-------|-------------|------|
| pending | Deploying Docs | state="pending" |
| success | Docs Deployed | state="success" かつ deploy_url あり |
| success | No Docs Changes | state="success" かつ deploy_url なし |
| error | Error Deploying Docs | state="error" |

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| state | デプロイ状態 | 環境変数（Settings） | Yes |
| commit_sha | コミットSHA | 環境変数（Settings） | Yes |
| run_id | GitHub Actions実行ID | 環境変数（Settings） | Yes |
| deploy_url | デプロイ先URL | 環境変数（Settings） | No |
| github_repository | リポジトリ名 | 環境変数（Settings） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| GitHub Actions | ワークフロー実行 | state="pending" | デプロイ開始時 |
| GitHub Actions | ワークフロー実行 | state="success" | デプロイ成功時 |
| GitHub Actions | ワークフロー実行 | state="error" | デプロイ失敗時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| PR未検出 | commit_shaに対応するPRが見つからない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GitHub Actions トリガー] --> B[設定読み込み・GitHub認証]
    B --> C[commit_shaからPR検索]
    C --> D{PR見つかった?}
    D -->|No| E[エラーログ・終了]
    D -->|Yes| F{state判定}
    F -->|pending| G[pending ステータス作成]
    F -->|error| H[error ステータス作成]
    F -->|success| I{deploy_url あり?}
    I -->|No| J[success: No Docs Changes]
    I -->|Yes| K[success: Docs Deployed]
    G --> L[終了]
    H --> L
    J --> L
    K --> M[PRコメント処理へ継続]
    M --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| GitHub PRs | commit_shaからPR検索 | PyGitHub経由 |
| GitHub Commits | ステータス作成対象 | PyGitHub経由 |

### テーブル別参照項目詳細

#### GitHub PRs

| 参照項目 | 用途 | 取得条件 |
|---------|------|---------|
| head.sha | コミット特定 | commit_shaと一致 |
| commits | コミット一覧 | ステータス作成対象 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| GitHub Commit Status | CREATE | ステータス作成（create_status） |

#### Commit Status

| 項目 | 値 | 備考 |
|-----|-----------------|-------|
| state | pending/success/error | 状態 |
| description | 説明文 | 状態別メッセージ |
| context | deploy-docs | 識別子 |
| target_url | run_url | GitHub Actionsリンク |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| PR未検出 | commit_shaに対応するPRなし | エラーログ出力、処理終了 |
| GitHub API認証エラー | トークン無効・期限切れ | 例外発生 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitHub API制限に依存 |
| 1日あたり上限 | GitHub API制限に依存 |

### 配信時間帯

制限なし（GitHub Actionsイベント駆動）

## セキュリティ考慮事項

- GitHub トークンはSecretStrで保護され、ログ出力時にマスキングされる
- 環境変数経由でトークンを取得（GITHUB_TOKEN）
- PyGitHubのAuth.Token認証を使用
- pydantic_settingsによる設定値バリデーション

## 備考

- ドキュメントプレビュー通知（No.8）と同一のスクリプト（deploy_docs_status.py）で実装
- state環境変数は"pending"/"success"/"error"のLiteral型で定義
- assertによる状態検証を実施
- run_urlはGitHub Actionsの実行結果ページへのリンク

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定とデータモデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deploy_docs_status.py | `scripts/deploy_docs_status.py` | 行10-17: Settingsクラス定義 |
| 1-2 | deploy_docs_status.py | `scripts/deploy_docs_status.py` | 行19-23: LinkDataモデル定義 |

**読解のコツ**: Settingsクラスのstate属性は`Literal["pending", "success", "error"]`で定義されており、3つの状態のみを許容する。デフォルト値は"pending"。

#### Step 2: エントリーポイントを理解する

main関数の全体フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deploy_docs_status.py | `scripts/deploy_docs_status.py` | 行25-49: main関数（ステータス通知部分） |

**主要処理フロー**:
1. **行26-27**: Settings読み込み、ログ設定
2. **行29-30**: GitHubクライアント初期化
3. **行31-34**: commit_shaからPR検索
4. **行35-37**: PR未検出時のエラー処理
5. **行38-39**: コミット取得
6. **行40**: run_url構築
7. **行41-68**: state別のステータス作成処理

#### Step 3: ステータス作成処理を理解する

各状態でのステータス作成ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | deploy_docs_status.py | `scripts/deploy_docs_status.py` | 行41-49: pending状態の処理 |
| 3-2 | deploy_docs_status.py | `scripts/deploy_docs_status.py` | 行50-58: error状態の処理 |
| 3-3 | deploy_docs_status.py | `scripts/deploy_docs_status.py` | 行59-75: success状態の処理 |

**主要処理フロー**:
- **行42-47**: `current_commit.create_status()` - pending状態
- **行51-56**: `current_commit.create_status()` - error状態
- **行61-67**: `current_commit.create_status()` - success（No Docs Changes）
- **行70-75**: `current_commit.create_status()` - success（Docs Deployed）

### プログラム呼び出し階層図

```
main()
    │
    ├─ Settings() - 環境変数読み込み
    │      │
    │      └─ state, commit_sha, run_id, deploy_url, github_repository
    │
    ├─ Github(auth=Auth.Token(token)) - REST APIクライアント初期化
    │
    ├─ repo.get_pulls() - PR一覧取得
    │      │
    │      └─ head.sha == commit_sha でフィルタ
    │
    ├─ use_pr.get_commits() - コミット一覧取得
    │
    └─ current_commit.create_status()
           │
           ├─ [state="pending"]
           │      └─ state="pending", description="Deploying Docs"
           │
           ├─ [state="error"]
           │      └─ state="error", description="Error Deploying Docs"
           │
           └─ [state="success"]
                  ├─ [deploy_url なし]
                  │      └─ state="success", description="No Docs Changes"
                  │
                  └─ [deploy_url あり]
                         └─ state="success", description="Docs Deployed"
```

### データフロー図

```
[入力]               [処理]                    [出力]

環境変数
├─ state ───────────▶ 状態判定
├─ commit_sha ──────▶ PR/コミット検索
├─ run_id ──────────▶ run_url構築
├─ deploy_url ──────▶ 成功時の分岐判定
└─ github_repository ▶ リポジトリ特定
                            │
                            ▼
                     create_status() ───▶ GitHub Commit Status
                            │
                            ▼
                     [PRページのステータスチェック欄に表示]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deploy_docs_status.py | `scripts/deploy_docs_status.py` | ソース | デプロイステータス・プレビュー通知のメイン処理 |
| GitHub Actions Workflow | `.github/workflows/` | 設定 | ワークフロー定義（トリガー、環境変数設定） |
