# 通知設計書 8-ドキュメントプレビュー通知

## 概要

本ドキュメントは、FastAPIリポジトリにおけるドキュメントの変更がある場合、PRにプレビューリンクをコメントとして通知する機能の設計書である。

### 本通知の処理概要

GitHub Actionsワークフローから実行されるPythonスクリプトにより、ドキュメントのデプロイが成功した際に、変更されたドキュメントページへのプレビューリンク一覧をPRコメントとして投稿する。既存のプレビューコメントがある場合は更新し、ない場合は新規作成する。

**業務上の目的・背景**：PRでドキュメントが変更された場合、レビュアーは変更内容を確認するためにプレビュー環境へアクセスする必要がある。プレビューリンクの一覧をPRコメントとして自動投稿することで、レビュアーは各変更ページへ直接アクセスでき、レビュー効率が大幅に向上する。また、変更前のページ（本番環境）や英語版ページへのリンクも提供され、比較レビューが容易になる。

**通知の送信タイミング**：ドキュメントデプロイが成功（state="success"）し、かつ`deploy_url`が設定されている場合に通知が実行される。デプロイURLがない場合（ドキュメント変更なし）はプレビューコメントは投稿されない。

**通知の受信者**：PRの作成者およびレビュアー。PRページのコメント欄に表示され、メンション設定によりメール通知される可能性もある。

**通知内容の概要**：以下の情報を含むMarkdown形式のコメント：
- ヘッダー「Docs preview」
- 最新コミットSHAとデプロイURL
- 変更されたページ一覧（プレビューリンク、変更前リンク、英語版リンク）

**期待されるアクション**：レビュアーはコメント内のリンクをクリックしてプレビューページを確認し、ドキュメントの変更内容をレビューする。変更前ページとの比較や、翻訳ドキュメントの場合は英語版との比較も行う。

## 通知種別

GitHub PR コメント

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（GitHub REST API） |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

1. commit_shaからPRを特定
2. PRをIssueとして取得（コメントAPI用）
3. 既存のプレビューコメント（github-actions[bot]による「## Docs preview」で始まるコメント）を検索
4. 存在すれば更新、なければ新規作成

## 通知テンプレート

### PRコメントの場合

| 項目 | 内容 |
|-----|------|
| 投稿先 | GitHub PR コメント |
| 投稿者 | github-actions[bot] |
| 形式 | Markdown |

### 本文テンプレート

```markdown
## 📝 Docs preview

Last commit {commit_sha} at: {deploy_url}

### Modified Pages

* {preview_link} - ([before]({previous_link}))
* {preview_link} - ([before]({previous_link})) - ([English]({en_link}))
...
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| commit_sha | コミットSHA | 環境変数（Settings） | Yes |
| deploy_url | デプロイ先URL | 環境変数（Settings） | Yes |
| preview_link | プレビューページURL | PR変更ファイルから算出 | Yes |
| previous_link | 本番環境ページURL | fastapi.tiangolo.com | Yes |
| en_link | 英語版ページURL | 翻訳ドキュメントの場合のみ | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| GitHub Actions | ワークフロー実行 | state="success" かつ deploy_url あり | デプロイ成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| deploy_urlなし | ドキュメント変更がない場合 |
| state != "success" | デプロイ未完了またはエラー時 |
| ドキュメントファイルなし | docs/配下の変更ファイルがない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[デプロイ成功確認] --> B[PR変更ファイル取得]
    B --> C[docs/配下のファイルをフィルタ]
    C --> D{ドキュメントファイルあり?}
    D -->|No| E[リンクなしでメッセージ作成]
    D -->|Yes| F[LinkData作成]
    F --> G[言語別にソート]
    G --> H[メッセージ構築]
    E --> H
    H --> I[PRコメント検索]
    I --> J{既存コメントあり?}
    J -->|Yes| K[コメント更新]
    J -->|No| L[コメント新規作成]
    K --> M[終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| GitHub PRs | PR特定 | PyGitHub経由 |
| GitHub PR Files | 変更ファイル一覧 | PyGitHub経由 |
| GitHub Issue Comments | 既存コメント検索 | PyGitHub経由 |

### テーブル別参照項目詳細

#### GitHub PR Files

| 参照項目 | 用途 | 取得条件 |
|---------|------|---------|
| filename | ファイルパス | docs/で始まるもの |

#### GitHub Issue Comments

| 参照項目 | 用途 | 取得条件 |
|---------|------|---------|
| body | コメント本文 | ヘッダー検索用 |
| user.login | 投稿者 | github-actions[bot]判定 |

### LinkDataモデル

| 参照項目 | 用途 | データ型 |
|---------|------|---------|
| previous_link | 本番環境URL | str |
| preview_link | プレビューURL | str |
| en_link | 英語版URL | str (Optional) |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| GitHub Issue Comments | CREATE/UPDATE | プレビューコメント投稿/更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| PR未検出 | commit_shaに対応するPRなし | エラーログ出力、処理終了 |
| GitHub API認証エラー | トークン無効・期限切れ | 例外発生 |
| ファイルパス解析エラー | 不正なファイルパス形式 | スキップ（continueで次へ） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitHub API制限に依存 |
| 1日あたり上限 | GitHub API制限に依存 |

### 配信時間帯

制限なし（GitHub Actionsイベント駆動）

## セキュリティ考慮事項

- GitHub トークンはSecretStrで保護され、ログ出力時にマスキングされる
- 環境変数経由でトークンを取得（GITHUB_TOKEN）
- PyGitHubのAuth.Token認証を使用
- コメント更新は投稿者（github-actions[bot]）を確認して実行

## 備考

- ドキュメントデプロイステータス通知（No.7）と同一のスクリプト（deploy_docs_status.py）で実装
- 英語ドキュメントと翻訳ドキュメントで異なるURL構造を処理
- 正規表現`r"docs/([^/]+)/docs/(.*)"`でファイルパスを解析
- index.mdは末尾のパスを削除、それ以外は.mdを/に置換
- 言語別にソートして英語を先頭に表示

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

LinkDataモデルとURL構築ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deploy_docs_status.py | `scripts/deploy_docs_status.py` | 行19-23: LinkDataモデル定義 |

**読解のコツ**: LinkDataは3つのURL（previous_link, preview_link, en_link）を保持。en_linkは翻訳ドキュメントの場合のみ設定される。

#### Step 2: ファイルパス解析を理解する

変更ファイルからプレビューURLを構築するロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deploy_docs_status.py | `scripts/deploy_docs_status.py` | 行77-103: ファイルパス解析とLinkData作成 |

**主要処理フロー**:
1. **行77-78**: PRの変更ファイル取得、docs/配下をフィルタ
2. **行82-85**: 正規表現でlangとpathを抽出
3. **行86-91**: index.mdと通常ファイルでパス変換
4. **行92-96**: 言語に応じたURL構築
5. **行97-103**: LinkData作成とen_link設定

#### Step 3: コメント投稿処理を理解する

メッセージ構築とコメント投稿/更新ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | deploy_docs_status.py | `scripts/deploy_docs_status.py` | 行105-130: リンクソートとメッセージ構築 |
| 3-2 | deploy_docs_status.py | `scripts/deploy_docs_status.py` | 行133-143: コメント検索・投稿/更新 |

**主要処理フロー**:
- **行105-117**: 言語別ソート（英語を先頭に）
- **行119-130**: Markdown形式のメッセージ構築
- **行133-143**: 既存コメント検索と投稿/更新判定

### プログラム呼び出し階層図

```
main()
    │
    ├─ [state="success" かつ deploy_url あり の場合]
    │
    ├─ use_pr.get_files() - 変更ファイル取得
    │      │
    │      └─ docs/配下のファイルをフィルタ
    │
    ├─ ファイルパス解析（正規表現）
    │      │
    │      ├─ lang抽出 (en, ja, zh, etc.)
    │      └─ path抽出・変換
    │
    ├─ LinkData作成
    │      │
    │      ├─ previous_link: fastapi.tiangolo.com/{path}
    │      ├─ preview_link: {deploy_url}/{path}
    │      └─ en_link: fastapi.tiangolo.com/{en_path} (翻訳の場合)
    │
    ├─ メッセージ構築
    │      │
    │      ├─ ヘッダー: "## 📝 Docs preview"
    │      ├─ コミット情報
    │      └─ Modified Pages リスト
    │
    └─ PRコメント処理
           │
           ├─ issue.get_comments() - 既存コメント検索
           │
           ├─ [既存あり] comment.edit(message)
           │
           └─ [既存なし] issue.create_comment(message)
```

### データフロー図

```
[入力]               [処理]                    [出力]

PR Files ───────────▶ docs/配下フィルタ
                            │
                            ▼
                     正規表現パース
                     docs/([^/]+)/docs/(.*)
                            │
                            ├─ lang: "en", "ja", etc.
                            └─ path: "tutorial/index.md", etc.
                                   │
                                   ▼
                            LinkData作成
                                   │
                                   ▼
                            言語別ソート
                                   │
                                   ▼
                            Markdownメッセージ ───▶ PR Comment
                                                    │
                                                    ▼
                                              [PRページに表示]

                                              ## 📝 Docs preview
                                              Last commit abc123 at: https://...
                                              ### Modified Pages
                                              * preview - (before) - (English)
```

### メッセージ出力例

```markdown
## 📝 Docs preview

Last commit abc123def456 at: https://fastapi-preview.example.com

### Modified Pages

* https://fastapi-preview.example.com/tutorial/first-steps/ - ([before](https://fastapi.tiangolo.com/tutorial/first-steps/))
* https://fastapi-preview.example.com/ja/tutorial/first-steps/ - ([before](https://fastapi.tiangolo.com/ja/tutorial/first-steps/)) - ([English](https://fastapi.tiangolo.com/tutorial/first-steps/))
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deploy_docs_status.py | `scripts/deploy_docs_status.py` | ソース | デプロイステータス・プレビュー通知のメイン処理 |
| GitHub Actions Workflow | `.github/workflows/` | 設定 | ワークフロー定義（トリガー、環境変数設定） |
