---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-翻訳PR通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **GitHub Actionsワークフロー定義**：実際のワークフローファイルは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/notify_translations.py` 行13-15: ラベル定数定義
- E-02: `scripts/notify_translations.py` 行21-41: all_discussions_query
- E-03: `scripts/notify_translations.py` 行43-60: translation_discussion_query
- E-04: `scripts/notify_translations.py` 行62-72: add_comment_mutation
- E-05: `scripts/notify_translations.py` 行87-175: Pydanticモデル群
- E-06: `scripts/notify_translations.py` 行178-187: Settings定義
- E-07: `scripts/notify_translations.py` 行198-236: get_graphql_response関数
- E-08: `scripts/notify_translations.py` 行284-292: create_comment関数
- E-09: `scripts/notify_translations.py` 行306-428: main関数
- E-10: `scripts/notify_translations.py` 行329-334: ランダムスリープ
- E-11: `scripts/notify_translations.py` 行361: new_translation_message
- E-12: `scripts/notify_translations.py` 行393-410: 通知判定ロジック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | awaiting-reviewとlang-allラベルで通知判定 | E-01, E-12 | ○ |
| C-02 | GitHub GraphQL APIを使用 | E-02, E-03, E-04, E-07 | ○ |
| C-03 | Discussion一覧取得クエリの存在 | E-02 | ○ |
| C-04 | コメント追加ミューテーションの存在 | E-04, E-08 | ○ |
| C-05 | 通知メッセージ形式 | E-11 | ○ |
| C-06 | 0-10秒のランダムスリープ | E-10 | ○ |
| C-07 | SecretStrによるトークン保護 | E-06 | ○ |
| C-08 | 既存通知確認ロジック | E-09 (行384-391) | ○ |
| C-09 | 言語→Discussionマッピング | E-09 (行350-358) | ○ |
| C-10 | PR状態チェック（open/closed） | E-09 (行393, 411) | ○ |
| C-11 | Pydanticモデルによるレスポンス検証 | E-05 | ○ |
| C-12 | PyGitHubとhttpxの併用 | E-09 (行313-314, 218-223) | ○ |
| C-13 | カテゴリID（questions_translations_category_id）のハードコード | E-02 (行19) | ○ |
| C-14 | エラー時RuntimeError発生 | E-07 (行229, 235) | ○ |
| C-15 | PR番号取得ロジック | E-09 (行322-327) | ○ |
| C-16 | 絵文字使用（😉🎉🤓） | E-11 | ○ |
| C-17 | 2名の承認が必要という記述 | E-11 | ○ |
| C-18 | httpx.postによるGraphQLリクエスト | E-07 (行218-223) | ○ |
| C-19 | 環境変数からの設定読み込み | E-06 | ○ |
| C-20 | GitHub Actionsによるトリガー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20のGitHub Actionsワークフロー定義は、`.github/workflows/`配下のファイルを確認していないため、実際のトリガー設定は未検証
  - 候補：`.github/workflows/notify-translations.yml` / 類似のワークフローファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - GraphQL API操作はコードから正確に抽出されている
- 0: 低リスク - 通知メッセージ形式はコードに明記
- 1: 中リスク - GitHub Actionsワークフローの詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] GraphQLクエリ・ミューテーションの構造が正確に記述されているか確認
- [ ] ラベル判定ロジックがコードと一致しているか確認
- [ ] ランダムスリープの目的（競合回避）が正しく理解されているか確認
- [ ] GitHub Actionsワークフローファイルの存在とトリガー設定を確認
