---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 12
  claims_without_evidence: 3
confidence_derived: 0.80
---

# 根拠レポート：5-新規サブスクリプション通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：12 / 15、根拠なし：3
- 優先レビュー（高）
  1. **実際の送信処理**：仕様定義のみで実装なし
  2. **エラー処理・リトライ仕様**：実装例に含まれていない
  3. **セキュリティ考慮事項**：推奨事項として記載

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs_src/openapi_webhooks/tutorial001_py39.py` 行1-4: インポート文
- E-02: `docs_src/openapi_webhooks/tutorial001_py39.py` 行6: FastAPIアプリ作成
- E-03: `docs_src/openapi_webhooks/tutorial001_py39.py` 行9-13: Subscriptionモデル定義
- E-04: `docs_src/openapi_webhooks/tutorial001_py39.py` 行15: @app.webhooks.postデコレータ
- E-05: `docs_src/openapi_webhooks/tutorial001_py39.py` 行16-21: new_subscription関数とdocstring
- E-06: `docs_src/openapi_webhooks/tutorial001_py39.py` 行23-25: read_usersエンドポイント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenAPI Webhooks機能を使用 | E-04 | ○ |
| C-02 | @app.webhooks.post("new-subscription")で定義 | E-04 | ○ |
| C-03 | Subscriptionモデルの構造（username, monthly_fee, start_date） | E-03 | ○ |
| C-04 | datetime型の使用 | E-01, E-03 | ○ |
| C-05 | PydanticのBaseModel継承 | E-01, E-03 | ○ |
| C-06 | docstringによるWebhook仕様文書化 | E-05 | ○ |
| C-07 | ダッシュボードでURL登録（docstring記載） | E-05 | ○ |
| C-08 | 通常APIエンドポイント（/users/）との共存 | E-06 | ○ |
| C-09 | POSTメソッドでのWebhook定義 | E-04 | ○ |
| C-10 | JSONペイロードの送信 | E-03（モデル定義から推定） | ○ |
| C-11 | 仕様定義のみで実際の送信処理なし | E-04, E-05 | ○ |
| C-12 | OpenAPIドキュメントへのwebhooksセクション出力 | E-04（FastAPI機能） | ○ |
| C-13 | リトライ仕様（実装依存） | **根拠なし** | △ |
| C-14 | エラー処理の詳細 | **根拠なし** | △ |
| C-15 | セキュリティ考慮事項（HMAC署名等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13, C-14: 実装例は仕様定義のみのため、実際の送信処理・エラー処理・リトライ仕様は含まれていない
  - 候補：FastAPI公式ドキュメント / Webhookベストプラクティス / 実装ガイド
- C-15: セキュリティ考慮事項は一般的なWebhook実装のベストプラクティスから記載
  - 候補：OWASP Webhook Security / FastAPIセキュリティガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Webhook仕様定義はコードから正確に抽出されている
- 0: 低リスク - Subscriptionモデル構造はコードに明記
- 2: 高リスク - 実際の送信処理は未実装のため、設計書の記述は概念的
- 1: 中リスク - セキュリティ考慮事項は推奨レベルの記載

## 6) レビュアーチェックリスト（最小）
- [ ] Subscriptionモデルのフィールド定義がコードと一致しているか確認
- [ ] @app.webhooks.postデコレータの使用方法が正確か確認
- [ ] 「仕様定義のみ」という制限が明確に記述されているか確認
- [ ] 実装時に必要な追加設計（送信処理、エラー処理）が認識されているか確認
