---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：6-請求書イベント通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **実際のコールバック送信処理**：仕様定義のみで実装なし
  2. **エラー処理・リトライ仕様**：実装例に含まれていない
  3. **セキュリティ考慮事項**：推奨事項として記載

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs_src/openapi_callbacks/tutorial001_py310.py` 行1-3: インポート文
- E-02: `docs_src/openapi_callbacks/tutorial001_py310.py` 行7-12: Invoiceモデル定義
- E-03: `docs_src/openapi_callbacks/tutorial001_py310.py` 行14-16: InvoiceEventモデル定義
- E-04: `docs_src/openapi_callbacks/tutorial001_py310.py` 行19-20: InvoiceEventReceivedモデル定義
- E-05: `docs_src/openapi_callbacks/tutorial001_py310.py` 行23: invoices_callback_router作成
- E-06: `docs_src/openapi_callbacks/tutorial001_py310.py` 行26-30: コールバックエンドポイント定義
- E-07: `docs_src/openapi_callbacks/tutorial001_py310.py` 行33-51: create_invoiceエンドポイント
- E-08: `docs_src/openapi_callbacks/tutorial001_py310.py` 行34: callback_urlパラメータ（HttpUrl型）
- E-09: `docs_src/openapi_callbacks/tutorial001_py310.py` 行27: URLパターン定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenAPI Callbacks機能を使用 | E-05, E-06, E-07 | ○ |
| C-02 | APIRouterでコールバック仕様を定義 | E-05 | ○ |
| C-03 | Invoiceモデルの構造（id, title, customer, total） | E-02 | ○ |
| C-04 | InvoiceEventモデルの構造（description, paid） | E-03 | ○ |
| C-05 | InvoiceEventReceivedモデルの構造（ok） | E-04 | ○ |
| C-06 | callback_urlパラメータ（HttpUrl型、Optional） | E-08 | ○ |
| C-07 | URLパターン `{$callback_url}/invoices/{$request.body.id}` | E-09 | ○ |
| C-08 | callbacksパラメータでルーターを関連付け | E-07 | ○ |
| C-09 | POSTメソッドでのコールバック定義 | E-06 | ○ |
| C-10 | response_model=InvoiceEventReceived | E-06 | ○ |
| C-11 | docstringによる処理フロー説明 | E-07 | ○ |
| C-12 | 「Send the invoice, collect the money, send the notification」フロー | E-07 (docstring) | ○ |
| C-13 | title属性がOptional | E-02 | ○ |
| C-14 | 仕様定義のみで実際の送信処理なし | E-06, E-07 | ○ |
| C-15 | OpenAPIドキュメントのcallbacksセクション出力 | E-05, E-06（FastAPI機能） | ○ |
| C-16 | リトライ仕様（実装依存） | **根拠なし** | △ |
| C-17 | エラー処理の詳細 | **根拠なし** | △ |
| C-18 | セキュリティ考慮事項（HMAC署名等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16, C-17: 実装例は仕様定義のみのため、実際の送信処理・エラー処理・リトライ仕様は含まれていない
  - 候補：FastAPI公式ドキュメント / Callbackベストプラクティス / 実装ガイド
- C-18: セキュリティ考慮事項は一般的なCallback実装のベストプラクティスから記載
  - 候補：OWASP API Security / FastAPIセキュリティガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Callback仕様定義はコードから正確に抽出されている
- 0: 低リスク - Pydanticモデル構造はコードに明記
- 2: 高リスク - 実際の送信処理は未実装のため、設計書の記述は概念的
- 1: 中リスク - セキュリティ考慮事項は推奨レベルの記載

## 6) レビュアーチェックリスト（最小）
- [ ] 3つのPydanticモデル定義がコードと一致しているか確認
- [ ] URLパターンの動的パラメータ（$callback_url, $request.body.id）が正確か確認
- [ ] APIRouterとcallbacksパラメータの関連付けが正確か確認
- [ ] 「仕様定義のみ」という制限が明確に記述されているか確認
- [ ] 実装時に必要な追加設計（送信処理、エラー処理）が認識されているか確認
