---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：7-ドキュメントデプロイステータス通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **GitHub Actionsワークフロー定義**：実際のワークフローファイルは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/deploy_docs_status.py` 行10-17: Settingsクラス定義
- E-02: `scripts/deploy_docs_status.py` 行16: state属性（Literal型）
- E-03: `scripts/deploy_docs_status.py` 行25-27: main関数開始
- E-04: `scripts/deploy_docs_status.py` 行30-34: PR検索ロジック
- E-05: `scripts/deploy_docs_status.py` 行40: run_url構築
- E-06: `scripts/deploy_docs_status.py` 行41-48: pending状態処理
- E-07: `scripts/deploy_docs_status.py` 行50-58: error状態処理
- E-08: `scripts/deploy_docs_status.py` 行59-68: success状態（No Docs Changes）
- E-09: `scripts/deploy_docs_status.py` 行70-75: success状態（Docs Deployed）
- E-10: `scripts/deploy_docs_status.py` 行30: Auth.Token認証

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitHub Commitステータスを使用 | E-06, E-07, E-08, E-09 | ○ |
| C-02 | state属性はLiteral["pending", "success", "error"] | E-02 | ○ |
| C-03 | デフォルトstateは"pending" | E-02 | ○ |
| C-04 | commit_shaからPR検索 | E-04 | ○ |
| C-05 | PR未検出時のエラーログ | E-04 (行35-37) | ○ |
| C-06 | pending状態: description="Deploying Docs" | E-06 | ○ |
| C-07 | error状態: description="Error Deploying Docs" | E-07 | ○ |
| C-08 | success (deploy_urlなし): description="No Docs Changes" | E-08 | ○ |
| C-09 | success (deploy_urlあり): description="Docs Deployed" | E-09 | ○ |
| C-10 | context="deploy-docs" | E-06, E-07, E-08, E-09 | ○ |
| C-11 | target_url=run_url | E-05, E-06, E-07, E-08, E-09 | ○ |
| C-12 | run_url構築: actions/runs/{run_id} | E-05 | ○ |
| C-13 | create_status()メソッド使用 | E-06, E-07, E-08, E-09 | ○ |
| C-14 | SecretStrによるトークン保護 | E-01 | ○ |
| C-15 | Auth.Token認証使用 | E-10 | ○ |
| C-16 | pydantic_settingsによる設定管理 | E-01 | ○ |
| C-17 | ドキュメントプレビュー通知と同一スクリプト | E-01-E-10 | ○ |
| C-18 | GitHub Actionsによるトリガー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18のGitHub Actionsワークフロー定義は、`.github/workflows/`配下のファイルを確認していないため、実際のトリガー設定は未検証
  - 候補：`.github/workflows/deploy-docs.yml` / 類似のワークフローファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Commitステータス作成ロジックはコードから正確に抽出されている
- 0: 低リスク - 各状態のdescriptionはコードに明記
- 1: 中リスク - GitHub Actionsワークフローの詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] state属性の3値（pending/success/error）がコードと一致しているか確認
- [ ] 各状態のdescriptionメッセージが正確か確認
- [ ] run_url構築ロジックが正確か確認
- [ ] PR検索ロジック（head.sha一致）が正確か確認
- [ ] GitHub Actionsワークフローファイルの存在とトリガー設定を確認
