---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：8-ドキュメントプレビュー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **GitHub Actionsワークフロー定義**：実際のワークフローファイルは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/deploy_docs_status.py` 行19-23: LinkDataモデル定義
- E-02: `scripts/deploy_docs_status.py` 行77-78: PR変更ファイル取得
- E-03: `scripts/deploy_docs_status.py` 行82-85: 正規表現パース
- E-04: `scripts/deploy_docs_status.py` 行86-91: パス変換ロジック
- E-05: `scripts/deploy_docs_status.py` 行92-103: LinkData作成
- E-06: `scripts/deploy_docs_status.py` 行105-117: 言語別ソート
- E-07: `scripts/deploy_docs_status.py` 行119-130: メッセージ構築
- E-08: `scripts/deploy_docs_status.py` 行133-143: コメント投稿/更新
- E-09: `scripts/deploy_docs_status.py` 行119: ヘッダー定義
- E-10: `scripts/deploy_docs_status.py` 行137-139: 既存コメント検索条件

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PRコメントとして投稿 | E-08 | ○ |
| C-02 | github-actions[bot]による投稿確認 | E-10 | ○ |
| C-03 | 「## 📝 Docs preview」ヘッダー | E-09 | ○ |
| C-04 | LinkDataモデル（previous_link, preview_link, en_link） | E-01 | ○ |
| C-05 | 正規表現 `r"docs/([^/]+)/docs/(.*)"` | E-03 | ○ |
| C-06 | index.mdは末尾パス削除 | E-04 | ○ |
| C-07 | .mdを/に置換 | E-04 | ○ |
| C-08 | 英語を先頭にソート | E-06 | ○ |
| C-09 | en_linkは翻訳ドキュメントのみ | E-05 | ○ |
| C-10 | 既存コメント更新（edit） | E-08 | ○ |
| C-11 | 新規コメント作成（create_comment） | E-08 | ○ |
| C-12 | deploy_url必須条件 | E-02（行69-75参照） | ○ |
| C-13 | state="success"条件 | E-02（行59参照） | ○ |
| C-14 | docs/配下のファイルフィルタ | E-02 | ○ |
| C-15 | fastapi.tiangolo.comへのリンク | E-05 | ○ |
| C-16 | commit_sha表示 | E-07 | ○ |
| C-17 | Modified Pagesセクション | E-07 | ○ |
| C-18 | before/Englishリンク形式 | E-07 | ○ |
| C-19 | ドキュメントデプロイステータス通知と同一スクリプト | E-01-E-10 | ○ |
| C-20 | GitHub Actionsによるトリガー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20のGitHub Actionsワークフロー定義は、`.github/workflows/`配下のファイルを確認していないため、実際のトリガー設定は未検証
  - 候補：`.github/workflows/deploy-docs.yml` / 類似のワークフローファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイルパース・URL構築ロジックはコードから正確に抽出されている
- 0: 低リスク - コメント投稿/更新ロジックはコードに明記
- 0: 低リスク - LinkDataモデル構造はコードに明記
- 1: 中リスク - GitHub Actionsワークフローの詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] LinkDataモデルの3フィールドがコードと一致しているか確認
- [ ] 正規表現パターンが正確か確認
- [ ] index.md/通常ファイルのパス変換ロジックが正確か確認
- [ ] 言語ソート（英語先頭）ロジックが正確か確認
- [ ] コメント検索条件（ヘッダー + github-actions[bot]）が正確か確認
- [ ] GitHub Actionsワークフローファイルの存在とトリガー設定を確認
