---
generated_at: 2026-01-22 20:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **サポート連絡方法**：実際の連絡先情報が不明
  2. **対応ブラウザ一覧**：公式ドキュメントからの明示的な記載なし
  3. **テンプレート画面の具体的な表示内容**：サンプルコードの実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - FastAPIの概要と技術スタック
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報
- E-05: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件一覧
- E-06: `docs/code-to-docs/画面設計書/1-Swagger_UI.md` - Swagger UI画面設計書
- E-07: `docs/code-to-docs/画面設計書/2-ReDoc.md` - ReDoc画面設計書
- E-08: `docs/code-to-docs/機能設計書/1-FastAPIアプリケーション.md` - FastAPIアプリケーション機能設計書
- E-09: `docs/code-to-docs/機能設計書/13-OAuth2認証.md` - OAuth2認証機能設計書（推定）
- E-10: `fastapi/openapi/docs.py` - Swagger UI/ReDoc HTML生成ソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FastAPIはPython 3.9以上で動作する高性能Webフレームワーク | E-01 | ○ |
| C-02 | Swagger UIは/docsでアクセス可能 | E-02, E-06 | ○ |
| C-03 | ReDocは/redocでアクセス可能 | E-02, E-07 | ○ |
| C-04 | OpenAPI JSONは/openapi.jsonでアクセス可能 | E-02 | ○ |
| C-05 | OAuth2認証フローがサポートされている | E-04, E-05 | ○ |
| C-06 | APIキー認証がサポートされている | E-04 | ○ |
| C-07 | HTTP Basic認証がサポートされている | E-04 | ○ |
| C-08 | Swagger UIでAPIテストの実行が可能 | E-06 | ○ |
| C-09 | ReDocは閲覧専用でAPIテスト機能なし | E-07 | ○ |
| C-10 | Jinja2テンプレートがサポートされている | E-04 | ○ |
| C-11 | HTTPステータスコード422はバリデーションエラー | E-04, E-05 | ○ |
| C-12 | openapi_url=Noneでドキュメント無効化 | E-06, E-08 | ○ |
| C-13 | JavaScript有効化が必須 | E-06, E-07 | ○ |
| C-14 | CDN（jsdelivr）からSwagger UI/ReDocを読み込み | E-06, E-07 | ○ |
| C-15 | OAuth2リダイレクトは/docs/oauth2-redirect | E-02, E-06 | ○ |
| C-16 | GET/POST/PUT/DELETE等のHTTPメソッドに対応 | E-04, E-05 | ○ |
| C-17 | CORSMiddlewareでCORS設定が可能 | E-04 | ○ |
| C-18 | パスパラメータ/クエリパラメータのバリデーション | E-04, E-05 | ○ |
| C-19 | Pydanticモデルによる自動検証 | E-01, E-05 | ○ |
| C-20 | 三カラムレイアウトでReDocが表示 | E-07 | ○ |
| C-21 | curlコマンドがSwagger UIで表示される | E-06 | ○ |
| C-22 | 検索機能がReDocで利用可能 | E-07 | ○ |
| C-23 | 対応ブラウザ（Chrome, Edge, Safari, Firefox） | **根拠なし** | △ |
| C-24 | サポートへの連絡方法 | **根拠なし** | △ |
| C-25 | テンプレート画面の具体的表示内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **対応ブラウザ一覧（C-23）**
  - FastAPI公式ドキュメントに明示的なブラウザサポート情報なし
  - 候補：FastAPI公式ドキュメント / Swagger UI公式ドキュメント / 実機テスト結果
- **サポートへの連絡方法（C-24）**
  - 具体的なサポート連絡先はプロジェクト固有の情報
  - 候補：プロジェクト運用ドキュメント / 組織の問い合わせ窓口情報 / README
- **テンプレート画面の表示内容（C-25）**
  - docs_src/templatesのサンプルコードは参考実装であり、実際の表示は実装依存
  - 候補：実際のアプリケーションコード / テンプレートファイル / 画面キャプチャ

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 技術的な記載（C-01〜C-22）: FastAPI公式ソースコード・ドキュメントに基づく記載
- **1: 中リスク** - ブラウザサポート（C-23）: 一般的なモダンブラウザを記載しているが、公式根拠なし
- **1: 中リスク** - サポート連絡方法（C-24）: プレースホルダー的記載、実際の運用に合わせて更新必要
- **0: 低リスク** - テンプレート画面（C-25）: サンプルとして記載、実装により変動することを明記済み

## 6) レビュアーチェックリスト（最小）
- [ ] Swagger UIの操作手順が実際の画面と一致しているか確認
- [ ] OAuth2認証フローの手順が正確か確認
- [ ] エラーメッセージ一覧が実際のシステムと一致しているか確認
- [ ] 対応ブラウザ一覧をプロジェクトの実態に合わせて更新
- [ ] サポート連絡先をプロジェクト固有の情報に更新
- [ ] HTTPステータスコードの説明が十分か確認
- [ ] 業務フロー図がユーザーの実際の作業フローと一致しているか確認
