# FastAPI 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】APIドキュメント確認（Swagger UI）](#4-step1apiドキュメント確認swagger-ui)
5. [【STEP2-3】APIテスト実行](#5-step2-3apiテスト実行)
6. [【STEP3-4】認証・認可設定](#6-step3-4認証認可設定)
7. [【STEP4-5】APIレスポンス確認](#7-step4-5apiレスポンス確認)

**【サポート機能】**
8. [ReDocドキュメント閲覧](#8-redocドキュメント閲覧)
9. [OpenAPIスキーマ参照](#9-openapiスキーマ参照)
10. [テンプレート画面](#10-テンプレート画面)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 FastAPIとは

FastAPIは、Python 3.9以上で動作する高性能なWebフレームワークです。標準的なPython型ヒントを活用してAPIを構築でき、OpenAPI（Swagger）およびJSON Schemaに完全準拠した自動ドキュメント生成機能を備えています。

本マニュアルでは、FastAPIフレームワークが提供する各種画面（APIドキュメント、テスト機能等）の操作方法を説明します。

### 1.2 本システムで行う主要業務

本システム（FastAPIベースのAPIアプリケーション）は、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **API仕様確認** | APIエンドポイントの仕様確認、パラメータ・レスポンス形式の把握 |
| **APIテスト** | Swagger UIを使用したAPIのインタラクティブなテスト実行 |
| **ドキュメント参照** | ReDocによる読みやすいAPIドキュメントの閲覧 |
| **認証設定** | OAuth2認証フローの実行、APIキー・トークンの設定 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                        業務フロー                                │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】APIドキュメント画面（/docs）にアクセス                 │
│      ↓                                                          │
│  【STEP 2】目的のAPIエンドポイントを選択・展開                    │
│      ↓                                                          │
│  【STEP 3】必要に応じて認証情報を設定（Authorize）               │
│      ↓                                                          │
│  【STEP 4】パラメータを入力してAPIをテスト実行（Try it out）      │
│      ↓                                                          │
│  【STEP 5】レスポンスを確認して結果を検証                        │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **API開発者** | APIエンドポイントの設計・実装、Swagger UIでのテスト実行 |
| **フロントエンド開発者** | API仕様の確認、リクエスト/レスポンス形式の把握、連携テスト |
| **QAエンジニア** | APIの動作確認、エッジケースのテスト |
| **APIユーザー** | APIドキュメントの参照、API利用方法の理解 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| Swagger UI | インタラクティブなAPIドキュメント・テスト画面 | STEP 1-5（メイン画面） |
| ReDoc | 読みやすいAPIドキュメント表示 | 随時参照 |
| OpenAPI JSON | APIスキーマの機械可読形式 | 外部ツール連携時 |
| OAuth2認証 | セキュアなAPI認証 | STEP 3 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| API開発者 | FastAPIアプリケーションを開発・保守する技術者 |
| APIユーザー | 公開されたAPIを利用する開発者・システム |
| 管理者 | APIアプリケーションの運用・監視を行う担当者 |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

※ JavaScript有効化が必須です。

---

## 2. ログイン・ログアウト手順

### 2.1 アクセス方法

FastAPIのドキュメント画面自体にはログイン機能はありません。ブラウザで直接URLにアクセスします。

1. ブラウザを開きます
2. FastAPIアプリケーションのURLにアクセスします
   - Swagger UI: `http://{サーバーアドレス}:{ポート}/docs`
   - ReDoc: `http://{サーバーアドレス}:{ポート}/redoc`
   - 例: `http://localhost:8000/docs`

### 2.2 API認証（Authorize）

APIエンドポイントに認証が設定されている場合、以下の手順で認証情報を設定します。

**OAuth2認証の場合：**

1. Swagger UI画面右上の「Authorize」ボタンをクリックします
2. 認証ダイアログが表示されます
3. 必要な認証情報を入力します：
   - **Username**: ユーザー名
   - **Password**: パスワード
   - **Client credentials location**: 認証情報の送信方法
4. 「Authorize」ボタンをクリックします
5. 認証に成功すると、鍵アイコンが閉じた状態に変わります

**APIキー認証の場合：**

1. 「Authorize」ボタンをクリックします
2. APIキーの入力欄にキーを入力します
3. 「Authorize」ボタンをクリックします

### 2.3 認証の解除

1. 「Authorize」ボタンをクリックします
2. 「Logout」ボタンをクリックします
3. 認証情報がクリアされます

---

## 3. トップページ（TOP画面）

### 3.1 Swagger UI（/docs）

Swagger UIはFastAPIのデフォルトのAPIドキュメント画面です。

**画面構成：**

| 領域 | 説明 |
|------|------|
| ヘッダー | APIタイトル、バージョン、説明が表示されます |
| Authorizeボタン | OAuth2等の認証設定を行うボタン |
| タグ別エンドポイント一覧 | APIエンドポイントがタグごとにグループ化されて表示されます |
| スキーマ定義 | リクエスト/レスポンスのデータモデル定義 |

**表示情報：**

- APIタイトル（アプリケーション名 + " - Swagger UI"）
- APIバージョン
- API説明（Markdown形式）
- サーバー選択ドロップダウン
- 各エンドポイントのHTTPメソッド、パス、概要

### 3.2 ReDoc（/redoc）

ReDocは読みやすさに特化した代替ドキュメント画面です。

**画面構成（三カラムレイアウト）：**

| カラム | 説明 |
|--------|------|
| 左サイドバー | エンドポイント一覧のナビゲーションメニュー |
| 中央ペイン | 選択したエンドポイントの詳細説明 |
| 右ペイン | リクエスト/レスポンス例とコードサンプル |

---

## 4. 【STEP1】APIドキュメント確認（Swagger UI）

> **業務フローでの位置**: APIの仕様を確認し、利用するエンドポイントを特定するステップです。

### 4.1 Swagger UIにアクセスする

1. ブラウザで `http://{サーバーアドレス}/docs` にアクセスします
2. OpenAPIスキーマが自動的に読み込まれます
3. 「Loading...」表示後、APIドキュメントが表示されます

### 4.2 エンドポイント一覧を確認する

1. 画面に表示されるエンドポイント一覧を確認します
2. エンドポイントはタグごとにグループ化されています
3. HTTPメソッド（GET、POST、PUT、DELETE等）が色分けされています：
   - **GET**: 緑色 - データの取得
   - **POST**: 青色 - データの作成
   - **PUT**: オレンジ色 - データの更新
   - **DELETE**: 赤色 - データの削除
   - **PATCH**: 紫色 - データの部分更新

### 4.3 エンドポイントの詳細を展開する

1. 確認したいエンドポイントの行をクリックします
2. 詳細情報が展開されます：
   - **Parameters**: パスパラメータ、クエリパラメータの定義
   - **Request body**: リクエストボディの形式（POSTリクエスト等）
   - **Responses**: 想定されるレスポンス（ステータスコードごと）

### 4.4 パラメータの仕様を確認する

展開されたエンドポイント詳細で、各パラメータの情報を確認できます：

| 項目 | 説明 |
|------|------|
| Name | パラメータ名 |
| Description | パラメータの説明 |
| Required | 必須かどうか（赤いアスタリスクで表示） |
| Type | データ型（integer、string、boolean等） |
| Default | デフォルト値（設定されている場合） |

---

## 5. 【STEP2-3】APIテスト実行

> **業務フローでの位置**: APIエンドポイントを選択し、実際にリクエストを送信してテストするステップです。

### 5.1 テストモードを有効にする

1. テストしたいエンドポイントを展開します
2. 「Try it out」ボタンをクリックします
3. パラメータ入力欄が編集可能になります

### 5.2 パラメータを入力する

**パスパラメータの入力：**
1. URLに含まれるパラメータ（例: `/items/{item_id}`）の値を入力します
2. 必須パラメータは赤いアスタリスクで示されています

**クエリパラメータの入力：**
1. オプションのクエリパラメータを必要に応じて入力します
2. デフォルト値が設定されている場合は自動的に入力されています

**リクエストボディの入力：**
1. JSONエディタにリクエストボディを入力します
2. 「Example Value」をクリックするとサンプルが自動入力されます
3. 必要に応じて値を編集します

### 5.3 リクエストを実行する

1. パラメータ入力完了後、「Execute」ボタンをクリックします
2. Swagger UIがAPIリクエストを送信します
3. 結果が「Responses」セクションに表示されます

### 5.4 実行結果を確認する

**表示される情報：**

| 項目 | 説明 |
|------|------|
| Curl | 送信されたリクエストのcurlコマンド |
| Request URL | 実際にリクエストが送信されたURL |
| Server response | ステータスコードとレスポンスボディ |
| Response body | JSON形式のレスポンスデータ |
| Response headers | レスポンスヘッダー情報 |

---

## 6. 【STEP3-4】認証・認可設定

> **業務フローでの位置**: セキュアなAPIエンドポイントにアクセスするための認証を設定するステップです。

### 6.1 OAuth2認証の設定

**パスワードフローの場合：**

1. 「Authorize」ボタンをクリックします
2. 以下の情報を入力します：
   - **Username**: ユーザー名
   - **Password**: パスワード
3. 「Authorize」ボタンをクリックします
4. 認証成功後、ダイアログを閉じます

**認証コードフローの場合：**

1. 「Authorize」ボタンをクリックします
2. OAuth2プロバイダーへリダイレクトされます
3. プロバイダーでログイン・認可を行います
4. `/docs/oauth2-redirect` にリダイレクトされます
5. トークンが自動的に取得・保存されます

### 6.2 APIキー認証の設定

1. 「Authorize」ボタンをクリックします
2. APIキーの種類を確認します：
   - **Header**: HTTPヘッダーで送信
   - **Query**: クエリパラメータで送信
   - **Cookie**: Cookieで送信
3. APIキーを入力欄に貼り付けます
4. 「Authorize」ボタンをクリックします

### 6.3 HTTP Basic認証の設定

1. 「Authorize」ボタンをクリックします
2. 以下の情報を入力します：
   - **Username**: ユーザー名
   - **Password**: パスワード
3. 「Authorize」ボタンをクリックします

### 6.4 認証状態の確認

- 認証済みのスキームは鍵アイコンが閉じた状態で表示されます
- 未認証のスキームは鍵アイコンが開いた状態で表示されます
- エンドポイントに必要な認証スキームは、各エンドポイントの横に鍵アイコンで表示されます

---

## 7. 【STEP4-5】APIレスポンス確認

> **業務フローでの位置**: APIテスト実行後、レスポンスを確認して結果を検証するステップです。

### 7.1 ステータスコードの確認

APIレスポンスのステータスコードを確認します：

| ステータスコード | 意味 | 対処 |
|----------------|------|------|
| 200 OK | リクエスト成功 | 正常に処理されました |
| 201 Created | リソース作成成功 | 新しいリソースが作成されました |
| 204 No Content | 成功（レスポンスボディなし） | 削除等の操作が成功しました |
| 400 Bad Request | リクエストエラー | パラメータを確認してください |
| 401 Unauthorized | 認証エラー | 認証情報を設定してください |
| 403 Forbidden | 認可エラー | アクセス権限を確認してください |
| 404 Not Found | リソースが見つからない | URLやパラメータを確認してください |
| 422 Unprocessable Entity | バリデーションエラー | 入力値を確認してください |
| 500 Internal Server Error | サーバーエラー | 管理者に連絡してください |

### 7.2 レスポンスボディの確認

1. 「Response body」セクションでJSONレスポンスを確認します
2. データが正しく返されているか検証します
3. 「Download」ボタンでレスポンスをファイルとして保存できます

### 7.3 レスポンスヘッダーの確認

「Response headers」セクションで以下を確認できます：
- Content-Type
- Content-Length
- その他のカスタムヘッダー

### 7.4 curlコマンドの利用

表示されるcurlコマンドをコピーして、ターミナルから直接APIを呼び出すことができます：

1. 「Curl」セクションのコマンドをコピーします
2. ターミナルに貼り付けて実行します
3. 同じリクエストがターミナルから送信されます

---

## 8. ReDocドキュメント閲覧

### 8.1 ReDocにアクセスする

1. ブラウザで `http://{サーバーアドレス}/redoc` にアクセスします
2. OpenAPIスキーマが読み込まれ、ドキュメントが表示されます

### 8.2 エンドポイントを検索する

1. 左上の検索ボックスにキーワードを入力します
2. マッチするエンドポイントがフィルタリングされます
3. 検索結果からエンドポイントをクリックして詳細を表示します

### 8.3 エンドポイント詳細を閲覧する

1. 左サイドバーでエンドポイントをクリックします
2. 中央ペインに詳細情報がスクロール表示されます
3. 右ペインでリクエスト/レスポンス例を確認します

**表示される情報：**
- エンドポイントの説明
- パラメータの詳細定義
- リクエストボディのスキーマ
- レスポンスのスキーマと例
- 各種言語でのコードサンプル

### 8.4 スキーマ定義を確認する

1. ページ下部の「Schemas」セクションを確認します
2. データモデルの構造定義が表示されます
3. 展開/折りたたみでネストされたスキーマを確認できます

---

## 9. OpenAPIスキーマ参照

### 9.1 OpenAPI JSONにアクセスする

1. ブラウザで `http://{サーバーアドレス}/openapi.json` にアクセスします
2. OpenAPI仕様のJSONスキーマが表示されます

### 9.2 スキーマの活用方法

OpenAPIスキーマは以下の用途で活用できます：

| 用途 | 説明 |
|------|------|
| クライアントコード生成 | OpenAPI Generatorでクライアントライブラリを自動生成 |
| APIテストツール連携 | Postman等のツールにインポート |
| ドキュメント生成 | 静的ドキュメントの生成 |
| API監視 | APIの仕様変更の検知 |

### 9.3 スキーマのダウンロード

1. ブラウザでJSONを表示します
2. 「Ctrl + S」（または「Cmd + S」）で保存します
3. ファイル名: `openapi.json`

---

## 10. テンプレート画面

### 10.1 Jinja2テンプレート画面について

FastAPIはJinja2テンプレートエンジンをサポートしており、HTMLレスポンスを返す画面を作成できます。

### 10.2 サンプル画面（アイテム詳細画面）

**アクセス方法：**
1. `http://{サーバーアドレス}/items/{id}` にアクセスします
2. `{id}` には表示したいアイテムのIDを指定します

**表示内容：**
- アイテムID
- その他アイテム情報（アプリケーションの実装による）

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】APIドキュメント画面にアクセス → 4章参照
    ↓
【STEP 2】目的のAPIエンドポイントを選択 → 4章参照
    ↓
【STEP 3】認証情報を設定（必要な場合） → 6章参照
    ↓
【STEP 4】パラメータを入力してAPIをテスト → 5章参照
    ↓
【STEP 5】レスポンスを確認して検証 → 7章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【API開発者】STEP1-5: 新規APIのテスト

新しいAPIエンドポイントを実装した後のテスト手順です。

1. FastAPIアプリケーションを起動します
2. ブラウザで `/docs` にアクセスします
3. 新しく追加したエンドポイントを見つけます
4. 「Try it out」をクリックしてテストモードにします
5. テストデータを入力します
6. 「Execute」をクリックしてテストを実行します
7. レスポンスが期待通りか確認します
8. エラーがある場合はコードを修正して再テストします

### 11.2 【フロントエンド開発者】STEP1-2: API仕様確認

フロントエンドからAPIを呼び出す際の仕様確認手順です。

1. ブラウザで `/docs` または `/redoc` にアクセスします
2. 使用するAPIエンドポイントを探します
3. パラメータの型と必須/任意を確認します
4. レスポンスの形式を確認します
5. curlコマンドをコピーしてテストします

### 11.3 【QAエンジニア】STEP3-5: エッジケーステスト

APIの境界条件テスト手順です。

1. `/docs` にアクセスします
2. テスト対象のエンドポイントを選択します
3. 以下のパターンでテストします：
   - 正常値
   - 境界値（最大値、最小値）
   - 不正な型の値
   - 空値・null値
   - 長すぎる文字列
4. 各パターンでのレスポンスを記録します
5. 期待通りのエラーメッセージが返るか確認します

---

## 12. よくある質問と対処法

### 12.1 アクセスに関するQ&A

**Q: /docs にアクセスしても何も表示されません**

A: 以下を確認してください：
1. FastAPIアプリケーションが起動しているか
2. `openapi_url` が `None` に設定されていないか
3. `docs_url` が `None` に設定されていないか
4. JavaScriptが有効になっているか
5. コンソールにエラーメッセージが出ていないか

**Q: ReDocが表示されません**

A: 以下を確認してください：
1. `redoc_url` が `None` に設定されていないか
2. CDN（jsdelivr）へのアクセスがブロックされていないか
3. noscriptメッセージが表示される場合はJavaScriptを有効にしてください

### 12.2 認証に関するQ&A

**Q: Authorizeしても認証エラーが出ます**

A: 以下を確認してください：
1. ユーザー名・パスワードが正しいか
2. APIキーの形式が正しいか（Bearer トークンの場合は `Bearer ` プレフィックスが必要な場合があります）
3. トークンの有効期限が切れていないか
4. 必要なスコープが設定されているか

**Q: OAuth2認証後にリダイレクトされません**

A: 以下を確認してください：
1. `swagger_ui_oauth2_redirect_url` が正しく設定されているか
2. OAuth2プロバイダーのリダイレクトURIに `/docs/oauth2-redirect` が登録されているか

### 12.3 APIテストに関するQ&A

**Q: Executeボタンを押しても応答がありません**

A: 以下を確認してください：
1. サーバーが起動しているか
2. ネットワーク接続が正常か
3. CORSエラーが発生していないか（ブラウザのコンソールを確認）
4. タイムアウトが発生していないか

**Q: 422 Unprocessable Entity エラーが返されます**

A: 入力データのバリデーションエラーです。以下を確認してください：
1. 必須パラメータがすべて入力されているか
2. データ型が正しいか（数値には数値を、文字列には文字列を）
3. 制約条件を満たしているか（最小値、最大値、文字数制限等）
4. エラーメッセージの詳細を確認して修正してください

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| "Failed to load API definition." | OpenAPIスキーマの読み込み失敗 | サーバーが起動しているか確認。/openapi.json に直接アクセスして確認 |
| "Loading..." が続く | スキーマ取得中のハング | ページをリロード。サーバーログを確認 |
| "Authorization may be unsafe..." | OAuth2の状態不一致 | ブラウザのCookieをクリアして再試行 |
| "ReDoc requires Javascript to function." | JavaScript無効 | ブラウザの設定でJavaScriptを有効化 |
| "Network Error" | 通信エラー | ネットワーク接続を確認。CORSエラーの可能性も確認 |

### 13.2 よくあるトラブルと解決方法

**トラブル: ページが真っ白で何も表示されない**

解決方法：
1. ブラウザの開発者ツール（F12）を開きます
2. Consoleタブでエラーメッセージを確認します
3. Networkタブでリクエストの状態を確認します
4. 赤色のエラーがある場合はその内容に従って対処します

**トラブル: CORSエラーが発生する**

解決方法：
1. FastAPIアプリケーションでCORSMiddlewareが設定されているか確認します
2. 許可されたオリジンに現在のホストが含まれているか確認します
3. 必要に応じてCORS設定を追加します

**トラブル: 日本語が文字化けする**

解決方法：
1. レスポンスのContent-Typeヘッダーを確認します
2. `charset=utf-8` が設定されているか確認します
3. JSONレスポンスの場合は通常自動で設定されます

### 13.3 サポートへの連絡方法

問題が解決しない場合は、以下の情報を添えて管理者に連絡してください：

1. 発生した日時
2. 使用しているブラウザとバージョン
3. 実行した操作手順
4. 表示されたエラーメッセージ（スクリーンショット推奨）
5. ブラウザの開発者ツールのコンソールログ

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-22 | 初版作成 |

---

*本マニュアルは、FastAPIフレームワークのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
