---
generated_at: 2026-01-22 21:30:00
metrics:
  claims_total: 73
  claims_with_evidence: 68
  claims_without_evidence: 5
confidence_derived: 0.93
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された非機能要件テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：68 / 73、根拠なし：5
- 優先レビュー（高）
  1. **NFT-007 同時接続数テスト**：具体的な数値「10000以上」の検証が必要
  2. **NFT-003 OpenAPIスキーマ生成性能テスト**：「500ms以内」の合格基準の根拠が明示されていない
  3. **NFT-001/002 レスポンスタイム目標値**：「50ms/100ms」の目標値は非機能要件定義書から参照しているが、実測根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pyproject.toml` - プロジェクト設定、依存関係、Python対応バージョン
- E-02: `fastapi/security/oauth2.py` - OAuth2認証実装
- E-03: `fastapi/security/http.py` - HTTP認証（Basic/Bearer/Digest）実装
- E-04: `fastapi/security/api_key.py` - APIキー認証実装
- E-05: `fastapi/security/open_id_connect_url.py` - OpenID Connect実装
- E-06: `fastapi/middleware/cors.py` - CORS Middleware（Starletteからの再エクスポート）
- E-07: `fastapi/middleware/httpsredirect.py` - HTTPS Redirect Middleware
- E-08: `fastapi/middleware/trustedhost.py` - Trusted Host Middleware
- E-09: `fastapi/middleware/gzip.py` - GZip圧縮Middleware
- E-10: `fastapi/responses.py` - ORJSONResponse, UJSONResponse実装
- E-11: `fastapi/concurrency.py` - 並行処理ユーティリティ（run_in_threadpool等）
- E-12: `fastapi/background.py` - BackgroundTasks実装
- E-13: `fastapi/exceptions.py` - 例外クラス定義（HTTPException等）
- E-14: `fastapi/exception_handlers.py` - 例外ハンドラ実装
- E-15: `fastapi/params.py` - パラメータ型（Path/Query/Body/Form/Cookie/Header）
- E-16: `fastapi/routing.py` - ルーティング実装
- E-17: `fastapi/applications.py` - FastAPIアプリケーションクラス
- E-18: `fastapi/openapi/docs.py` - Swagger UI/ReDoc生成
- E-19: `fastapi/openapi/utils.py` - OpenAPIスキーマ生成
- E-20: `fastapi/websockets.py` - WebSocket対応
- E-21: `.github/workflows/test.yml` - CI/CDテスト設定（カバレッジ100%、マルチOS/Pythonバージョン）
- E-22: `tests/benchmarks/test_general_performance.py` - パフォーマンスベンチマークテスト
- E-23: `docs/code-to-docs/非機能要件定義書/非機能要件定義書.md` - 非機能要件定義書
- E-24: `fastapi/dependencies/utils.py` - 依存性注入ユーティリティ
- E-25: `fastapi/middleware/asyncexitstack.py` - AsyncExitStack Middleware
- E-26: `fastapi/logger.py` - ロガー定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001 同期API応答性能（50ms以内） | E-23, E-16 | ○ |
| C-02 | NFT-002 非同期API応答性能（100ms以内） | E-23, E-11 | ○ |
| C-03 | NFT-003 OpenAPIスキーマ生成性能（500ms以内） | E-23, E-19 | ○ |
| C-04 | NFT-004 OpenAPIスキーマキャッシュ性能 | E-17, E-19 | ○ |
| C-05 | NFT-005 Swagger UI表示性能（1秒以内） | E-23, E-18 | ○ |
| C-06 | NFT-006 WebSocket接続確立性能（100ms以内） | E-23, E-20 | ○ |
| C-07 | NFT-007 同時接続数（10000以上） | E-23 | △ |
| C-08 | NFT-008 大量リクエスト処理 | E-01, E-22 | ○ |
| C-09 | NFT-009 並行処理制御（CapacityLimiter） | E-11 | ○ |
| C-10 | NFT-010 GZip圧縮性能 | E-09 | ○ |
| C-11 | NFT-011 ORJSON高速シリアライゼーション | E-10 | ○ |
| C-12 | NFT-012 UJSON高速シリアライゼーション | E-10 | ○ |
| C-13 | NFT-013 スレッドプール非同期実行 | E-11 | ○ |
| C-14 | NFT-014 バックグラウンドタスク性能 | E-12 | ○ |
| C-15 | NFT-015 同期バリデーション性能 | E-22 | ○ |
| C-16 | NFT-016 非同期バリデーション性能 | E-22 | ○ |
| C-17 | NFT-017 大量ペイロード受信性能 | E-22 | ○ |
| C-18 | NFT-018 大量レスポンス送信性能 | E-22 | ○ |
| C-19 | NFT-019 OAuth2パスワードフロー認証 | E-02 | ○ |
| C-20 | NFT-020 OAuth2認可コードフロー認証 | E-02 | ○ |
| C-21 | NFT-021 HTTP Basic認証 | E-03 | ○ |
| C-22 | NFT-022 HTTP Bearer認証 | E-03 | ○ |
| C-23 | NFT-023 HTTP Digest認証 | E-03 | ○ |
| C-24 | NFT-024 APIキークエリ認証 | E-04 | ○ |
| C-25 | NFT-025 APIキーヘッダー認証 | E-04 | ○ |
| C-26 | NFT-026 APIキーCookie認証 | E-04 | ○ |
| C-27 | NFT-027 OpenID Connect認証 | E-05 | ○ |
| C-28 | NFT-028 スコープベース認可 | E-02 | ○ |
| C-29 | NFT-029 オプション認証（auto_error=False） | E-02, E-03, E-04 | ○ |
| C-30 | NFT-030 HTTPSリダイレクト | E-07 | ○ |
| C-31 | NFT-031 信頼済みホスト検証 | E-08 | ○ |
| C-32 | NFT-032 CORS設定 | E-06 | ○ |
| C-33 | NFT-033 Pydanticバリデーション | E-01 | ○ |
| C-34 | NFT-034 リクエストバリデーションエラー | E-13 | ○ |
| C-35 | NFT-035 パスパラメータ検証 | E-15 | ○ |
| C-36 | NFT-036 クエリパラメータ検証 | E-15 | ○ |
| C-37 | NFT-037 ボディパラメータ検証 | E-15 | ○ |
| C-38 | NFT-038 フォームパラメータ検証 | E-15 | ○ |
| C-39 | NFT-039 Cookieパラメータ検証 | E-15 | ○ |
| C-40 | NFT-040 Headerパラメータ検証 | E-15 | ○ |
| C-41 | NFT-041 HTTPException処理 | E-13 | ○ |
| C-42 | NFT-042 カスタム例外ハンドラ | E-14 | ○ |
| C-43 | NFT-043 バリデーションエラーハンドラ | E-14 | ○ |
| C-44 | NFT-044 WebSocket例外処理 | E-13 | ○ |
| C-45 | NFT-045 Lifespanイベント起動 | E-17 | ○ |
| C-46 | NFT-046 Lifespanイベント終了 | E-17 | ○ |
| C-47 | NFT-047 AsyncExitStackリソース解放 | E-25 | ○ |
| C-48 | NFT-048 依存性yield例外処理 | E-16 | ○ |
| C-49 | NFT-049 Python 3.9互換性 | E-01, E-21 | ○ |
| C-50 | NFT-050 Python 3.10互換性 | E-01, E-21 | ○ |
| C-51 | NFT-051 Python 3.11互換性 | E-01, E-21 | ○ |
| C-52 | NFT-052 Python 3.12互換性 | E-01, E-21 | ○ |
| C-53 | NFT-053 Python 3.13互換性 | E-01, E-21 | ○ |
| C-54 | NFT-054 Python 3.14互換性 | E-01, E-21 | ○ |
| C-55 | NFT-055 Ubuntu互換性 | E-21 | ○ |
| C-56 | NFT-056 macOS互換性 | E-21 | ○ |
| C-57 | NFT-057 Windows互換性 | E-21 | ○ |
| C-58 | NFT-058 Starlette互換性 | E-01 | ○ |
| C-59 | NFT-059 Pydantic v2互換性 | E-01 | ○ |
| C-60 | NFT-060 Pydantic v1非対応確認 | E-13 | ○ |
| C-61 | NFT-061 型ヒント検証（strict mypy） | E-01 | ○ |
| C-62 | NFT-062 リンターチェック（ruff） | E-01 | ○ |
| C-63 | NFT-063 テストカバレッジ100% | E-21 | ○ |
| C-64 | NFT-064 OpenAPI 3.1.0スキーマ生成 | E-19 | ○ |
| C-65 | NFT-065 Swagger UI自動生成 | E-18 | ○ |
| C-66 | NFT-066 ReDoc自動生成 | E-18 | ○ |
| C-67 | NFT-067 依存性注入負荷 | E-24 | ○ |
| C-68 | NFT-068 依存性キャッシュ負荷 | E-15 | ○ |
| C-69 | NFT-069 WebSocket多重接続 | E-20 | △ |
| C-70 | NFT-070 デバッグモードロギング | E-17 | ○ |
| C-71 | NFT-071 本番モードロギング | E-26 | ○ |
| C-72 | NFT-072 Uvicornデプロイメント | E-01 | ○ |
| C-73 | NFT-073 Uvicorn + uvloop性能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **NFT-007 同時接続数「10000以上」**: 非機能要件定義書に記載はあるが、実際のベンチマーク結果や検証手順が存在しない
  - 候補：負荷テストツール（Locust/k6）による実測 / anyio公式ドキュメント / Uvicorn公式ベンチマーク
- **NFT-069 WebSocket多重接続**: 具体的な負荷テストシナリオが未定義
  - 候補：WebSocketテスト専用ツール / tests/ディレクトリの既存WebSocketテスト拡張
- **NFT-073 Uvicorn + uvloop性能**: uvloop有効時の具体的な性能向上数値が未検証
  - 候補：Uvicorn公式ベンチマーク / uvloop公式ドキュメント / 独自ベンチマーク実施
- **NFT-001/002 レスポンスタイム目標値**: 目標値の妥当性検証が必要
  - 候補：業界標準値との比較 / 類似フレームワーク（Starlette/Flask/Django）との比較
- **NFT-003 OpenAPIスキーマ生成500ms**: 初回生成時間の実測データが不足
  - 候補：ベンチマークテスト追加 / プロファイリング結果

## 5) リスクフラグ（レビュー観点）
- **リスクレベル1（中）**: NFT-007 同時接続数 - 数値目標の検証手段が不明確
- **リスクレベル1（中）**: NFT-001/002 レスポンスタイム - 目標値の根拠が非機能要件定義書のみ
- **リスクレベル0（低）**: NFT-073 uvloop性能 - オプション機能のため影響範囲限定的
- **リスクレベル0（低）**: NFT-069 WebSocket多重接続 - 負荷テストシナリオは運用要件に依存

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テストケース（NFT-001〜018）の合格基準は適切か
- [ ] セキュリティテストケース（NFT-019〜040）は既存のセキュリティテスト（tests/test_security*.py）と整合しているか
- [ ] 互換性テストケース（NFT-049〜060）はCI/CD設定（.github/workflows/test.yml）と一致しているか
- [ ] 保守性テストケース（NFT-061〜066）はプロジェクト設定（pyproject.toml）と整合しているか
- [ ] 負荷テスト（NFT-067〜069）の測定項目・合格基準は十分か
- [ ] 運用テスト（NFT-070〜073）はデプロイ環境の要件を満たしているか
