---
generated_at: 2026-01-22 20:55:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **レスポンスタイム目標値**：具体的な数値は推定値であり、ベンチマーク結果による検証が必要
  2. **同時接続数10,000以上**：理論値であり、実環境での検証が必要
  3. **HTTPDigest認証のスタブ実装**：実装状況の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/applications.py` - FastAPIクラス定義、debug設定、Lifespan管理
- E-02: `fastapi/security/__init__.py` - セキュリティモジュール公開API
- E-03: `fastapi/security/oauth2.py` - OAuth2認証実装
- E-04: `fastapi/security/http.py` - HTTP認証（Basic/Bearer/Digest）実装
- E-05: `fastapi/security/api_key.py` - APIキー認証実装
- E-06: `fastapi/middleware/__init__.py` - Middlewareエクスポート
- E-07: `fastapi/middleware/cors.py` - CORSMiddleware
- E-08: `fastapi/middleware/gzip.py` - GZipMiddleware
- E-09: `fastapi/middleware/httpsredirect.py` - HTTPSRedirectMiddleware
- E-10: `fastapi/middleware/trustedhost.py` - TrustedHostMiddleware
- E-11: `fastapi/exceptions.py` - 例外クラス定義
- E-12: `fastapi/exception_handlers.py` - 例外ハンドラ実装
- E-13: `fastapi/responses.py` - レスポンスクラス（ORJSON/UJSON含む）
- E-14: `fastapi/concurrency.py` - 並行処理ユーティリティ
- E-15: `fastapi/background.py` - BackgroundTasksクラス
- E-16: `fastapi/logger.py` - ロガー設定
- E-17: `pyproject.toml` - プロジェクト設定、依存関係
- E-18: `.github/workflows/test.yml` - CIテスト設定
- E-19: `.pre-commit-config.yaml` - コード品質フック設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Python 3.9以上で動作 | E-17 | ○ |
| C-02 | StarletteとPydanticを基盤として構築 | E-17 | ○ |
| C-03 | API応答50ms以内（同期処理） | **推定値** | △ |
| C-04 | 同時接続数10,000以上 | **理論値** | △ |
| C-05 | GZip圧縮機能あり | E-08 | ○ |
| C-06 | ORJSONResponse/UJSONResponse対応 | E-13 | ○ |
| C-07 | run_in_threadpoolによる非同期実行 | E-14 | ○ |
| C-08 | BackgroundTasksによる非同期処理 | E-15 | ○ |
| C-09 | Lifespan管理によるgraceful shutdown | E-01 | ○ |
| C-10 | HTTPExceptionによる統一例外処理 | E-11 | ○ |
| C-11 | カスタム例外ハンドラ対応 | E-12 | ○ |
| C-12 | 422バリデーションエラー | E-12 | ○ |
| C-13 | WebSocket例外対応 | E-11 | ○ |
| C-14 | OAuth2パスワードフロー対応 | E-03 | ○ |
| C-15 | OAuth2認可コードフロー対応 | E-03 | ○ |
| C-16 | HTTP Basic認証対応 | E-04 | ○ |
| C-17 | HTTP Bearer認証対応 | E-04 | ○ |
| C-18 | HTTP Digest認証（スタブ） | E-04 | ○ |
| C-19 | APIKeyQuery対応 | E-05 | ○ |
| C-20 | APIKeyHeader対応 | E-05 | ○ |
| C-21 | APIKeyCookie対応 | E-05 | ○ |
| C-22 | SecurityScopesによる認可 | E-03 | ○ |
| C-23 | HTTPSリダイレクト機能 | E-09 | ○ |
| C-24 | 信頼済みホスト制限機能 | E-10 | ○ |
| C-25 | CORS設定機能 | E-07 | ○ |
| C-26 | Pydanticバリデーション | E-17 | ○ |
| C-27 | RequestValidationError | E-11 | ○ |
| C-28 | strict mypy対応 | E-17 | ○ |
| C-29 | ruffによるコード品質チェック | E-17, E-19 | ○ |
| C-30 | pre-commitフック | E-19 | ○ |
| C-31 | pytestテストフレームワーク | E-17 | ○ |
| C-32 | カバレッジ100%目標 | E-18 | ○ |
| C-33 | マルチプラットフォームテスト | E-18 | ○ |
| C-34 | Python 3.9-3.14テスト | E-18 | ○ |
| C-35 | CodSpeedベンチマーク | E-18 | ○ |
| C-36 | OpenAPI 3.1.0スキーマ生成 | E-01 | ○ |
| C-37 | Swagger UI自動提供 | E-01 | ○ |
| C-38 | ReDoc自動提供 | E-01 | ○ |
| C-39 | 標準loggingモジュール使用 | E-16 | ○ |
| C-40 | debug=Trueでトレースバック表示 | E-01 | ○ |
| C-41 | AsyncExitStackによるリソース解放 | E-01 | ○ |
| C-42 | Pydantic v1非対応 | E-11 | ○ |
| C-43 | httpx推奨（テストクライアント） | E-17 | ○ |
| C-44 | jinja2推奨（テンプレート） | E-17 | ○ |
| C-45 | HTTPDigest認証の完全実装必要 | E-04 | △ |

## 4) 不足情報（Unknown / Missing）
- **レスポンスタイム目標値（C-03）**: コード解析からは具体的な数値目標を特定できない。これは一般的なWebフレームワークの期待値として記載した推定値である。
  - 候補：ベンチマークテスト実行 / 公式ドキュメントの性能比較 / 実環境での負荷テスト
- **同時接続数（C-04）**: anyio/trio対応から理論的に高い並行処理能力があると推測されるが、具体的な数値はインフラ依存
  - 候補：負荷テスト結果 / Uvicorn公式ベンチマーク / デプロイ環境でのテスト
- **HTTPDigest認証実装状況（C-45）**: コード内のコメントで「スタブ実装」と明記されているが、どこまで実装されているかの詳細確認が必要
  - 候補：セキュリティテストコード確認 / 公式ドキュメント確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: セキュリティ機能（認証・認可）- コードで明確に実装確認済み
- **0（低リスク）**: ミドルウェア機能 - Starletteからの再エクスポートで実装確認済み
- **1（中リスク）**: パフォーマンス目標値 - 推定値のため、実環境での検証推奨
- **1（中リスク）**: 可用性要件 - フレームワーク自体ではなくデプロイ環境に依存
- **0（低リスク）**: テスト・品質要件 - CI/CD設定で明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] レスポンスタイム目標値が妥当か確認（ベンチマークテスト推奨）
- [ ] 同時接続数の目標値が実環境に適合するか確認
- [ ] HTTPDigest認証を使用する場合、追加実装の必要性を確認
- [ ] Pydantic v2への移行が完了しているか確認
- [ ] 本番環境でのUvicorn設定（workers、timeout等）が適切か確認
- [ ] セキュリティミドルウェア（CORS、TrustedHost）の設定が要件に合致するか確認
