# Fat Free CRM

## 概要

Fat Free CRMは、Ruby on Railsで構築されたオープンソースの顧客関係管理（CRM）プラットフォームです。グループコラボレーション、キャンペーン管理、リード管理、連絡先リスト、商談トラッキングなどの機能を標準で提供し、企業の営業活動を包括的にサポートします。カスタムフィールドやタグによるデータ拡張、プラグインによる機能拡張にも対応しています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| ダッシュボード | アクティビティストリーム、タスク管理、タイムライン表示 |
| アカウント管理 | 企業・組織情報の管理、カテゴリ分類（顧客、パートナー、競合等） |
| 連絡先管理 | 個人連絡先の詳細管理、SNS連携、アカウントとの紐付け |
| リード管理 | 見込み客の登録・追跡、コンバージョン処理、ステータス管理 |
| 商談管理 | 営業案件の進捗管理、金額・確度・クローズ日の追跡 |
| キャンペーン管理 | マーケティングキャンペーンの計画・実行・効果測定 |
| タスク管理 | ToDo管理、期日設定、カテゴリ分類、完了追跡 |
| チーム管理 | ユーザー・グループ管理、権限設定、商談概要の共有 |
| カスタムフィールド | エンティティごとのフィールド拡張、フィールドグループ管理 |
| タグ機能 | 全エンティティへのタグ付け、フィルタリング |
| メール連携 | IMAPドロップボックス、メールスレッド管理、コメント返信 |
| 検索・フィルタ | 高度な検索機能（Ransack UI）、リスト保存機能 |
| バージョン管理 | 変更履歴の追跡（Paper Trail） |
| 国際化対応 | 多言語対応（18言語以上） |

## 技術スタック

### コア

- フレームワーク: Ruby on Rails 7.1 - 7.2
- 言語: Ruby 3.1以上（推奨: 3.4.5）
- データベース: PostgreSQL 8.4.8以上 / MySQL 5以上 / SQLite 3.4以上
- 認証: Devise 4.6
- 認可: CanCanCan 3.3以上
- テンプレート: Haml
- アセット: Sprockets, SassC, CoffeeScript, Uglifier
- JavaScript実行: Mini Racer

### 主要ライブラリ

- simple_form - フォーム生成
- will_paginate - ページネーション
- paper_trail - バージョン管理・変更履歴
- acts-as-taggable-on - タグ機能
- acts_as_commentable - コメント機能
- acts_as_list - 並び順管理
- ransack / ransack_ui - 高度な検索機能
- font-awesome-rails - アイコン
- Bootstrap 5.2 - UIフレームワーク
- jQuery / jQuery UI - JavaScript機能
- select2-rails - セレクトボックス拡張
- country_select - 国選択
- premailer - HTMLメール整形
- mini_magick / image_processing - 画像処理
- ffaker - テストデータ生成
- vcardigan - vCard対応

### 開発・テスト

- RSpec - テストフレームワーク
- Capybara - E2Eテスト
- Selenium WebDriver - ブラウザテスト
- Factory Bot - テストデータファクトリ
- RuboCop - Linter/Formatter
- Brakeman - セキュリティ検査
- Guard - ファイル監視
- Capistrano - デプロイツール

## ディレクトリ構成

```
fat_free_crm/
├── app/
│   ├── assets/           # JavaScript, CSS, 画像
│   ├── controllers/      # コントローラー
│   │   ├── admin/        # 管理画面コントローラー
│   │   └── entities/     # エンティティ別コントローラー
│   ├── helpers/          # ビューヘルパー
│   ├── inputs/           # カスタムフォーム入力
│   ├── mailers/          # メーラー
│   ├── models/           # モデル
│   │   ├── entities/     # Account, Contact, Lead, Opportunity, Campaign
│   │   ├── fields/       # カスタムフィールド
│   │   ├── observers/    # オブザーバー
│   │   ├── polymorphic/  # ポリモーフィック関連
│   │   └── users/        # ユーザー関連
│   └── views/            # ビューテンプレート（Haml）
├── bin/                  # 実行スクリプト
├── config/               # 設定ファイル
│   ├── environments/     # 環境別設定
│   ├── initializers/     # 初期化処理
│   └── locales/          # 多言語ファイル
├── db/
│   ├── demo/             # デモデータ
│   ├── migrate/          # マイグレーション
│   └── seeds/            # シードデータ
├── lib/
│   ├── fat_free_crm/     # コアライブラリ
│   └── tasks/            # Rakeタスク
├── public/               # 静的ファイル
├── spec/                 # テストコード
│   ├── controllers/
│   ├── factories/
│   ├── features/         # E2Eテスト
│   ├── helpers/
│   ├── models/
│   └── views/
└── vendor/               # サードパーティライブラリ
```

## セットアップ

### 必要条件

- Ruby 3.1以上（推奨: 3.4.5）
- Bundler
- PostgreSQL 8.4.8以上、MySQL 5以上、またはSQLite 3.4以上
- ImageMagick（アバター機能を使用する場合）
- Node.js（JavaScriptランタイム）

### インストール手順

#### 1. リポジトリのクローン

```bash
git clone https://github.com/fatfreecrm/fat_free_crm.git
cd fat_free_crm
```

#### 2. 依存関係のインストール

```bash
bundle install
```

#### 3. データベース設定

使用するデータベースに応じて設定ファイルをコピーします:

```bash
# PostgreSQL
cp config/database.postgres.yml config/database.yml

# MySQL
cp config/database.mysql.yml config/database.yml

# SQLite
cp config/database.sqlite.yml config/database.yml
```

#### 4. データベースの作成とマイグレーション

```bash
bundle exec rake db:create
bundle exec rake db:schema:load
```

#### 5. デモデータのロード（オプション）

```bash
bundle exec rake ffcrm:demo:load
```

#### 6. サーバーの起動

```bash
bundle exec rails server
```

ブラウザで http://localhost:3000 にアクセスします。

### Docker環境でのセットアップ

```bash
# ボリュームの作成
docker volume create pgdata
docker volume create gems

# コンテナの起動
docker-compose up

# 別ターミナルでデータベース初期化
docker-compose exec web bundle exec rake db:create db:schema:load ffcrm:demo:load

# アセットのプリコンパイル
docker-compose exec web bundle exec rails assets:precompile
```

### Herokuへのデプロイ

公式ガイドを参照: http://guides.fatfreecrm.com/Setup-Heroku

### Rails Engineとしての利用

Fat Free CRMはgemとして他のRailsアプリケーションに組み込むことも可能です。詳細は公式ガイドを参照: http://guides.fatfreecrm.com/Running-as-a-Rails-Engine

## 開発

### Linter/Formatter

```bash
# RuboCopの実行
bundle exec rubocop

# 自動修正
bundle exec rubocop -a
```

### テストの実行

```bash
# 全テストの実行
bundle exec rake

# RSpecの実行
bundle exec rspec

# 特定のテストファイルの実行
bundle exec rspec spec/models/entities/account_spec.rb

# 特定のfeatureテストの実行
bundle exec rspec spec/features/
```

### セキュリティ検査

```bash
bundle exec brakeman
```

### Guard（ファイル監視）

```bash
bundle exec guard
```

### デプロイ（Capistrano）

```bash
# config/deploy.example.rb を参考にconfig/deploy.rbを作成
bundle exec cap production deploy
```

## 設定

### 設定ファイルの優先順位

1. `config/settings.default.yml` - デフォルト設定（編集不可）
2. `config/settings.yml` - カスタム設定（git管理推奨）
3. データベースの`settings`テーブル - 管理画面から設定可能

### 主な設定項目

- `:host` - メール生成時のホスト名
- `:locale` - デフォルトロケール（例: "en-US", "ja"）
- `:user_signup` - ユーザー登録設定（:allowed, :not_allowed, :needs_approval）
- `:default_access` - レコードのデフォルト権限（Private, Public, Shared）
- `:smtp` - SMTPメール送信設定
- `:email_dropbox` - IMAPドロップボックス設定

## ライセンス

MIT License

Copyright (c) 2008-2018 Michael Dvorkin and contributors.

## 参考リンク

| リソース | URL |
| --- | --- |
| ホームページ | http://www.fatfreecrm.com |
| ガイド | http://guides.fatfreecrm.com |
| GitHub | http://github.com/fatfreecrm/fat_free_crm |
| RubyGems | https://rubygems.org/gems/fat_free_crm |
| ドキュメント | https://www.rubydoc.info/github/fatfreecrm/fat_free_crm.git/master |
| Discord | https://discord.gg/JVrzD8RYyk |
