---
generated_at: 2026-01-13 16:25:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **推奨Ruby バージョン3.4.5**：.ruby-versionから取得したが、実環境での検証推奨
  2. **デプロイ手順の詳細**：Capistrano設定例は存在するが、実際のデプロイフローは環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`（オリジナル）
- E-02: `Gemfile`
- E-03: `fat_free_crm.gemspec`
- E-04: `.ruby-version`
- E-05: `config/routes.rb`
- E-06: `config/settings.default.yml`
- E-07: `db/schema.rb`
- E-08: `Dockerfile`
- E-09: `docker-compose.yml`
- E-10: `app/controllers/` ディレクトリ構造
- E-11: `app/models/` ディレクトリ構造
- E-12: `app/views/` ディレクトリ構造
- E-13: `lib/fat_free_crm/version.rb`
- E-14: `spec/` ディレクトリ構造

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ruby on Railsで構築されたCRMプラットフォーム | E-01, E-03 | ○ |
| C-02 | グループコラボレーション機能 | E-05, E-06 | ○ |
| C-03 | キャンペーン管理機能 | E-05, E-07 | ○ |
| C-04 | リード管理機能 | E-05, E-07 | ○ |
| C-05 | 連絡先管理機能 | E-05, E-07 | ○ |
| C-06 | 商談トラッキング機能 | E-05, E-07 | ○ |
| C-07 | カスタムフィールド対応 | E-05, E-06, E-07 | ○ |
| C-08 | タグ機能 | E-02, E-03 | ○ |
| C-09 | Rails 7.1-7.2対応 | E-03 | ○ |
| C-10 | Ruby 3.1以上必須 | E-03 | ○ |
| C-11 | PostgreSQL/MySQL/SQLite対応 | E-01, E-02 | ○ |
| C-12 | Devise認証 | E-02, E-03 | ○ |
| C-13 | CanCanCan認可 | E-03 | ○ |
| C-14 | Hamlテンプレート | E-03, E-12 | ○ |
| C-15 | Bootstrap 5.2使用 | E-02 | ○ |
| C-16 | simple_form使用 | E-03 | ○ |
| C-17 | will_paginate使用 | E-03 | ○ |
| C-18 | paper_trail使用 | E-03 | ○ |
| C-19 | acts-as-taggable-on使用 | E-03 | ○ |
| C-20 | ransack/ransack_ui使用 | E-02, E-03 | ○ |
| C-21 | RSpecテストフレームワーク | E-02, E-14 | ○ |
| C-22 | Capybaraテスト | E-02, E-14 | ○ |
| C-23 | Factory Bot使用 | E-02 | ○ |
| C-24 | RuboCop使用 | E-02 | ○ |
| C-25 | Brakeman使用 | E-02 | ○ |
| C-26 | Capistrano使用 | E-02 | ○ |
| C-27 | app/controllers構造 | E-10 | ○ |
| C-28 | app/models構造 | E-11 | ○ |
| C-29 | app/views構造 | E-12 | ○ |
| C-30 | specディレクトリ構造 | E-14 | ○ |
| C-31 | ImageMagick必要（アバター用） | E-01, E-08 | ○ |
| C-32 | Docker対応 | E-08, E-09 | ○ |
| C-33 | Herokuデプロイ対応 | E-01, E-02 | ○ |
| C-34 | Rails Engine利用可能 | E-01, E-03 | ○ |
| C-35 | 設定ファイル優先順位 | E-06 | ○ |
| C-36 | バージョン0.25.0 | E-13 | ○ |
| C-37 | MITライセンス | E-01, E-03 | ○ |
| C-38 | 18言語以上対応 | E-06（config/locales参照） | ○ |
| C-39 | IMAPメール連携 | E-06 | ○ |
| C-40 | アカウントカテゴリ（affiliate, competitor等） | E-06 | ○ |
| C-41 | 推奨Rubyバージョン3.4.5 | E-04 | △ |
| C-42 | Capistranoデプロイ詳細手順 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-41（推奨Rubyバージョン）**：.ruby-versionファイルから取得したが、これは開発環境設定であり、本番環境での推奨かは別途確認が必要
  - 候補：公式ドキュメント / CI設定 / リリースノート
- **C-42（Capistranoデプロイ詳細）**：deploy.example.rbは存在するが、実際のデプロイフローはサーバー環境に依存するため詳細は記載困難
  - 候補：deploy.example.rb / 公式ガイド

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：技術スタック、主要機能の記載は全て根拠あり
- 0（低リスク）：セットアップ手順はDockerfile、docker-compose.yml、既存READMEに基づく
- 1（中リスク）：推奨Rubyバージョンは環境により異なる可能性あり
- 0（低リスク）：ライセンス情報はMIT-LICENSEファイルで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 技術スタックのバージョン情報が最新か確認（特にRails、Ruby）
- [ ] セットアップ手順が実際の開発環境で動作するか検証
- [ ] Docker環境でのセットアップ手順が正常に完了するか確認
- [ ] 各機能の説明がビジネス要件と整合しているか確認
- [ ] 参考リンクが全てアクセス可能か確認
