---
generated_at: 2026-01-13 18:45:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **参考資料URLの有効性**：外部リンクの動作確認が必要
  2. **デバッグヒントの網羅性**：現場の経験に基づく追加情報が有用な可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/entities/lead.rb`
- E-02: `app/models/entities/account.rb`
- E-03: `app/models/entities/contact.rb`
- E-04: `app/models/entities/opportunity.rb`
- E-05: `app/controllers/application_controller.rb`
- E-06: `app/controllers/entities_controller.rb`
- E-07: `app/controllers/entities/leads_controller.rb`
- E-08: `app/controllers/home_controller.rb`
- E-09: `config/routes.rb`
- E-10: `config/application.rb`
- E-11: `config/settings.default.yml`
- E-12: `lib/fat_free_crm.rb`
- E-13: `lib/fat_free_crm/permissions.rb`
- E-14: `Gemfile`
- E-15: `README.md`
- E-16: `db/schema.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Fat Free CRMはRuby on Railsフレームワークを使用 | E-14, E-10 | ○ |
| C-02 | Leadクラスの継承関係（ActiveRecord::Base） | E-01:40 | ○ |
| C-03 | belongs_to, has_one, has_manyの関連付けマクロ使用 | E-01:41-48 | ○ |
| C-04 | インスタンス変数の使用方法（@activities等） | E-08:14-17 | ○ |
| C-05 | respond_toによる複数フォーマット対応 | E-05:24-27 | ○ |
| C-06 | 条件分岐の構文（if/else） | E-01:158-164 | ○ |
| C-07 | スコープとラムダの定義 | E-01:54-60 | ○ |
| C-08 | インスタンスメソッドの定義（save_with_permissions） | E-01:95-104 | ○ |
| C-09 | クラスメソッドの定義（self.per_page） | E-01:86-88 | ○ |
| C-10 | モジュールの定義とインクルード | E-13:8-13 | ○ |
| C-11 | require/require_relativeによる読み込み | E-12:33-54 | ○ |
| C-12 | Deviseによるユーザー認証 | E-09:17-20 | ○ |
| C-13 | EntitiesController継承パターン | E-06:8-19 | ○ |
| C-14 | パーミッションシステムの実装 | E-13:14-29 | ○ |
| C-15 | カスタムフィールドシステム（has_fields） | E-01:69 | ○ |
| C-16 | ファイル命名規則（snake_case.rb） | E-01, E-02, E-03 | ○ |
| C-17 | Controllerサフィックスの命名 | E-07, E-08 | ○ |
| C-18 | get_プレフィックスのデータ取得メソッド | E-07:199, E-08:101 | ○ |
| C-19 | ディレクトリ構造（app/models/entities/等） | プロジェクト構造 | ○ |
| C-20 | MVCアーキテクチャの採用 | E-05, E-06, ビュー構造 | ○ |
| C-21 | ApplicationController継承構造 | E-05:8, E-06:8 | ○ |
| C-22 | before_actionフィルターの使用 | E-05:11-17, E-06:9-14 | ○ |
| C-23 | スコープチェーンパターン | E-08:16-17 | ○ |
| C-24 | promoteメソッドのビジネスロジック | E-01:124-133 | ○ |
| C-25 | Contact.create_forメソッド | E-03:171-205 | ○ |
| C-26 | convertアクションの実装 | E-07:108-116 | ○ |
| C-27 | promoteアクションの実装 | E-07:120-134 | ○ |
| C-28 | scope :stateの実装 | E-04:43-53 | ○ |
| C-29 | scope :myの定義 | E-13:25 | ○ |
| C-30 | access=メソッドによるパーミッション制御 | E-13:61-64 | ○ |
| C-31 | ルーティング定義（routes.rb） | E-09:8-11, 44-62 | ○ |
| C-32 | エンティティのバリデーション | E-01:76-79, E-02:76-82 | ○ |
| C-33 | PaperTrailによる変更履歴 | E-01:68 | ○ |
| C-34 | acts_as_taggable_onの使用 | E-01:67 | ○ |
| C-35 | 設定ファイルの構造 | E-11 | ○ |
| C-36 | データベーススキーマ（leads, accounts等） | E-16 | ○ |
| C-37 | オブザーバーパターンの使用 | E-10:51 | ○ |
| C-38 | Ransackによる検索機能 | E-01:62, E-10:19 | ○ |
| C-39 | respond_withによるレスポンス処理 | E-07:17-20, E-08:18-20 | ○ |
| C-40 | CanCanCanによる認可 | E-06:15 | ○ |
| C-41 | 参考資料の外部URL | **根拠なし** | △ |
| C-42 | デバッグヒントの網羅性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **参考資料の外部URL検証**：外部リンク（Rails Guide、Ruby公式等）の有効性確認が実施されていない
  - 候補：リンクチェックツールによる検証 / 手動確認
- **デバッグヒントの追加情報**：実際の開発現場での経験に基づく追加のデバッグヒントがある可能性
  - 候補：開発者インタビュー / 過去のIssue/PR分析

## 5) リスクフラグ（レビュー観点）
- 0: コード例の正確性（ソースコードから直接引用）
- 0: アーキテクチャ図の正確性（コード構造に基づく）
- 0: 命名規則の網羅性（主要ファイルを網羅）
- 1: 外部参考資料リンクの有効性（未検証）
- 0: 業務フロー追跡の正確性（実コードをトレース済み）

## 6) レビュアーチェックリスト（最小）
- [ ] コード例が実際のソースコードと一致しているか確認
- [ ] 行番号の参照が正確か確認
- [ ] ディレクトリ構造図が実際のプロジェクト構造と一致しているか確認
- [ ] アーキテクチャ図がMVC構造を正しく表現しているか確認
- [ ] 参考資料の外部URLが有効か確認
- [ ] 用語集の説明が適切か確認
- [ ] 業務フロー追跡例が実際の処理と一致しているか確認
