---
generated_at: 2026-01-13 18:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **バックアップ頻度・保持期間**：運用要件に依存し、コードからは特定不可
  2. **本番環境推奨構成（冗長化）**：コードに直接記載なし、ベストプラクティスに基づく
  3. **監視ツール選定**：コードに直接記載なし、推奨構成として記載

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docker-compose.yml`
- E-02: `Dockerfile`
- E-03: `config/database.postgres.docker.yml`
- E-04: `config/database.postgres.yml`
- E-05: `config/database.mysql.yml`
- E-06: `config/database.sqlite.yml`
- E-07: `config/cable.yml`
- E-08: `config/storage.yml`
- E-09: `config/puma.rb`
- E-10: `config/settings.default.yml`
- E-11: `config/environments/production.rb`
- E-12: `config/application.rb`
- E-13: `config/deploy.example.rb`
- E-14: `Capfile`
- E-15: `Gemfile`
- E-16: `fat_free_crm.gemspec`
- E-17: `.github/workflows/ruby.yml`
- E-18: `lib/fat_free_crm/version.rb`
- E-19: `.teatro.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アプリケーションはRuby 3.3で動作 | E-02 (FROM ruby:3.3) | ○ |
| C-02 | PostgreSQL 15をDBとして使用 | E-01 (image: postgres:15) | ○ |
| C-03 | Docker Composeでweb/dbの2サービス構成 | E-01 | ○ |
| C-04 | Pumaが2ワーカー、5スレッドで動作 | E-09 (WEB_CONCURRENCY, RAILS_MAX_THREADS) | ○ |
| C-05 | ポート3000と80を外部公開 | E-01 (ports: 3000:3000, 80:80) | ○ |
| C-06 | pgdata/gemsボリュームを使用 | E-01 (volumes: pgdata, gems) | ○ |
| C-07 | MySQL/SQLiteも選択可能 | E-05, E-06, E-15 | ○ |
| C-08 | Action CableはRedisを使用（本番） | E-07 (adapter: redis) | ○ |
| C-09 | Active StorageでS3/GCS/Azure対応可能 | E-08 (コメントで記載) | ○ |
| C-10 | ImageMagickを画像処理に使用 | E-02 (apt-get install imagemagick) | ○ |
| C-11 | Rails 7.1〜7.2をサポート | E-16 (rails >= 7.1.0, < 7.3.0) | ○ |
| C-12 | Ruby 3.1以上が必須 | E-16 (required_ruby_version >= 3.1) | ○ |
| C-13 | SMTP/IMAPでメール送受信対応 | E-10 (smtp, email_dropbox設定) | ○ |
| C-14 | DBサービスはrestart: always設定 | E-01 | ○ |
| C-15 | Capistrano 3.2.1でデプロイ対応 | E-13, E-14 | ○ |
| C-16 | database.yml/settings.ymlをリンクファイルとして管理 | E-13 | ○ |
| C-17 | GitHub ActionsでCI実行 | E-17 | ○ |
| C-18 | Herokuサポート（rails_12factor gem） | E-15 (group :heroku) | ○ |
| C-19 | バージョン0.25.0 | E-18 | ○ |
| C-20 | preload_app!設定（本番） | E-09 | ○ |
| C-21 | force_ssl設定はコメントアウト（推奨として記載） | E-11 | ○ |
| C-22 | Teatroサポート | E-19 | ○ |
| C-23 | バックアップ頻度は日次、保持期間7日 | **根拠なし** | △ |
| C-24 | 本番環境でのロードバランサー推奨 | **根拠なし** | △ |
| C-25 | Prometheus/Grafana/ELK Stack推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **バックアップ設計詳細**：コードベースにバックアップスクリプトやスケジュール設定がないため、頻度・保持期間は推奨値として記載
  - 候補：Kubernetes CronJob / AWS Backup / 独自スクリプト
- **本番環境冗長構成**：docker-compose.ymlは単一インスタンス構成のため、冗長化設計はベストプラクティスに基づく
  - 候補：Kubernetes / Docker Swarm / AWS ECS
- **監視ツール選定**：コードベースに監視設定がないため、一般的な推奨ツールを記載
  - 候補：Prometheus / Datadog / New Relic / CloudWatch

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - バックアップ設計は運用要件に応じた調整が必要
- **1: 中リスク** - 本番環境構成は実際のインフラ要件に応じた設計が必要
- **0: 低リスク** - Docker Compose構成は明確に定義されている
- **0: 低リスク** - データベース設定は複数オプションが用意されている

## 6) レビュアーチェックリスト（最小）
- [ ] docker-compose.ymlの設定が本番環境要件に適合しているか確認
- [ ] PostgreSQLのパスワード設定（現在空）を本番環境では必ず設定する
- [ ] Redis URLの設定が本番環境に適切か確認
- [ ] バックアップ頻度・保持期間を運用要件に基づいて決定する
- [ ] 本番環境での冗長構成・スケーリング要件を確認する
- [ ] SSL/TLS設定（force_ssl）を本番環境で有効化する
- [ ] 監視・アラート要件を定義し、適切なツールを選定する
- [ ] Active Storageのストレージバックエンドを本番環境に応じて選択する
