# インフラ構成図

## 1. Docker Compose構成図（開発・検証環境）

```mermaid
graph TB
    subgraph "外部"
        User[ユーザー]
    end

    subgraph "Docker Host"
        subgraph "Docker Network"
            subgraph "web Container"
                Rails[Rails App<br/>Ruby 3.3]
                Puma[Puma Server<br/>2 workers x 5 threads]
            end

            subgraph "db Container"
                PostgreSQL[PostgreSQL 15]
            end
        end

        subgraph "Docker Volumes"
            pgdata[(pgdata<br/>DB Data)]
            gems[(gems<br/>Ruby Gems)]
            storage[(storage<br/>Active Storage)]
        end
    end

    User -->|HTTP:80/3000| Puma
    Puma --> Rails
    Rails -->|TCP:5432| PostgreSQL
    PostgreSQL --> pgdata
    Rails --> gems
    Rails --> storage
```

## 2. 本番環境推奨構成図

```mermaid
graph TB
    subgraph "Internet"
        Users[ユーザー]
    end

    subgraph "Load Balancer / Reverse Proxy"
        LB[nginx / ALB<br/>SSL Termination]
    end

    subgraph "Application Layer"
        Web1[Web Server 1<br/>Rails + Puma]
        Web2[Web Server 2<br/>Rails + Puma]
        WebN[Web Server N<br/>Rails + Puma]
    end

    subgraph "Cache / Message Layer"
        Redis[Redis<br/>Action Cable]
    end

    subgraph "Database Layer"
        DB_Primary[(PostgreSQL<br/>Primary)]
        DB_Replica[(PostgreSQL<br/>Replica)]
    end

    subgraph "Storage Layer"
        S3[AWS S3 / GCS<br/>File Storage]
    end

    Users -->|HTTPS:443| LB
    LB --> Web1
    LB --> Web2
    LB --> WebN

    Web1 --> Redis
    Web2 --> Redis
    WebN --> Redis

    Web1 -->|Read/Write| DB_Primary
    Web2 -->|Read/Write| DB_Primary
    WebN -->|Read/Write| DB_Primary

    DB_Primary -->|Replication| DB_Replica

    Web1 --> S3
    Web2 --> S3
    WebN --> S3
```

## 3. アプリケーション層構成図

```mermaid
graph LR
    subgraph "Web Container"
        subgraph "Puma Application Server"
            Master[Master Process]
            Worker1[Worker 1]
            Worker2[Worker 2]

            subgraph "Worker 1 Threads"
                T1_1[Thread 1]
                T1_2[Thread 2]
                T1_3[Thread 3]
                T1_4[Thread 4]
                T1_5[Thread 5]
            end

            subgraph "Worker 2 Threads"
                T2_1[Thread 1]
                T2_2[Thread 2]
                T2_3[Thread 3]
                T2_4[Thread 4]
                T2_5[Thread 5]
            end
        end

        subgraph "Rails Application"
            ActionController[Action Controller]
            ActionView[Action View]
            ActiveRecord[Active Record]
            ActiveStorage[Active Storage]
            ActionMailer[Action Mailer]
            ActionCable[Action Cable]
        end
    end

    Master --> Worker1
    Master --> Worker2
    Worker1 --> T1_1
    Worker1 --> T1_2
    Worker1 --> T1_3
    Worker1 --> T1_4
    Worker1 --> T1_5
    Worker2 --> T2_1
    Worker2 --> T2_2
    Worker2 --> T2_3
    Worker2 --> T2_4
    Worker2 --> T2_5
```

## 4. データフロー図

```mermaid
sequenceDiagram
    participant User as ユーザー
    participant LB as Load Balancer
    participant Puma as Puma Server
    participant Rails as Rails App
    participant Redis as Redis
    participant DB as PostgreSQL
    participant Storage as File Storage

    User->>LB: HTTPS Request
    LB->>Puma: HTTP Request
    Puma->>Rails: Process Request

    alt Database Query
        Rails->>DB: SQL Query
        DB-->>Rails: Query Result
    end

    alt File Upload/Download
        Rails->>Storage: Store/Retrieve File
        Storage-->>Rails: File Data
    end

    alt WebSocket (Action Cable)
        Rails->>Redis: Publish Message
        Redis-->>Rails: Subscribe
    end

    Rails-->>Puma: Response
    Puma-->>LB: HTTP Response
    LB-->>User: HTTPS Response
```

## 5. デプロイメントパイプライン図

```mermaid
flowchart LR
    subgraph "開発"
        Dev[開発者]
        Git[Git Repository]
    end

    subgraph "CI/CD"
        GHA[GitHub Actions]
        Test[テスト実行]
    end

    subgraph "デプロイ"
        subgraph "Option 1: Docker"
            DockerBuild[Docker Build]
            DockerPush[Docker Push]
            DockerDeploy[Container Deploy]
        end

        subgraph "Option 2: Capistrano"
            CapDeploy[Capistrano Deploy]
            BundleInstall[Bundle Install]
            AssetCompile[Asset Compile]
            DBMigrate[DB Migrate]
            Restart[App Restart]
        end

        subgraph "Option 3: Heroku"
            HerokuPush[Git Push Heroku]
            HerokuBuild[Buildpack]
            HerokuRelease[Release]
        end
    end

    subgraph "本番環境"
        Prod[Production Server]
    end

    Dev -->|push| Git
    Git -->|trigger| GHA
    GHA --> Test

    Test -->|success| DockerBuild
    Test -->|success| CapDeploy
    Test -->|success| HerokuPush

    DockerBuild --> DockerPush
    DockerPush --> DockerDeploy

    CapDeploy --> BundleInstall
    BundleInstall --> AssetCompile
    AssetCompile --> DBMigrate
    DBMigrate --> Restart

    HerokuPush --> HerokuBuild
    HerokuBuild --> HerokuRelease

    DockerDeploy --> Prod
    Restart --> Prod
    HerokuRelease --> Prod
```

## 6. ネットワーク構成図（Docker Compose）

```mermaid
graph TB
    subgraph "External Network"
        Client[Client Browser]
    end

    subgraph "Docker Bridge Network: default"
        subgraph "web:3000,80"
            WebApp[Rails Application]
        end

        subgraph "db:5432"
            Database[PostgreSQL 15]
        end
    end

    Client -->|Port 80, 3000| WebApp
    WebApp -->|Internal: db:5432| Database

    style WebApp fill:#f9f,stroke:#333
    style Database fill:#bbf,stroke:#333
```

## 7. ストレージ構成図

```mermaid
graph TB
    subgraph "Application"
        Rails[Rails App]
        ActiveStorage[Active Storage]
    end

    subgraph "Storage Options"
        subgraph "Local Storage"
            Disk[Local Disk<br/>storage/]
            TmpStorage[Temp Storage<br/>tmp/storage/]
        end

        subgraph "Cloud Storage (Optional)"
            S3[AWS S3]
            GCS[Google Cloud Storage]
            Azure[Azure Blob Storage]
        end
    end

    subgraph "Database Storage"
        pgdata[(pgdata volume<br/>PostgreSQL Data)]
    end

    Rails --> ActiveStorage
    ActiveStorage -->|Default| Disk
    ActiveStorage -->|Test| TmpStorage
    ActiveStorage -.->|Optional| S3
    ActiveStorage -.->|Optional| GCS
    ActiveStorage -.->|Optional| Azure

    Rails -->|ORM| pgdata
```

## 8. 監視構成図（推奨）

```mermaid
graph TB
    subgraph "Application Layer"
        Web[Web Servers]
        DB[PostgreSQL]
        Redis[Redis]
    end

    subgraph "Monitoring Stack"
        Prometheus[Prometheus<br/>Metrics Collection]
        Grafana[Grafana<br/>Visualization]
        AlertManager[Alert Manager<br/>Alerting]
    end

    subgraph "Logging Stack"
        Filebeat[Filebeat<br/>Log Shipper]
        Elasticsearch[Elasticsearch<br/>Log Storage]
        Kibana[Kibana<br/>Log Analysis]
    end

    subgraph "APM (Optional)"
        NewRelic[New Relic / Datadog]
    end

    Web -->|metrics| Prometheus
    DB -->|metrics| Prometheus
    Redis -->|metrics| Prometheus

    Prometheus --> Grafana
    Prometheus --> AlertManager

    Web -->|logs| Filebeat
    DB -->|logs| Filebeat
    Filebeat --> Elasticsearch
    Elasticsearch --> Kibana

    Web -.->|traces| NewRelic
```
