# インフラ設計書

## 概要

本ドキュメントは、Fat Free CRM（Ruby on Rails製CRMアプリケーション、バージョン0.25.0）のインフラストラクチャ設計を記載したものです。Docker/Docker Composeを用いたコンテナベースのデプロイメント構成を中心に、サーバー構成、ネットワーク、ストレージ、外部サービス連携、スケーリング設計について説明します。

## システム構成

### 全体構成

Fat Free CRMは以下の構成要素で成り立つWebアプリケーションシステムです：

1. **Webアプリケーションサーバー**：Ruby on Rails 7.1〜7.2 + Puma（または本番環境でPassenger）
2. **データベースサーバー**：PostgreSQL 15（MySQL、SQLiteも選択可能）
3. **Redisサーバー**：Action Cable用WebSocket通信基盤（本番環境）
4. **ファイルストレージ**：Active Storage（ローカルディスク / クラウドストレージ）

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| Webサーバー（コンテナ） | Railsアプリケーション実行、HTTPリクエスト処理 | Ruby 3.3、Puma（2ワーカー、5スレッド） | 1以上（スケール可能） |
| DBサーバー（コンテナ） | データ永続化、PostgreSQL 15 | PostgreSQL 15公式イメージ | 1 |
| Redisサーバー | Action Cable用メッセージブローカー（本番） | Redis公式イメージ | 本番環境で1 |

### ネットワーク構成

**Docker Compose構成：**

- **webサービス**：ポート3000（Rails）、ポート80（HTTP）を外部公開
- **dbサービス**：ポート5432、内部ネットワークのみ（webサービスからのみアクセス可能）
- **サービス間通信**：Docker Composeの内部ネットワークを使用（`db`ホスト名で名前解決）

**本番環境推奨構成：**

- リバースプロキシ（nginx/Apache）を前段に配置
- SSL/TLSターミネーション
- ファイアウォールによるアクセス制御

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Ruby | 3.3 | アプリケーション実行環境 |
| Ruby on Rails | 7.1〜7.2 | Webアプリケーションフレームワーク |
| Puma | 最新（Gemfile管理） | アプリケーションサーバー |
| PostgreSQL | 15 | リレーショナルデータベース |
| Redis | 最新 | Action Cable用メッセージブローカー（本番） |
| ImageMagick | システム標準 | 画像処理（Active Storage） |
| Bundler | 最新 | Gem依存関係管理 |

**対応データベース：**

| データベース | 用途 | 設定ファイル |
| --- | --- | --- |
| PostgreSQL | 推奨（Docker環境デフォルト） | config/database.postgres.docker.yml |
| MySQL | 代替オプション | config/database.mysql.yml |
| SQLite | 開発・テスト用 | config/database.sqlite.yml |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| SMTP（メールサーバー） | 送信メール配信 | SMTP（設定可能） |
| IMAP（メールサーバー） | Email Dropbox/コメント返信受信 | IMAP |
| AWS S3 | ファイルストレージ（オプション） | S3 API |
| Google Cloud Storage | ファイルストレージ（オプション） | GCS API |
| Azure Blob Storage | ファイルストレージ（オプション） | Azure Storage API |

**メール設定：**

- SMTP設定：`config/settings.yml`で設定
- IMAP設定：Email Dropbox機能、コメント返信機能用

## スケーリング設計

### 水平スケーリング（Webサーバー）

- **Puma設定**：
  - ワーカー数：`WEB_CONCURRENCY`環境変数（デフォルト2）
  - スレッド数：`RAILS_MAX_THREADS`環境変数（デフォルト5）
- **スケールアウト**：
  - Docker Compose: `docker-compose up --scale web=N`
  - ロードバランサー追加が必要

### 垂直スケーリング

- コンテナリソース制限（CPU、メモリ）をdocker-compose.ymlで設定可能
- データベースサーバーのリソース増強

### データベーススケーリング

- コネクションプール：`pool`設定（デフォルト5）
- PostgreSQLレプリケーション（読み取りスケーリング）- 別途設定要

## 可用性設計

### コンテナ再起動設定

- **DBサービス**：`restart: always`設定済み
- **Webサービス**：手動再起動（本番環境では追加設定推奨）

### 推奨冗長構成

1. **Webサーバー冗長化**：
   - 複数コンテナ + ロードバランサー
   - ヘルスチェックエンドポイント設定

2. **データベース冗長化**：
   - PostgreSQLストリーミングレプリケーション
   - プライマリ-スタンバイ構成

3. **フェイルオーバー方式**：
   - ロードバランサーによる自動切り替え
   - データベースは手動または自動フェイルオーバー

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| PostgreSQLデータ | pg_dump / WALアーカイブ | 日次（推奨） | 7日以上（要件に応じて） |
| アップロードファイル | ストレージスナップショット / rsync | 日次（推奨） | 7日以上（要件に応じて） |
| 設定ファイル | Gitリポジトリ管理 | コミット毎 | 無期限 |
| Docker Volume（pgdata） | Volume backup | 日次（推奨） | 7日以上 |
| Docker Volume（gems） | Volume backup | 必要時 | 任意 |

**バックアップ対象ボリューム：**

- `pgdata`：PostgreSQLデータ
- `gems`：RubyGems（再構築可能）
- `storage`：Active Storageファイル

## 監視設計

### 推奨監視項目

1. **アプリケーション監視**：
   - HTTPレスポンスコード
   - レスポンスタイム
   - エラーレート

2. **インフラ監視**：
   - CPU使用率
   - メモリ使用率
   - ディスク使用率
   - ネットワークI/O

3. **データベース監視**：
   - コネクション数
   - クエリパフォーマンス
   - レプリケーションラグ（該当時）

4. **ログ監視**：
   - Railsアプリケーションログ（log/production.log）
   - PostgreSQLログ
   - nginx/Apacheアクセスログ

### 推奨監視ツール

- Prometheus + Grafana
- New Relic / Datadog（APM）
- ELK Stack（ログ集約）
- PgHero（PostgreSQL監視）

## デプロイメント

### Docker Composeデプロイ

```bash
# ボリューム作成
docker volume create pgdata
docker volume create gems

# コンテナ起動
docker-compose up -d

# 初期セットアップ
docker-compose exec web bundle exec rake db:create db:schema:load
docker-compose exec web bundle exec rails assets:precompile

# デモデータ投入（オプション）
docker-compose exec web bundle exec rake ffcrm:demo:load
```

### Capistranoデプロイ（サーバーデプロイ）

- Capistrano 3.2.1を使用
- RVM環境サポート
- リンクファイル：`config/database.yml`、`config/settings.yml`
- デプロイフロー：Bundler → アセットプリコンパイル → DBマイグレーション

### CI/CD（GitHub Actions）

- テスト実行環境：Ubuntu Latest
- Ruby バージョン：3.4
- テストDB：SQLite
- 実行テスト：モデル、コントローラー、ビュー、ヘルパー、ルーティング、メーラー、フィーチャー

## 環境変数

| 変数名 | 用途 | デフォルト値 |
| --- | --- | --- |
| RAILS_ENV | Rails実行環境 | production |
| PASSENGER_APP_ENV | Passenger環境（該当時） | production |
| DB_DATABASE | データベース名 | fat_free_crm_production |
| DB_USERNAME | DBユーザー名 | postgres |
| DB_PASSWORD | DBパスワード | （空） |
| DB_HOST | DBホスト | db |
| DB_PORT | DBポート | 5432 |
| REDIS_URL | Redis接続URL | redis://localhost:6379/1 |
| WEB_CONCURRENCY | Pumaワーカー数 | 2 |
| RAILS_MAX_THREADS | Pumaスレッド数 | 5 |
| PORT | アプリケーションポート | 3000 |

## 備考

### Herokuサポート

- `rails_12factor` gem によるHeroku対応
- Pumaアプリケーションサーバー使用
- 環境変数によるデータベース接続設定

### Teatro対応

- `.teatro.yml`による自動デモデータ投入設定

### セキュリティ考慮事項

1. **本番環境でのSSL/TLS有効化推奨**（`config.force_ssl = true`）
2. **機密情報はRails Credentialsで管理**
3. **DB接続パスワードの設定必須**
4. **ファイアウォールによるDB直接アクセス禁止**
