---
generated_at: 2026-01-13 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **セッション有効期限設定**：Deviseデフォルト設定の確認が必要
  2. **本番環境でのforce_ssl設定**：実際の本番デプロイ設定の確認が必要
  3. **監査ログ保持期間**：データ保持ポリシーの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/users/user.rb` - Userモデル、Devise設定
- E-02: `config/initializers/devise.rb` - Devise初期化設定
- E-03: `app/models/users/ability.rb` - CanCanCan権限定義
- E-04: `app/controllers/application_controller.rb` - 基底コントローラー
- E-05: `app/controllers/admin/application_controller.rb` - 管理者コントローラー
- E-06: `app/models/users/permission.rb` - 権限モデル
- E-07: `lib/fat_free_crm/permissions.rb` - 権限モジュール
- E-08: `app/models/polymorphic/version.rb` - バージョン（監査）モデル
- E-09: `config/application.rb` - アプリケーション設定
- E-10: `config/environments/production.rb` - 本番環境設定
- E-11: `app/controllers/entities_controller.rb` - エンティティコントローラー
- E-12: `app/controllers/users_controller.rb` - ユーザーコントローラー
- E-13: `app/controllers/admin/users_controller.rb` - 管理者ユーザーコントローラー
- E-14: `app/models/entities/account.rb` - アカウントモデル
- E-15: `app/models/entities/contact.rb` - コンタクトモデル
- E-16: `app/models/entities/lead.rb` - リードモデル
- E-17: `Gemfile` - 依存関係定義
- E-18: `app/helpers/application_helper.rb` - アプリケーションヘルパー
- E-19: `app/models/users/group.rb` - グループモデル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 認証フレームワークがDevise 4.6+である | E-17 (Gemfile: gem 'devise', '~>4.6') | ○ |
| C-02 | パスワードハッシュがauthlogic_sha512である | E-02 (devise.rb: config.encryptor = :authlogic_sha512) | ○ |
| C-03 | ハッシュストレッチ回数が本番20回、テスト1回 | E-02 (devise.rb: config.stretches = Rails.env.test? ? 1 : 20) | ○ |
| C-04 | パスワード長が8〜128文字 | E-02 (devise.rb: config.password_length = 8..128) | ○ |
| C-05 | database_authenticatableモジュールを使用 | E-01 (user.rb: devise :database_authenticatable, ...) | ○ |
| C-06 | registerable, confirmable等のモジュールを使用 | E-01 (user.rb: devise ..., :registerable, :confirmable, ...) | ○ |
| C-07 | セッション有効期限がDeviseデフォルト（2週間） | **根拠なし** - devise.rbにremember_for設定なし | △ |
| C-08 | ログアウト時に記憶トークンが無効化される | E-02 (devise.rb: config.expire_all_remember_me_on_sign_out = true) | ○ |
| C-09 | パスワードリセットトークン有効期限が6時間 | E-02 (devise.rb: config.reset_password_within = 6.hours) | ○ |
| C-10 | メール確認の再確認が有効 | E-02 (devise.rb: config.reconfirmable = true) | ○ |
| C-11 | 管理者がadmin属性で判定される | E-01, E-03, E-05 | ○ |
| C-12 | CanCanCan（Ability）で認可制御を実装 | E-03 (ability.rb: include CanCan::Ability) | ○ |
| C-13 | Publicアクセスのエンティティは全ユーザーがアクセス可能 | E-03 (ability.rb: can :manage, entities, access: 'Public') | ○ |
| C-14 | user_idが一致するエンティティにフルアクセス | E-03 (ability.rb: can :manage, entities + [Task], user_id: user.id) | ○ |
| C-15 | assigned_toが一致するエンティティにフルアクセス | E-03 (ability.rb: can :manage, entities + [Task], assigned_to: user.id) | ○ |
| C-16 | 管理者機能にrequire_admin_userを使用 | E-05 (admin/application_controller.rb: before_action :require_admin_user) | ○ |
| C-17 | Permissionモデルでuser_idとgroup_idによる共有管理 | E-06, E-07 | ○ |
| C-18 | CORSで全オリジンを許可している | E-04 (application_controller.rb: headers['Access-Control-Allow-Origin'] = '*') | ○ |
| C-19 | force_sslが本番環境でコメントアウトされている | E-10 (production.rb: # config.force_ssl = true) | ○ |
| C-20 | パラメータフィルタリングでpassword等がマスクされる | E-09 (application.rb: config.filter_parameters += %i[password ...]) | ○ |
| C-21 | CSRF対策でprotect_from_forgery with: :exceptionを使用 | E-04 (application_controller.rb: protect_from_forgery with: :exception) | ○ |
| C-22 | Strong Parametersでpermitを使用 | E-12, E-13 (user_params: params[:user].permit(...)) | ○ |
| C-23 | EntitiesControllerでpermit!を使用している | E-11 (entities_controller.rb: params[...].permit!) | ○ |
| C-24 | メールアドレスに形式検証がある | E-01 (user.rb: validates :email, format: { with: /.../ }) | ○ |
| C-25 | ユーザー名に形式検証がある | E-01 (user.rb: validates :username, format: { with: /\A[a-z0-9_-]+\z/i }) | ○ |
| C-26 | 各フィールドに長さ制限がある | E-14, E-15, E-16 (validates_length_of) | ○ |
| C-27 | PaperTrailで監査ログを記録している | E-08, E-01, E-14, E-15, E-16 (has_paper_trail) | ○ |
| C-28 | Devise Trackableでログイン履歴を追跡 | E-01 (user.rb: devise ..., :trackable) | ○ |
| C-29 | ログイン回数・日時・IPアドレスを記録 | E-01 (スキーマコメント: sign_in_count, last_sign_in_at, last_sign_in_ip等) | ○ |
| C-30 | brakemanがGemfileに含まれている | E-17 (Gemfile: gem 'brakeman', require: false) | ○ |
| C-31 | ERB::Utilによる出力エスケープを実装 | E-04 (application_controller.rb: include ERB::Util) | ○ |
| C-32 | sanitizeヘルパーを使用している | E-18 (application_helper.rb: sanitize text, sanitized_number) | ○ |
| C-33 | 本番環境でforce_sslが有効化推奨である | **根拠なし** - 推奨事項であり、コードからは未設定を確認のみ | △ |
| C-34 | 監査ログの保持期間が無期限である | **根拠なし** - データベース設定/運用ポリシーの確認が必要 | △ |
| C-35 | set_paper_trail_whodunnitで実行者を追跡 | E-04 (application_controller.rb: before_action :set_paper_trail_whodunnit) | ○ |

## 4) 不足情報（Unknown / Missing）
- **セッション有効期限の明示設定**: devise.rbにremember_for設定がなく、Deviseデフォルト値の適用を前提としている
  - 候補: config/initializers/devise.rbへの明示設定 / 運用ドキュメント
- **本番環境の実際の設定**: force_sslがコメントアウトされているが、リバースプロキシでの設定可能性あり
  - 候補: デプロイメント設定 / インフラ設計書 / nginx/Apache設定
- **監査ログ保持ポリシー**: PaperTrailのデータ削除ポリシーが未定義
  - 候補: 運用マニュアル / データ保持ポリシー / DBメンテナンススクリプト

## 5) リスクフラグ（レビュー観点）
- **2 (高リスク)**: EntitiesControllerでpermit!使用（C-23）- マスアサインメント脆弱性の可能性
- **1 (中リスク)**: CORS全オリジン許可（C-18）- 本番環境でのCORS設定見直し推奨
- **1 (中リスク)**: force_ssl未設定（C-19, C-33）- HTTPSの強制が未設定
- **0 (低リスク)**: セッション有効期限（C-07）- Deviseデフォルト適用のため大きな問題なし

## 6) レビュアーチェックリスト（最小）
- [ ] EntitiesControllerのpermit!使用箇所の妥当性確認（セキュリティ上最重要）
- [ ] 本番環境でのHTTPS/HSTS設定の確認（インフラレベル）
- [ ] CORS設定の本番環境での適切性確認
- [ ] Devise設定のセッション管理パラメータの妥当性確認
- [ ] PaperTrailログの保持・削除ポリシーの確認
- [ ] brakemanによるセキュリティスキャン結果の確認
