---
generated_at: 2026-01-13 16:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **カバレッジ目標値**: 明示的な設定ファイルが見つからないため推奨値として記載
  2. **テストファイル数**: 概算値であり正確な数値は変動する可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `spec/spec_helper.rb` - RSpec設定ファイル
- E-02: `Gemfile` - 依存関係定義ファイル
- E-03: `.github/workflows/ruby.yml` - RSpecテストCI設定
- E-04: `.github/workflows/brakeman-analysis.yml` - セキュリティスキャンCI設定
- E-05: `.github/workflows/rubocop-analysis.yml` - 静的解析CI設定
- E-06: `spec/factories/user_factories.rb` - FactoryBot定義例
- E-07: `spec/models/entities/account_spec.rb` - モデルテスト例
- E-08: `spec/controllers/entities/accounts_controller_spec.rb` - コントローラテスト例
- E-09: `spec/features/accounts_spec.rb` - Feature（E2E）テスト例
- E-10: `spec/features/acceptance_helper.rb` - Featureテストヘルパー
- E-11: `spec/support/` - テストサポートモジュール群
- E-12: `spec/shared/` - 共有スペックモジュール群
- E-13: `spec/fixtures/files/` - テストフィクスチャディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RSpecをテストフレームワークとして使用 | E-01, E-02 | ○ |
| C-02 | FactoryBot (~> 6.0) をテストデータ生成に使用 | E-02, E-06 | ○ |
| C-03 | Capybaraをブラウザテストに使用 | E-01, E-02 | ○ |
| C-04 | Selenium WebDriverを使用 | E-01, E-02 | ○ |
| C-05 | DatabaseCleanerを使用（transaction/truncation戦略） | E-01, E-02 | ○ |
| C-06 | Timecopを時間モックに使用 | E-01, E-02 | ○ |
| C-07 | FFakerをダミーデータ生成に使用 | E-01, E-02, E-06 | ○ |
| C-08 | GitHub ActionsでRSpecテストを実行 | E-03 | ○ |
| C-09 | CI環境でRuby 3.4 + SQLite3を使用 | E-03 | ○ |
| C-10 | BrakemanによるセキュリティスキャンをCIで実行 | E-04 | ○ |
| C-11 | Brakemanバージョン6.0.1を使用 | E-04 | ○ |
| C-12 | Rubocopによる静的解析をCIで実行 | E-05 | ○ |
| C-13 | 複数のRubocop拡張を使用（rails, rspec, capybara, factory_bot, rspec_rails） | E-02 | ○ |
| C-14 | モデルテストが存在（spec/models/） | E-07 | ○ |
| C-15 | コントローラテストが存在（spec/controllers/） | E-08 | ○ |
| C-16 | Feature（E2E）テストが存在（spec/features/） | E-09 | ○ |
| C-17 | Deviseテストヘルパーを使用 | E-01 | ○ |
| C-18 | Wardenテストヘルパーを使用 | E-01 | ○ |
| C-19 | Paper Trail RSpecを使用 | E-01 | ○ |
| C-20 | Capybara Screenshotを使用 | E-01, E-02 | ○ |
| C-21 | テスト時のロケールはen-USに固定 | E-01 | ○ |
| C-22 | JSテストではtruncation戦略を使用 | E-01 | ○ |
| C-23 | 約190のテストファイルが存在 | ファイル数カウント結果 | ○ |
| C-24 | spec/factories/にファクトリ定義が存在 | E-06, E-11 | ○ |
| C-25 | テスト実行コマンド（rake spec:*） | E-03 | ○ |
| C-26 | Brakemanは週次定期実行される | E-04 | ○ |
| C-27 | カバレッジ目標値（80%以上推奨） | **根拠なし** | △ |
| C-28 | SimpleCovの明示的設定がない | **根拠なし（設定ファイル未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標・計測設定**: プロジェクトにSimpleCovや類似のカバレッジツールの設定ファイルが確認できなかったため、カバレッジ目標値は推奨値として記載した
  - 候補確認先: `.simplecov` / `spec/spec_helper.rb`内のSimpleCov設定 / `Gemfile`内のsimplecov gem

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: テストフレームワーク・ツールの記載 - 実際のGemfileとspec_helper.rbから直接確認
- **0 (低リスク)**: CI/CD設定の記載 - GitHub Actionsワークフローファイルから直接確認
- **1 (中リスク)**: カバレッジ目標値 - 明示的な設定がないため推奨値として記載。チームの方針確認が必要
- **0 (低リスク)**: テストディレクトリ構造 - 実際のディレクトリ構造から確認

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標値がチームの方針と一致しているか確認
- [ ] SimpleCovまたは他のカバレッジツールの導入状況を確認
- [ ] CI/CDワークフローの実行結果が最新の設定と一致しているか確認
- [ ] テストツールのバージョンがGemfile.lockと一致しているか確認
- [ ] 記載されたテストコマンドが実際に動作するか確認
