# テスト方針書

## 概要

本ドキュメントは、Fat Free CRM（Ruby on Rails製のオープンソースCRMシステム）のテスト戦略および方針を定義するものである。本プロジェクトでは、RSpecを中心としたテストフレームワークを採用し、モデル、コントローラ、ビュー、ヘルパー、ルーティング、メーラー、ライブラリ、およびE2E（Feature）テストの各レベルで品質を担保している。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト（Models） | モデル層のビジネスロジック、バリデーション、アソシエーション、スコープの検証 | 開発者 |
| 結合テスト（Controllers） | コントローラの動作、リクエスト/レスポンス処理、認証・認可の検証 | 開発者 |
| ビューテスト（Views） | テンプレートのレンダリング、表示内容の検証 | 開発者 |
| ヘルパーテスト（Helpers） | ビューヘルパーメソッドの動作検証 | 開発者 |
| ルーティングテスト（Routing） | URLルーティングの正確性の検証 | 開発者 |
| メーラーテスト（Mailers） | メール送信機能の検証 | 開発者 |
| ライブラリテスト（Lib） | カスタムライブラリ・拡張機能の検証 | 開発者 |
| E2Eテスト（Features） | ユーザー視点でのエンドツーエンドの機能検証 | 開発者/QA |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | CRMの各機能（アカウント、コンタクト、リード、オポチュニティ、キャンペーン、タスク等）の動作検証 | 開発中・PR作成時 |
| 回帰テスト | 既存機能への影響がないことの確認 | PR作成時・マージ前 |
| セキュリティテスト | Brakemanによる静的セキュリティ解析 | PR作成時・定期スキャン（週次） |
| コード品質テスト | Rubocopによる静的コード解析 | PR作成時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者によるテスト実行 | SQLite3 / PostgreSQL / MySQL対応 |
| CI環境（GitHub Actions） | 自動テスト実行 | Ubuntu Latest + Ruby 3.4 + SQLite3 |
| ヘッドレスブラウザ環境 | Feature（E2E）テスト | Selenium WebDriver + headless Chrome |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| RSpec | テストフレームワーク | rspec-rails |
| RSpec ActiveModel Mocks | モデルのモック化 | rspec-activemodel-mocks |
| FactoryBot | テストデータ生成 | ~> 6.0 |
| FFaker | ダミーデータ生成 | ffaker |
| Capybara | ブラウザテスト（E2E） | capybara |
| Selenium WebDriver | ブラウザ自動化 | selenium-webdriver |
| Webdrivers | ブラウザドライバ管理 | webdrivers |
| Capybara Screenshot | テスト失敗時のスクリーンショット | capybara-screenshot |
| DatabaseCleaner | テストデータクリーニング | database_cleaner |
| Timecop | 時間のモック化 | timecop |
| Devise Test Helpers | 認証テストヘルパー | devise |
| Warden Test Helpers | 認証テストヘルパー | warden |
| Paper Trail RSpec | 履歴追跡のテスト | paper_trail |
| Rails Controller Testing | コントローラテスト拡張 | rails-controller-testing |
| Brakeman | セキュリティ静的解析 | 6.0.1 |
| Rubocop | コード静的解析 | rubocop, rubocop-rails, rubocop-rspec, rubocop-capybara, rubocop-factory_bot, rubocop-rspec_rails |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な目標値の設定なし（推奨: 80%以上） |
| 分岐カバレッジ | 明示的な目標値の設定なし（推奨: 70%以上） |

**注記**: 本プロジェクトでは、SimpleCovなどのカバレッジツールの明示的な設定は確認されていない。カバレッジ計測の導入を推奨する。

## テストデータ

### テストデータ準備方針

1. **FactoryBot**: テストデータの生成にはFactoryBotを使用する
   - `spec/factories/`ディレクトリにファクトリ定義を配置
   - 主要なファクトリ: user, account, contact, lead, opportunity, campaign, task, setting, field, tag, subscription等

2. **FFaker**: ダミーデータの生成にはFFakerを使用する
   - ユーザー名、メールアドレス、電話番号、会社名等のランダムデータ生成

3. **シーケンス**: 連番データの生成には`spec/factories/sequences.rb`を使用

4. **DatabaseCleaner**: テスト間のデータ分離
   - 通常のテスト: トランザクション戦略
   - JSテスト/truncateオプション指定時: truncation戦略

### テストフィクスチャ

- `spec/fixtures/files/`: テスト用の静的ファイル（画像等）を配置

## 不具合管理

### 不具合報告フロー

1. テスト失敗時はGitHub Issuesで管理
2. Feature（E2E）テスト失敗時はCapybara Screenshotによる自動スクリーンショット取得
3. CI/CDパイプラインでの失敗はGitHub Actionsの結果で確認

### 不具合の優先度分類

- **Critical**: 認証・認可に関わる不具合、データ損失のリスクがある不具合
- **High**: 主要機能（アカウント、コンタクト、リード等）の動作不良
- **Medium**: 副次的機能の不具合
- **Low**: UIの軽微な問題、パフォーマンスの軽微な劣化

## CI/CD連携

### GitHub Actions ワークフロー

本プロジェクトでは、以下のGitHub Actionsワークフローが設定されている:

#### 1. RSpecテスト (`ruby.yml`)

- **トリガー**: masterブランチへのPull Request
- **実行環境**: Ubuntu Latest
- **Ruby バージョン**: 3.4
- **データベース**: SQLite3
- **実行テスト**:
  1. `spec:preparedb` - データベース準備
  2. `spec:models` - モデルテスト
  3. `spec:controllers` - コントローラテスト
  4. `spec:views` - ビューテスト
  5. `spec:helpers` - ヘルパーテスト
  6. `spec:routing` - ルーティングテスト
  7. `spec:mailers` - メーラーテスト
  8. `spec:lib` - ライブラリテスト
  9. `spec:features` - E2Eテスト

#### 2. Brakemanセキュリティスキャン (`brakeman-analysis.yml`)

- **トリガー**: masterブランチへのPull Request / 定期実行（毎週土曜13:20 UTC）
- **出力**: SARIF形式でGitHub Code Scanningに連携

#### 3. Rubocop静的解析 (`rubocop-analysis.yml`)

- **トリガー**: 全てのPull Request
- **出力**: SARIF形式でGitHub Code Scanningに連携

### テスト実行コマンド

```bash
# 全テスト実行
bundle exec rspec

# 種別ごとのテスト実行
bundle exec rake spec:models
bundle exec rake spec:controllers
bundle exec rake spec:views
bundle exec rake spec:helpers
bundle exec rake spec:routing
bundle exec rake spec:mailers
bundle exec rake spec:lib
bundle exec rake spec:features

# データベース準備
RAILS_ENV=test bundle exec rake spec:preparedb
```

## テスト構成

### ディレクトリ構造

```
spec/
├── controllers/          # コントローラテスト
│   ├── admin/           # 管理者向けコントローラ
│   └── entities/        # エンティティ系コントローラ
├── factories/           # FactoryBot定義
├── features/            # E2E（Feature）テスト
│   ├── admin/          # 管理者機能
│   ├── devise/         # 認証機能
│   └── support/        # Feature用ヘルパー
├── fixtures/            # テストフィクスチャ
│   └── files/          # テスト用ファイル
├── helpers/             # ヘルパーテスト
│   └── admin/          # 管理者向けヘルパー
├── lib/                 # ライブラリテスト
│   ├── core_ext/       # Ruby拡張
│   ├── fat_free_crm/   # アプリケーション固有
│   └── mail_processor/ # メール処理
├── mailers/             # メーラーテスト
├── models/              # モデルテスト
│   ├── entities/       # エンティティモデル
│   ├── fields/         # カスタムフィールド
│   ├── observers/      # オブザーバー
│   ├── polymorphic/    # ポリモーフィック
│   └── users/          # ユーザー関連
├── routing/             # ルーティングテスト
│   └── admin/          # 管理者ルーティング
├── shared/              # 共有スペック
├── support/             # テストサポートモジュール
└── views/               # ビューテスト
```

### テストファイル数

- 総テストファイル数: 約190ファイル

## 備考

### 推奨事項

1. **カバレッジ計測の導入**: SimpleCovの導入によるカバレッジ可視化を推奨
2. **並列テスト実行**: parallel_testsの導入によるテスト実行時間短縮を検討
3. **パフォーマンステストの追加**: 負荷テスト・パフォーマンステストの追加を検討

### 注意事項

1. Feature（E2E）テストはヘッドレスブラウザを使用するため、実行環境にChrome/Chromiumが必要
2. JSを使用するテストは`js: true`タグを付与
3. トランザクションではなくtruncationが必要なテストは`truncate: true`タグを付与
4. 認証が必要なテストは`do_login_if_not_already`ヘルパーを使用

### ローカル設定

- テスト時のロケールは`en-US`に固定
- テスト環境は`RAILS_ENV=test`
- データベースは環境変数`DB`で切り替え可能（sqlite, mysql, postgres）
