---
generated_at: 2026-01-13 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **アクセス制御の詳細仕様**：access カラムの値（Public/Private/Shared）の動作詳細は実装依存
  2. **シリアライズフォーマット**：subscribed_users等のシリアライズ形式の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `db/schema.rb` - ActiveRecord スキーマ定義（全テーブル構造の主要根拠）
- E-02: `app/models/entities/account.rb` - Account モデル定義
- E-03: `app/models/entities/contact.rb` - Contact モデル定義
- E-04: `app/models/entities/lead.rb` - Lead モデル定義
- E-05: `app/models/entities/opportunity.rb` - Opportunity モデル定義
- E-06: `app/models/entities/campaign.rb` - Campaign モデル定義
- E-07: `app/models/users/user.rb` - User モデル定義
- E-08: `app/models/polymorphic/task.rb` - Task モデル定義
- E-09: `app/models/polymorphic/address.rb` - Address モデル定義
- E-10: `app/models/polymorphic/comment.rb` - Comment モデル定義
- E-11: `app/models/polymorphic/email.rb` - Email モデル定義
- E-12: `app/models/polymorphic/avatar.rb` - Avatar モデル定義
- E-13: `app/models/polymorphic/version.rb` - Version モデル定義
- E-14: `app/models/entities/account_contact.rb` - AccountContact 中間テーブルモデル
- E-15: `app/models/entities/account_opportunity.rb` - AccountOpportunity 中間テーブルモデル
- E-16: `app/models/entities/contact_opportunity.rb` - ContactOpportunity 中間テーブルモデル
- E-17: `app/models/users/group.rb` - Group モデル定義
- E-18: `app/models/users/permission.rb` - Permission モデル定義
- E-19: `app/models/users/preference.rb` - Preference モデル定義
- E-20: `app/models/setting.rb` - Setting モデル定義
- E-21: `app/models/fields/field_group.rb` - FieldGroup モデル定義
- E-22: `app/models/fields/field.rb` - Field モデル定義
- E-23: `app/models/list.rb` - List モデル定義
- E-24: `app/models/research_tool.rb` - ResearchTool モデル定義
- E-25: `app/models/polymorphic/tag.rb` - Tag モデル定義
- E-26: `app/models/polymorphic/tagging.rb` - Tagging モデル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | usersテーブルに32項目のカラムが存在 | E-01, E-07 | ○ |
| C-02 | Devise認証を使用している | E-07 | ○ |
| C-03 | accountsテーブルにカウンターキャッシュ（contacts_count, opportunities_count）が存在 | E-01, E-02 | ○ |
| C-04 | Account - Contact間はaccount_contactsを介した多対多関連 | E-02, E-14 | ○ |
| C-05 | Account - Opportunity間はaccount_opportunitiesを介した多対多関連 | E-02, E-15 | ○ |
| C-06 | contactsテーブルにlead_idが存在（Lead変換履歴） | E-01, E-03 | ○ |
| C-07 | Contact - Opportunity間はcontact_opportunitiesを介した多対多関連 | E-03, E-16 | ○ |
| C-08 | leadsテーブルにcampaign_idが存在（Campaign関連） | E-01, E-04 | ○ |
| C-09 | Lead変換時にContactが作成される | E-04 | ○ |
| C-10 | opportunitiesテーブルにstage, probability, amountカラムが存在 | E-01, E-05 | ○ |
| C-11 | campaignsテーブルにleads_count, opportunities_countカウンターキャッシュが存在 | E-01, E-06 | ○ |
| C-12 | tasksテーブルはポリモーフィック関連（asset_type, asset_id） | E-01, E-08 | ○ |
| C-13 | addressesテーブルはポリモーフィック関連（addressable_type, addressable_id） | E-01, E-09 | ○ |
| C-14 | commentsテーブルはポリモーフィック関連（commentable_type, commentable_id） | E-01, E-10 | ○ |
| C-15 | emailsテーブルはポリモーフィック関連（mediator_type, mediator_id） | E-01, E-11 | ○ |
| C-16 | avatarsテーブルはポリモーフィック関連（entity_type, entity_id） | E-01, E-12 | ○ |
| C-17 | Paper Trailによるバージョン管理（versionsテーブル） | E-02, E-03, E-04, E-05, E-06, E-13 | ○ |
| C-18 | groups_usersテーブルはHABTM（主キーなし） | E-01, E-07, E-17 | ○ |
| C-19 | permissionsテーブルはポリモーフィック関連 | E-01, E-18 | ○ |
| C-20 | preferencesテーブルの値はBase64エンコード | E-19 | ○ |
| C-21 | settingsテーブルの値はシリアライズ | E-20 | ○ |
| C-22 | field_groupsとfieldsの親子関係 | E-21, E-22 | ○ |
| C-23 | fieldsテーブルはSTI（typeカラム） | E-01, E-22 | ○ |
| C-24 | listsテーブルでユーザーの保存済み検索を管理 | E-01, E-23 | ○ |
| C-25 | research_toolsテーブルでリサーチツール設定を管理 | E-01, E-24 | ○ |
| C-26 | acts_as_taggable_onによるタグ機能（tags, taggings） | E-25, E-26 | ○ |
| C-27 | 論理削除（deleted_atカラム）の採用 | E-01 | ○ |
| C-28 | subscribed_usersカラムはArray型でシリアライズ | E-02, E-03, E-04, E-05, E-06, E-08 | ○ |
| C-29 | Active Storage関連テーブル（blobs, attachments, variant_records）が存在 | E-01 | ○ |
| C-30 | Action Text関連テーブル（action_text_rich_texts）が存在 | E-01 | ○ |
| C-31 | accountsテーブルにlatitude, longitudeカラムが存在 | E-01 | ○ |
| C-32 | usersテーブルにsubscribe_to_comment_replies, receive_assigned_notificationsが存在 | E-01 | ○ |
| C-33 | Account - Address関連（billing_address, shipping_address） | E-02 | ○ |
| C-34 | Contact - Address関連（business_address） | E-03 | ○ |
| C-35 | Lead - Address関連（business_address） | E-04 | ○ |
| C-36 | User - Avatar関連（has_one :avatar） | E-07, E-12 | ○ |
| C-37 | User - Group多対多関連（has_and_belongs_to_many） | E-07, E-17 | ○ |
| C-38 | AccountContactにカウンターキャッシュ設定 | E-14 | ○ |
| C-39 | AccountOpportunityにカウンターキャッシュ設定 | E-15 | ○ |
| C-40 | ContactOpportunityにroleカラムが存在 | E-01, E-16 | ○ |
| C-41 | FieldGroupとTagの関連（tag_idカラム） | E-01, E-21 | ○ |
| C-42 | sessionsテーブルでセッション管理 | E-01 | ○ |
| C-43 | activitiesテーブルでアクティビティログ管理 | E-01 | ○ |
| C-44 | accessカラムの値がPublic/Private/Sharedの3種類 | **根拠なし（推定）** | △ |
| C-45 | シリアライズカラムの詳細フォーマット | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-44: accessカラムの具体的な値（Public/Private/Shared）については、モデルファイル内のバリデーションやコメントから推定したが、明示的な定義ファイルは確認できなかった
  - 候補：config/settings.yml / config/settings.default.yml / localeファイル
- C-45: subscribed_usersなどのシリアライズカラムの詳細なフォーマット（配列の要素型など）は、モデルの`serialize`宣言から推定したが、実データの確認は行っていない
  - 候補：seed データ / テストフィクスチャ / 実データベース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構造、カラム定義、インデックス情報はschema.rbから直接取得
- 0: 低リスク - リレーションシップ情報はモデルファイルのbelongs_to/has_many宣言から直接取得
- 1: 中リスク - accessカラムの値に関する説明は実装から推定（ドキュメントで要確認）
- 1: 中リスク - 一部のビジネスロジック説明（Lead変換プロセスなど）はコード解析による推定
- 0: 低リスク - カウンターキャッシュ設定はモデルの明示的な宣言から確認

## 6) レビュアーチェックリスト（最小）
- [ ] schema.rbの内容と設計書のテーブル定義が一致しているか
- [ ] 全32テーブルが網羅されているか
- [ ] ポリモーフィック関連の説明が正確か
- [ ] 中間テーブルの役割説明が適切か
- [ ] accessカラムの値（Public/Private/Shared）の実際の動作を確認
- [ ] カウンターキャッシュの更新タイミングが正しく説明されているか
- [ ] 論理削除の対象テーブルが正確に記載されているか
- [ ] ER図のリレーションシップがモデル定義と一致しているか
