# データベース設計書

## 概要

本ドキュメントは、Fat Free CRM（オープンソースCRMシステム）のデータベース設計書です。Ruby on Rails 7.1フレームワークを使用し、ActiveRecord ORMによるデータベース管理を行っています。主要なエンティティとして、ユーザー、アカウント、コンタクト、リード、オポチュニティ、キャンペーン、タスクを管理し、それらの関連情報（住所、コメント、メール、タグ等）を保持します。

## テーブル一覧

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| users | User | システムユーザー（営業担当者、管理者等） |
| accounts | Account | 取引先企業 |
| contacts | Contact | 取引先の連絡先（担当者） |
| leads | Lead | 見込み客 |
| opportunities | Opportunity | 商談・案件 |
| campaigns | Campaign | マーケティングキャンペーン |
| tasks | Task | タスク・ToDo |
| addresses | Address | 住所情報（ポリモーフィック） |
| comments | Comment | コメント（ポリモーフィック） |
| emails | Email | メール（ポリモーフィック） |
| avatars | Avatar | アバター画像（ポリモーフィック） |
| tags | Tag | タグ |
| taggings | Tagging | タグ付け中間テーブル |
| versions | Version | 変更履歴（Paper Trail） |
| account_contacts | AccountContact | アカウントとコンタクトの中間テーブル |
| account_opportunities | AccountOpportunity | アカウントとオポチュニティの中間テーブル |
| contact_opportunities | ContactOpportunity | コンタクトとオポチュニティの中間テーブル |
| groups | Group | ユーザーグループ |
| groups_users | - | グループとユーザーの中間テーブル（HABTM） |
| permissions | Permission | アクセス権限 |
| preferences | Preference | ユーザー設定 |
| settings | Setting | システム設定 |
| field_groups | FieldGroup | カスタムフィールドグループ |
| fields | Field | カスタムフィールド定義 |
| lists | List | 保存済み検索リスト |
| activities | Activity | アクティビティログ |
| sessions | Session | セッション情報 |
| research_tools | ResearchTool | リサーチツール設定 |
| action_text_rich_texts | ActionText::RichText | リッチテキストコンテンツ |
| active_storage_attachments | ActiveStorage::Attachment | ファイル添付 |
| active_storage_blobs | ActiveStorage::Blob | ファイルデータ |
| active_storage_variant_records | ActiveStorage::VariantRecord | 画像バリアント |

## 各テーブル定義

### 1. users

システムユーザーを管理するテーブル。Devise認証を使用し、営業担当者や管理者などのCRMユーザー情報を保持します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| username | string(32) | NO | ユーザー名（一意） |
| email | string(254) | YES | メールアドレス |
| first_name | string(32) | YES | 名 |
| last_name | string(32) | YES | 姓 |
| title | string(64) | YES | 役職 |
| company | string(64) | YES | 会社名 |
| alt_email | string(254) | YES | 代替メールアドレス |
| phone | string(32) | YES | 電話番号 |
| mobile | string(32) | YES | 携帯電話番号 |
| aim | string(32) | YES | AIM ID |
| yahoo | string(32) | YES | Yahoo ID |
| google | string(32) | YES | Google ID |
| encrypted_password | string | NO | 暗号化パスワード |
| password_salt | string | NO | パスワードソルト |
| last_sign_in_at | datetime | YES | 前回サインイン日時 |
| current_sign_in_at | datetime | YES | 現在のサインイン日時 |
| last_sign_in_ip | string | YES | 前回サインインIP |
| current_sign_in_ip | string | YES | 現在のサインインIP |
| sign_in_count | integer | NO | サインイン回数（デフォルト: 0） |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| admin | boolean | NO | 管理者フラグ（デフォルト: false） |
| suspended_at | datetime | YES | アカウント停止日時 |
| unconfirmed_email | string(254) | YES | 未確認メールアドレス |
| reset_password_token | string | YES | パスワードリセットトークン |
| reset_password_sent_at | datetime | YES | パスワードリセット送信日時 |
| remember_token | string | YES | リメンバートークン |
| remember_created_at | datetime | YES | リメンバー作成日時 |
| authentication_token | string | YES | 認証トークン |
| confirmation_token | string(255) | YES | 確認トークン |
| confirmed_at | datetime | YES | 確認日時 |
| confirmation_sent_at | datetime | YES | 確認メール送信日時 |
| subscribe_to_comment_replies | boolean | NO | コメント返信通知購読（デフォルト: true） |
| receive_assigned_notifications | boolean | NO | 割当通知受信（デフォルト: true） |

**インデックス:**
- `index_users_on_username_and_deleted_at` (unique)
- `index_users_on_email`
- `index_users_on_authentication_token` (unique)
- `index_users_on_confirmation_token` (unique)
- `index_users_on_remember_token` (unique)
- `index_users_on_reset_password_token` (unique)

### 2. accounts

取引先企業を管理するテーブル。企業情報と連絡先情報を保持します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | 作成者ユーザーID（外部キー: users.id） |
| assigned_to | integer | YES | 担当者ユーザーID（外部キー: users.id） |
| name | string(64) | NO | 企業名 |
| access | string(8) | YES | アクセス権限（デフォルト: Public） |
| website | string(64) | YES | Webサイト |
| toll_free_phone | string(32) | YES | フリーダイヤル |
| phone | string(32) | YES | 電話番号 |
| fax | string(32) | YES | FAX番号 |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| email | string(254) | YES | メールアドレス |
| background_info | string | YES | 背景情報 |
| rating | integer | NO | 評価（デフォルト: 0、0-5） |
| category | string(32) | YES | カテゴリ |
| subscribed_users | text | YES | 購読ユーザーID配列（シリアライズ） |
| contacts_count | integer | YES | コンタクト数（カウンターキャッシュ、デフォルト: 0） |
| opportunities_count | integer | YES | オポチュニティ数（カウンターキャッシュ、デフォルト: 0） |
| latitude | decimal(10,6) | YES | 緯度 |
| longitude | decimal(10,6) | YES | 経度 |

**インデックス:**
- `index_accounts_on_user_id_and_name_and_deleted_at` (unique)
- `index_accounts_on_assigned_to`

### 3. contacts

取引先の連絡先（担当者）を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | 作成者ユーザーID（外部キー: users.id） |
| lead_id | integer | YES | 元リードID（外部キー: leads.id） |
| assigned_to | integer | YES | 担当者ユーザーID（外部キー: users.id） |
| reports_to | integer | YES | 上司ユーザーID（外部キー: users.id） |
| first_name | string(64) | NO | 名 |
| last_name | string(64) | NO | 姓 |
| access | string(8) | YES | アクセス権限（デフォルト: Public） |
| title | string(64) | YES | 役職 |
| department | string(64) | YES | 部署 |
| source | string(32) | YES | リードソース |
| email | string(254) | YES | メールアドレス |
| alt_email | string(254) | YES | 代替メールアドレス |
| phone | string(32) | YES | 電話番号 |
| mobile | string(32) | YES | 携帯電話番号 |
| fax | string(32) | YES | FAX番号 |
| blog | string(128) | YES | ブログURL |
| linkedin | string(128) | YES | LinkedInプロフィール |
| facebook | string(128) | YES | Facebookプロフィール |
| twitter | string(128) | YES | Twitterアカウント |
| born_on | date | YES | 生年月日 |
| do_not_call | boolean | NO | 電話禁止フラグ（デフォルト: false） |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| background_info | string | YES | 背景情報 |
| subscribed_users | text | YES | 購読ユーザーID配列（シリアライズ） |

**インデックス:**
- `id_last_name_deleted` (unique: user_id, last_name, deleted_at)
- `index_contacts_on_assigned_to`

### 4. leads

見込み客を管理するテーブル。コンバージョンによりContactに変換されます。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | 作成者ユーザーID（外部キー: users.id） |
| campaign_id | integer | YES | キャンペーンID（外部キー: campaigns.id） |
| assigned_to | integer | YES | 担当者ユーザーID（外部キー: users.id） |
| first_name | string(64) | NO | 名 |
| last_name | string(64) | NO | 姓 |
| access | string(8) | YES | アクセス権限（デフォルト: Public） |
| title | string(64) | YES | 役職 |
| company | string(64) | YES | 会社名 |
| source | string(32) | YES | リードソース |
| status | string(32) | YES | ステータス |
| referred_by | string(64) | YES | 紹介者 |
| email | string(254) | YES | メールアドレス |
| alt_email | string(254) | YES | 代替メールアドレス |
| phone | string(32) | YES | 電話番号 |
| mobile | string(32) | YES | 携帯電話番号 |
| blog | string(128) | YES | ブログURL |
| linkedin | string(128) | YES | LinkedInプロフィール |
| facebook | string(128) | YES | Facebookプロフィール |
| twitter | string(128) | YES | Twitterアカウント |
| rating | integer | NO | 評価（デフォルト: 0） |
| do_not_call | boolean | NO | 電話禁止フラグ（デフォルト: false） |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| background_info | string | YES | 背景情報 |
| subscribed_users | text | YES | 購読ユーザーID配列（シリアライズ） |

**インデックス:**
- `index_leads_on_user_id_and_last_name_and_deleted_at` (unique)
- `index_leads_on_assigned_to`

### 5. opportunities

商談・案件を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | 作成者ユーザーID（外部キー: users.id） |
| campaign_id | integer | YES | キャンペーンID（外部キー: campaigns.id） |
| assigned_to | integer | YES | 担当者ユーザーID（外部キー: users.id） |
| name | string(64) | NO | 案件名 |
| access | string(8) | YES | アクセス権限（デフォルト: Public） |
| source | string(32) | YES | リードソース |
| stage | string(32) | YES | 商談ステージ |
| probability | integer | YES | 成約確率（%） |
| amount | decimal(12,2) | YES | 金額 |
| discount | decimal(12,2) | YES | 割引額 |
| closes_on | date | YES | クローズ予定日 |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| background_info | string | YES | 背景情報 |
| subscribed_users | text | YES | 購読ユーザーID配列（シリアライズ） |

**インデックス:**
- `id_name_deleted` (unique: user_id, name, deleted_at)
- `index_opportunities_on_assigned_to`

### 6. campaigns

マーケティングキャンペーンを管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | 作成者ユーザーID（外部キー: users.id） |
| assigned_to | integer | YES | 担当者ユーザーID（外部キー: users.id） |
| name | string(64) | NO | キャンペーン名 |
| access | string(8) | YES | アクセス権限（デフォルト: Public） |
| status | string(64) | YES | ステータス |
| budget | decimal(12,2) | YES | 予算 |
| target_leads | integer | YES | 目標リード数 |
| target_conversion | float | YES | 目標コンバージョン率 |
| target_revenue | decimal(12,2) | YES | 目標売上 |
| leads_count | integer | YES | リード数（カウンターキャッシュ） |
| opportunities_count | integer | YES | オポチュニティ数（カウンターキャッシュ） |
| revenue | decimal(12,2) | YES | 実績売上 |
| starts_on | date | YES | 開始日 |
| ends_on | date | YES | 終了日 |
| objectives | text | YES | 目標・目的 |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| background_info | string | YES | 背景情報 |
| subscribed_users | text | YES | 購読ユーザーID配列（シリアライズ） |

**インデックス:**
- `index_campaigns_on_user_id_and_name_and_deleted_at` (unique)
- `index_campaigns_on_assigned_to`

### 7. tasks

タスク・ToDoを管理するテーブル。ポリモーフィック関連でエンティティに紐づけ可能。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | 作成者ユーザーID（外部キー: users.id） |
| assigned_to | integer | YES | 担当者ユーザーID（外部キー: users.id） |
| completed_by | integer | YES | 完了者ユーザーID（外部キー: users.id） |
| name | string | NO | タスク名 |
| asset_type | string | YES | 関連エンティティ種別 |
| asset_id | integer | YES | 関連エンティティID |
| priority | string(32) | YES | 優先度 |
| category | string(32) | YES | カテゴリ |
| bucket | string(32) | YES | 期限バケット |
| due_at | datetime | YES | 期限日時 |
| completed_at | datetime | YES | 完了日時 |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| background_info | string | YES | 背景情報 |
| subscribed_users | text | YES | 購読ユーザーID配列（シリアライズ） |

**インデックス:**
- `index_tasks_on_user_id_and_name_and_deleted_at` (unique)
- `index_tasks_on_assigned_to`

### 8. addresses

住所情報を管理するポリモーフィックテーブル。Account、Contact、Leadに関連付け可能。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| street1 | string | YES | 住所1 |
| street2 | string | YES | 住所2 |
| city | string(64) | YES | 市区町村 |
| state | string(64) | YES | 都道府県 |
| zipcode | string(16) | YES | 郵便番号 |
| country | string(64) | YES | 国 |
| full_address | string | YES | 完全住所 |
| address_type | string(16) | YES | 住所種別（Billing/Shipping/Business） |
| addressable_type | string | YES | 関連エンティティ種別 |
| addressable_id | integer | YES | 関連エンティティID |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| deleted_at | datetime | YES | 論理削除日時 |

**インデックス:**
- `index_addresses_on_addressable_id_and_addressable_type`

### 9. comments

コメントを管理するポリモーフィックテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | 作成者ユーザーID（外部キー: users.id） |
| commentable_type | string | YES | 関連エンティティ種別 |
| commentable_id | integer | YES | 関連エンティティID |
| private | boolean | YES | プライベートフラグ |
| title | string | YES | タイトル（デフォルト: 空文字） |
| comment | text | YES | コメント本文 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| state | string(16) | NO | 表示状態（デフォルト: Expanded） |

### 10. emails

メール情報を管理するポリモーフィックテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| imap_message_id | string | NO | IMAPメッセージID |
| user_id | integer | YES | ユーザーID（外部キー: users.id） |
| mediator_type | string | YES | 関連エンティティ種別 |
| mediator_id | integer | YES | 関連エンティティID |
| sent_from | string | NO | 送信元 |
| sent_to | string | NO | 送信先 |
| cc | string | YES | CC |
| bcc | string | YES | BCC |
| subject | string | YES | 件名 |
| body | text | YES | 本文 |
| header | text | YES | ヘッダー |
| sent_at | datetime | YES | 送信日時 |
| received_at | datetime | YES | 受信日時 |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| state | string(16) | NO | 表示状態（デフォルト: Expanded） |

**インデックス:**
- `index_emails_on_mediator_id_and_mediator_type`

### 11. avatars

アバター画像を管理するポリモーフィックテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | アップロードユーザーID（外部キー: users.id） |
| entity_type | string | YES | 関連エンティティ種別 |
| entity_id | integer | YES | 関連エンティティID |
| image_file_size | integer | YES | ファイルサイズ |
| image_file_name | string | YES | ファイル名 |
| image_content_type | string | YES | コンテンツタイプ |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |

### 12. tags

タグを管理するテーブル（acts_as_taggable_on）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| name | string | YES | タグ名 |
| taggings_count | integer | YES | タグ付け数（デフォルト: 0） |

**インデックス:**
- `index_tags_on_name` (unique)

### 13. taggings

タグ付け中間テーブル（acts_as_taggable_on）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| tag_id | integer | YES | タグID（外部キー: tags.id） |
| taggable_id | integer | YES | タグ付け対象ID |
| tagger_id | integer | YES | タグ付け者ID |
| tagger_type | string | YES | タグ付け者種別 |
| taggable_type | string(50) | YES | タグ付け対象種別 |
| context | string(50) | YES | コンテキスト |
| created_at | datetime | YES | 作成日時 |

**インデックス:**
- `taggings_idx` (unique: tag_id, taggable_id, taggable_type, context)
- `index_taggings_on_taggable_id_and_taggable_type_and_context`

### 14. versions

変更履歴を管理するテーブル（Paper Trail）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| item_type | string | NO | 対象エンティティ種別 |
| item_id | integer | NO | 対象エンティティID |
| event | string(512) | YES | イベント種別 |
| whodunnit | string | YES | 実行者ID |
| object | text | YES | 変更前オブジェクト |
| created_at | datetime | YES | 作成日時 |
| object_changes | text | YES | 変更内容 |
| related_id | integer | YES | 関連エンティティID |
| related_type | string | YES | 関連エンティティ種別 |
| transaction_id | integer | YES | トランザクションID |

**インデックス:**
- `index_versions_on_item_type_and_item_id`
- `index_versions_on_created_at`
- `index_versions_on_related_id_and_related_type`
- `index_versions_on_transaction_id`
- `index_versions_on_whodunnit`

### 15. account_contacts

アカウントとコンタクトの中間テーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| account_id | integer | YES | アカウントID（外部キー: accounts.id） |
| contact_id | integer | YES | コンタクトID（外部キー: contacts.id） |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |

**インデックス:**
- `index_account_contacts_on_account_id_and_contact_id`

### 16. account_opportunities

アカウントとオポチュニティの中間テーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| account_id | integer | YES | アカウントID（外部キー: accounts.id） |
| opportunity_id | integer | YES | オポチュニティID（外部キー: opportunities.id） |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |

**インデックス:**
- `index_account_opportunities_on_account_id_and_opportunity_id`

### 17. contact_opportunities

コンタクトとオポチュニティの中間テーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| contact_id | integer | YES | コンタクトID（外部キー: contacts.id） |
| opportunity_id | integer | YES | オポチュニティID（外部キー: opportunities.id） |
| role | string(32) | YES | 役割 |
| deleted_at | datetime | YES | 論理削除日時 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |

**インデックス:**
- `index_contact_opportunities_on_contact_id_and_opportunity_id`

### 18. groups

ユーザーグループを管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| name | string | YES | グループ名 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |

### 19. groups_users

グループとユーザーの中間テーブル（HABTM）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| group_id | integer | YES | グループID（外部キー: groups.id） |
| user_id | integer | YES | ユーザーID（外部キー: users.id） |

**インデックス:**
- `index_groups_users_on_group_id_and_user_id`
- `index_groups_users_on_group_id`
- `index_groups_users_on_user_id`

### 20. permissions

アクセス権限を管理するポリモーフィックテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | ユーザーID（外部キー: users.id） |
| asset_type | string | YES | 対象エンティティ種別 |
| asset_id | integer | YES | 対象エンティティID |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| group_id | integer | YES | グループID（外部キー: groups.id） |

**インデックス:**
- `index_permissions_on_asset_id_and_asset_type`
- `index_permissions_on_group_id`
- `index_permissions_on_user_id`

### 21. preferences

ユーザー設定を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | ユーザーID（外部キー: users.id） |
| name | string(32) | NO | 設定名 |
| value | text | YES | 設定値（Base64エンコード） |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |

**インデックス:**
- `index_preferences_on_user_id_and_name`

### 22. settings

システム設定を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| name | string(32) | NO | 設定名 |
| value | text | YES | 設定値（シリアライズ） |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |

**インデックス:**
- `index_settings_on_name`

### 23. field_groups

カスタムフィールドグループを管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| name | string(64) | YES | グループ名 |
| label | string(128) | YES | ラベル |
| position | integer | YES | 表示順 |
| hint | string | YES | ヒント |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| tag_id | integer | YES | タグID（外部キー: tags.id） |
| klass_name | string(32) | YES | 対象クラス名 |

### 24. fields

カスタムフィールド定義を管理するテーブル（STI）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| type | string | YES | フィールド種別（STI） |
| field_group_id | integer | YES | フィールドグループID（外部キー: field_groups.id） |
| position | integer | YES | 表示順 |
| name | string(64) | YES | フィールド名 |
| label | string(128) | YES | ラベル |
| hint | string | YES | ヒント |
| placeholder | string | YES | プレースホルダー |
| as | string(32) | YES | 入力タイプ |
| collection | text | YES | 選択肢（シリアライズ） |
| disabled | boolean | YES | 無効フラグ |
| required | boolean | YES | 必須フラグ |
| maxlength | integer | YES | 最大長 |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| pair_id | integer | YES | ペアフィールドID |
| settings | text | YES | 設定（シリアライズ） |
| minlength | integer | YES | 最小長（デフォルト: 0） |
| pattern | string | YES | 入力パターン |
| autofocus | string | YES | オートフォーカス |
| autocomplete | string | YES | オートコンプリート |
| list | string | YES | データリスト |
| multiple | string | YES | 複数選択 |

**インデックス:**
- `index_fields_on_field_group_id`
- `index_fields_on_name`

### 25. lists

保存済み検索リストを管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| name | string | YES | リスト名 |
| url | text | YES | 検索URL |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |
| user_id | integer | YES | ユーザーID（外部キー: users.id） |

**インデックス:**
- `index_lists_on_user_id`

### 26. activities

アクティビティログを管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| user_id | integer | YES | ユーザーID（外部キー: users.id） |
| subject_type | string | YES | 対象エンティティ種別 |
| subject_id | integer | YES | 対象エンティティID |
| action | string(32) | YES | アクション（デフォルト: created） |
| info | string | YES | 情報（デフォルト: 空文字） |
| private | boolean | YES | プライベートフラグ（デフォルト: false） |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |

**インデックス:**
- `index_activities_on_created_at`
- `index_activities_on_user_id`

### 27. sessions

セッション情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| session_id | string | NO | セッションID |
| data | text | YES | セッションデータ |
| created_at | datetime | YES | 作成日時 |
| updated_at | datetime | YES | 更新日時 |

**インデックス:**
- `index_sessions_on_session_id`
- `index_sessions_on_updated_at`

### 28. research_tools

リサーチツール設定を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| name | string | YES | ツール名 |
| url_template | string | YES | URLテンプレート |
| enabled | boolean | NO | 有効フラグ（デフォルト: false） |
| created_at | datetime | NO | 作成日時 |
| updated_at | datetime | NO | 更新日時 |

### 29. action_text_rich_texts

リッチテキストコンテンツを管理するテーブル（Action Text）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| name | string | NO | フィールド名 |
| body | text | YES | リッチテキスト本文 |
| record_type | string | NO | 関連エンティティ種別 |
| record_id | bigint | NO | 関連エンティティID |
| created_at | datetime | NO | 作成日時 |
| updated_at | datetime | NO | 更新日時 |

**インデックス:**
- `index_action_text_rich_texts_uniqueness` (unique: record_type, record_id, name)

### 30. active_storage_attachments

ファイル添付を管理するテーブル（Active Storage）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| name | string | NO | 添付名 |
| record_type | string | NO | 関連エンティティ種別 |
| record_id | bigint | NO | 関連エンティティID |
| blob_id | bigint | NO | BlobID（外部キー: active_storage_blobs.id） |
| created_at | datetime | NO | 作成日時 |

**インデックス:**
- `index_active_storage_attachments_on_blob_id`
- `index_active_storage_attachments_uniqueness` (unique)

### 31. active_storage_blobs

ファイルデータを管理するテーブル（Active Storage）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| key | string | NO | ストレージキー |
| filename | string | NO | ファイル名 |
| content_type | string | YES | コンテンツタイプ |
| metadata | text | YES | メタデータ |
| service_name | string | NO | ストレージサービス名 |
| byte_size | bigint | NO | ファイルサイズ |
| checksum | string | NO | チェックサム |
| created_at | datetime | NO | 作成日時 |

**インデックス:**
- `index_active_storage_blobs_on_key` (unique)

### 32. active_storage_variant_records

画像バリアントを管理するテーブル（Active Storage）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | integer | NO | 主キー |
| blob_id | bigint | NO | BlobID（外部キー: active_storage_blobs.id） |
| variation_digest | string | NO | バリアントハッシュ |

**インデックス:**
- `index_active_storage_variant_records_uniqueness` (unique: blob_id, variation_digest)

## 備考

### 論理削除（Soft Delete）
多くのエンティティテーブルで`deleted_at`カラムによる論理削除を採用しています。物理削除ではなく、削除日時を記録することでデータを保持しつつ削除状態を管理します。

### ポリモーフィック関連
Address、Comment、Email、Avatar、Task、Permissionなどのテーブルは、ポリモーフィック関連を使用して複数のエンティティタイプと関連付け可能です。

### カウンターキャッシュ
AccountテーブルのContacts_count、opportunities_countや、CampaignテーブルのLeads_count、opportunities_countは、関連レコード数をキャッシュすることでパフォーマンスを向上させています。

### シリアライズカラム
subscribed_users、collection、settings、valueなどのカラムは、配列やハッシュをシリアライズして保存しています。

### Single Table Inheritance（STI）
Fieldテーブルでは、typeカラムによるSTIを採用し、CoreField、CustomFieldなどの派生クラスを同一テーブルで管理しています。

### 変更履歴（Paper Trail）
主要エンティティはPaper Trailによる変更履歴管理を行い、versionsテーブルに変更内容を記録しています。

### タグ機能（acts_as_taggable_on）
tags、taggingsテーブルはacts_as_taggable_on gemによって管理され、各エンティティへのタグ付けを実現しています。

### アクセス制御
各エンティティのaccessカラム（Public/Private/Shared）とpermissionsテーブルにより、きめ細かなアクセス制御を実現しています。
