---
generated_at: 2026-01-13 16:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべてのバッチはソースコードから直接抽出）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/tasks/ffcrm/dropbox.rake`
- E-02: `lib/tasks/ffcrm/comment_replies.rake`
- E-03: `lib/tasks/ffcrm/setup.rake`
- E-04: `lib/tasks/ffcrm/secret.rake`
- E-05: `lib/tasks/ffcrm/config.rake`
- E-06: `lib/tasks/ffcrm/settings.rake`
- E-07: `lib/tasks/ffcrm/demo.rake`
- E-08: `lib/tasks/ffcrm/update_data.rake`
- E-09: `lib/tasks/ffcrm/preference_update.rake`
- E-10: `lib/tasks/ffcrm/missing_translations.rake`
- E-11: `lib/development_tasks/rspec.rake`
- E-12: `lib/development_tasks/rdoc.rake`
- E-13: `lib/development_tasks/license.rake`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ffcrm:dropbox:run - Dropboxクローラーを実行し、受信メールを処理する | E-01 | ○ |
| C-02 | ffcrm:dropbox:run:dry - [ドライラン] Dropboxクローラーを実行 | E-01 | ○ |
| C-03 | ffcrm:dropbox:setup - メールDropboxをセットアップする | E-01 | ○ |
| C-04 | ffcrm:comment_replies:run - コメント受信ボックスクローラーを実行 | E-02 | ○ |
| C-05 | ffcrm:comment_replies:run:dry - [ドライラン] コメント受信ボックスクローラーを実行 | E-02 | ○ |
| C-06 | ffcrm:comment_replies:setup - コメント受信ボックスをセットアップする | E-02 | ○ |
| C-07 | ffcrm:setup - データベースを準備する | E-03 | ○ |
| C-08 | ffcrm:setup:admin - 管理者ユーザーを作成する | E-03 | ○ |
| C-09 | ffcrm:secret - シークレットトークンを生成する | E-04 | ○ |
| C-10 | ffcrm:config:copy_database_yml - database.ymlをセットアップする | E-05 | ○ |
| C-11 | ffcrm:config:syck_to_psych - YAMLファイルをPsych形式に変換する | E-05 | ○ |
| C-12 | ffcrm:settings:clear - データベースから設定をクリアする | E-06 | ○ |
| C-13 | ffcrm:settings:show - データベース内の現在の設定を表示する | E-06 | ○ |
| C-14 | ffcrm:demo:load - デモデータをロードする | E-07 | ○ |
| C-15 | ffcrm:demo:reload - データベースをリセットしデモデータを再ロードする | E-07 | ○ |
| C-16 | ffcrm:update_data:fix_countries - 国コードをISO 3166-1に更新する | E-08 | ○ |
| C-17 | ffcrm:preference_update:run - Marshal形式をJSON形式に変換する | E-09 | ○ |
| C-18 | ffcrm:missing_translations:detect - 翻訳漏れを検出する | E-10 | ○ |
| C-19 | spec:preparedb - テスト環境のデータベースを準備する | E-11 | ○ |
| C-20 | rdoc - RDocドキュメントを生成する | E-12 | ○ |
| C-21 | license:add - ファイルにライセンス情報を追加する | E-13 | ○ |
| C-22 | license:remove - ファイルからライセンス情報を削除する | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - すべてのバッチ情報はrakeタスクファイルから直接抽出されており、根拠が明確に存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのバッチは実在するrakeタスクファイルから抽出されており、descメソッドで定義された説明文を元に日本語化している

## 6) レビュアーチェックリスト（最小）
- [ ] カテゴリ分類が適切であるか確認
- [ ] 説明文の日本語訳が正確であるか確認
- [ ] 運用で利用するバッチ（メール処理系）と開発用バッチの区分が明確であるか確認
- [ ] ffcrm:update_data:fix_countriesは一度のみ実行可能という制約が運用上理解されているか確認
