# バッチ設計書 10-ffcrm:config:copy_database_yml

## 概要

本ドキュメントは、Fat Free CRMにおけるデータベース設定ファイルコピーバッチ（ffcrm:config:copy_database_yml）の設計について記載する。

### 本バッチの処理概要

このバッチは、Fat Free CRMのデータベース設定テンプレートファイルを、Railsアプリケーションのconfig/database.ymlにコピーする。DB環境変数によりデータベース種別（postgres/mysql等）を指定でき、対応するテンプレートファイルがコピーされる。

**業務上の目的・背景**：新規インストール時に、使用するデータベースに応じた適切なdatabase.yml設定ファイルを自動的に配置する。手動でのファイルコピーや設定ファイル作成の手間を省き、設定ミスを防止する。複数のデータベース種別に対応したテンプレートを提供することで、柔軟な環境構築を可能にする。

**バッチの実行タイミング**：初期インストール時に1回実行。config/database.ymlが存在しない場合のみコピーを実行。

**主要な処理内容**：
1. DB環境変数からデータベース種別を取得（デフォルト: postgres）
2. 対応するテンプレートファイルのパスを構築
3. config/database.ymlの存在確認
4. 存在しない場合、テンプレートをコピー

**前後の処理との関連**：本バッチはffcrm:setupやdb:migrateの実行前に実行する必要がある。database.ymlが存在しないとデータベース接続ができない。

**影響範囲**：config/database.ymlファイルの作成。既存ファイルがある場合は何も行わない。

## バッチ種別

セットアップ / 設定ファイル管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 初期セットアップ時（1回のみ） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| テンプレート存在 | FatFreeCRM.rootにデータベース設定テンプレートが存在すること |
| 書き込み権限 | configディレクトリへの書き込み権限 |

### 実行可否判定

config/database.ymlが存在しない場合のみコピーを実行。存在する場合はスキップ。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| DB | 環境変数 | No | postgres | データベース種別（postgres/mysql等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| config/database.{DB}.yml | YAMLファイル | データベース設定テンプレート |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| config/database.yml | YAMLファイル | データベース接続設定 |
| STDOUT | コンソール | コピー実行メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | database.yml |
| 出力先 | config/ |
| 文字コード | UTF-8 |
| 形式 | YAML |

## 処理フロー

### 処理シーケンス

```
1. fileutilsライブラリのロード
   └─ require 'fileutils'
2. データベース種別決定
   └─ ENV['DB'] || 'postgres'
3. ソースファイルパス構築
   └─ FatFreeCRM.root.join("config/database.{DB}.yml")
4. 宛先ファイルパス構築
   └─ Rails.root.join('config/database.yml')
5. 存在確認
   └─ File.exist?(dest)
6. コピー実行（存在しない場合）
   └─ FileUtils.cp(orig, dest)
   └─ メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[fileutilsロード]
    B --> C[DB環境変数取得]
    C --> D{DB指定あり?}
    D -->|あり| E[指定値使用]
    D -->|なし| F[postgres使用]
    E --> G[ソースパス構築]
    F --> G
    G --> H[宛先パス構築]
    H --> I{database.yml存在?}
    I -->|存在| J[スキップ]
    I -->|なし| K[コピー実行]
    K --> L[メッセージ出力]
    L --> M[バッチ終了]
    J --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイルコピーエラー | 権限不足、ソースファイル不存在 | 権限確認、テンプレート存在確認 |
| - | パス解決エラー | FatFreeCRM.root未定義 | gemインストール確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ソースファイルが存在しない場合、サポートされているDB種別を確認
2. 権限エラーの場合、configディレクトリの書き込み権限を確認
3. 手動でテンプレートをコピーすることも可能

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 即時 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行の制限なし。File.exist?チェック後のコピーのため、同時実行でレースコンディションの可能性あるが、結果は同じ。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行ログ | コピー実行時 | "Copying {filename} to config/database.yml ..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | 設定なし | - |

## 備考

- 本バッチはRails環境（:environment依存）なしで実行可能
- config/database.ymlが既に存在する場合は何も行わない（上書きしない）
- サポートされるデータベース種別はFatFreeCRMのテンプレートに依存
- デフォルトはPostgreSQLを使用
- 環境変数DBでmysql、sqlite3等を指定可能（対応テンプレートがある場合）
- コピーされたファイルは環境に応じて手動で編集が必要な場合がある（ホスト名、認証情報等）
- CIパイプラインでは、DB環境変数を使用して適切なデータベース設定を選択できる
