# バッチ設計書 11-ffcrm:config:syck_to_psych

## 概要

本ドキュメントは、Fat Free CRMにおけるYAML設定ファイルのフォーマット変換バッチ（ffcrm:config:syck_to_psych）の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、Railsアプリケーションの設定ファイル（YAML形式）をSyckフォーマットからPsychフォーマットに変換する処理を行う。

**業務上の目的・背景**：Ruby 1.9以降、YAMLパーサーのデフォルトがSyckからPsychに変更された。古いバージョンのFat Free CRMでは、Syck形式でYAMLファイルが作成されていた可能性があり、これをPsych形式に変換することで、最新のRuby/Rails環境との互換性を確保する。この変換を行わない場合、設定ファイルの読み込みエラーやアプリケーションの起動失敗が発生する可能性がある。

**バッチの実行タイミング**：Fat Free CRMのアップグレード時やRubyバージョンのアップグレード時など、システム移行作業の一環として随時実行される。本バッチは通常、一度のみ実行されることを想定している。

**主要な処理内容**：
1. config/ディレクトリ配下のすべてのYAMLファイルを検索
2. 各ファイルをSyckエンジンで読み込み
3. 元のファイルをバックアップ（.bakファイル作成）
4. Psychエンジンで書き出し、ファイルを上書き保存

**前後の処理との関連**：本バッチは独立して実行可能であり、特定の前提バッチは存在しない。ただし、ffcrm:config:copy_database_yml（No.10）の後に実行することで、database.ymlも含めた変換が可能となる。

**影響範囲**：config/ディレクトリ配下のすべてのYAMLファイルが影響を受ける。settings.yml、database.yml、localesファイルなどが対象となる。

## バッチ種別

データ変換（YAML形式変換）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（システム移行時のみ） |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Syckライブラリ | syck gemがインストールされていること |
| Psychライブラリ | psych gemがインストールされていること（Ruby 1.9+標準） |
| ファイル書き込み権限 | config/ディレクトリへの書き込み権限があること |

### 実行可否判定

特別な実行可否判定は行わない。ただし、Psychで既に読み取り可能なファイルであっても、すべてのファイルが変換処理される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| config/**/*.yml | YAML | Railsアプリケーションの設定ファイル群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| config/**/*.yml | YAML（Psych形式） | 変換後の設定ファイル |
| config/**/*.yml.bak | YAML（Syck形式） | 元ファイルのバックアップ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元のファイル名と同じ |
| 出力先 | config/ディレクトリ配下 |
| 文字コード | UTF-8 |
| バックアップファイル | 元ファイル名.bak |

## 処理フロー

### 処理シーケンス

```
1. ファイル一覧取得
   └─ Dir.globでconfig/**/*.ymlパターンにマッチするファイルを取得
2. ファイルごとのループ処理
   └─ 以下の3〜5を各ファイルに対して実行
3. Syckで読み込み
   └─ YAML::ENGINE.yamlerを'syck'に設定してファイルを読み込み
4. バックアップ作成
   └─ FileUtils.cpで.bakファイルを作成
5. Psychで書き出し
   └─ YAML::ENGINE.yamlerを'psych'に設定してファイルを上書き保存
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[config/**/*.ymlファイル一覧取得]
    B --> C{ファイルあり?}
    C -->|なし| G[バッチ終了]
    C -->|あり| D[Syckでファイル読み込み]
    D --> E[.bakファイル作成]
    E --> F[Psychで書き出し]
    F --> H{次のファイルあり?}
    H -->|あり| D
    H -->|なし| G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| LoadError | ライブラリ読み込みエラー | syck gemが未インストール | syck gemをインストール |
| Errno::EACCES | 権限エラー | ファイル書き込み権限なし | 適切な権限を付与 |
| Psych::SyntaxError | YAML構文エラー | YAMLファイルが破損 | ファイルを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. .bakファイルが存在する場合は、元のファイルにリストア可能
2. エラー発生時は処理を中断し、原因を調査
3. 必要に応じて.bakファイルから復元

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十ファイル程度 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ実行中はアプリケーションを停止することを推奨。同時実行は想定していない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | ファイル処理時 | "Converting {ファイルパス}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- 本バッチはRuby 2.x以降では動作しない可能性がある（YAML::ENGINE.yamlerは非推奨）
- 最新のRuby環境では、syck gemの互換性に注意が必要
- 変換前に必ずconfig/ディレクトリ全体のバックアップを取得することを推奨
