# バッチ設計書 12-ffcrm:settings:clear

## 概要

本ドキュメントは、Fat Free CRMにおける設定クリアバッチ（ffcrm:settings:clear）の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、データベースに保存されているアプリケーション設定をすべて削除し、デフォルト設定にリセットする処理を行う。

**業務上の目的・背景**：Fat Free CRMでは、アプリケーション設定がsettingsテーブルに保存される。運用中に設定が複雑化したり、不正な設定値が保存された場合、本バッチを実行することでデフォルト設定に戻すことができる。これにより、設定に起因する問題の解決や、クリーンな状態からの再設定が可能となる。設定はconfig/settings.default.ymlおよびconfig/settings.ymlからも読み込まれるため、データベースの設定を削除しても基本的な動作は維持される。

**バッチの実行タイミング**：システムリセット時、設定トラブルシューティング時、または開発・テスト環境のクリーンアップ時など、随時手動で実行される。

**主要な処理内容**：
1. Rails環境のロード
2. settingsテーブルの全レコードを削除（Setting.delete_all）
3. 削除完了

**前後の処理との関連**：本バッチは独立して実行可能。実行後はconfig/settings.default.ymlおよびconfig/settings.ymlの設定が適用される。必要に応じて、ffcrm:settings:show（No.13）で設定状態を確認できる。

**影響範囲**：settingsテーブルの全データが削除される。アプリケーションの表示設定、動作設定、カスタム設定など、データベースに保存されたすべての設定が対象となる。

## バッチ種別

データクレンジング / 設定リセット

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | アプリケーションデータベースに接続可能であること |
| settingsテーブル存在 | マイグレーション済みでsettingsテーブルが存在すること |

### 実行可否判定

特別な実行可否判定は行わない。settingsテーブルが空の場合でもエラーにはならない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| settingsテーブル | DB | 削除対象の設定データ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| settingsテーブル | DB | 全レコード削除 |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. Rails環境ロード
   └─ :environment タスクを依存関係として実行
2. 設定削除
   └─ Setting.delete_all でsettingsテーブルの全レコードを削除
3. 処理完了
   └─ 正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Rails環境ロード]
    B --> C[Setting.delete_all実行]
    C --> D[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定クリア | settings | DELETE | 全レコード削除 |

### テーブル別操作詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | 全カラム | 条件なし（全レコード） | delete_allメソッドによる一括削除 |

**テーブルスキーマ：**
- id: integer (PK)
- name: string(32) - 設定名
- value: text - 設定値（シリアライズ）
- created_at: datetime
- updated_at: datetime

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ActiveRecord::StatementInvalid | DBエラー | データベース接続不可 | DB接続を確認 |
| ActiveRecord::NoDatabaseError | DBエラー | データベース未作成 | db:create実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. データベース接続エラーの場合はdatabase.ymlを確認
2. テーブル不存在の場合はマイグレーションを実行
3. 削除前の設定を復元したい場合は、事前にバックアップが必要

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | delete_allは単一SQL発行 |
| コミットタイミング | 即時コミット |
| ロールバック条件 | エラー発生時は自動ロールバック |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 通常数十件程度 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ実行中のアプリケーションアクセスに注意。設定削除中にアクセスがあると、一時的に設定が読み込めない状態となる可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| N/A | N/A | 標準出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- delete_allはActiveRecordコールバックを実行しないため、高速に処理される
- 設定復元にはデータベースバックアップからのリストアが必要
- 本番環境での実行は慎重に行うこと
