# バッチ設計書 13-ffcrm:settings:show

## 概要

本ドキュメントは、Fat Free CRMにおける設定表示バッチ（ffcrm:settings:show）の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、データベースに保存されているアプリケーション設定を一覧表示する処理を行う。現在有効な設定値を確認するためのユーティリティバッチである。

**業務上の目的・背景**：Fat Free CRMでは、アプリケーション設定がsettingsテーブルに保存される。運用時やトラブルシューティング時に、現在どのような設定が有効になっているかを確認する必要がある。本バッチを使用することで、コンソールからデータベースに保存された設定を簡単に確認できる。GUIを通さずにコマンドラインから設定状態を把握できるため、サーバー管理者やデプロイ担当者にとって有用なツールである。

**バッチの実行タイミング**：設定確認が必要な際に随時実行される。デプロイ後の設定確認、トラブルシューティング時の状態確認、設定変更前後の比較などに使用される。

**主要な処理内容**：
1. Rails環境のロード
2. settingsテーブルから設定名を取得（名前順でソート）
3. 各設定名に対応する値を取得して標準出力に表示

**前後の処理との関連**：本バッチは独立して実行可能な参照専用バッチ。ffcrm:settings:clear（No.12）の実行後に設定状態を確認する際などに使用される。

**影響範囲**：読み取り専用の処理であり、データの変更は行わない。標準出力に設定情報が表示されるのみ。

## バッチ種別

レポート生成 / 状態確認

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | アプリケーションデータベースに接続可能であること |
| settingsテーブル存在 | マイグレーション済みでsettingsテーブルが存在すること |

### 実行可否判定

特別な実行可否判定は行わない。settingsテーブルが空の場合は何も出力されない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| N/A | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| settingsテーブル | DB | 設定データの読み取り元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 設定名と設定値のペアを表示 |

### 出力ファイル仕様

ファイル出力なし。標準出力のみ。

**出力フォーマット：**
```
{設定名1}:
  {設定値1のinspect表現}

{設定名2}:
  {設定値2のinspect表現}
...
```

## 処理フロー

### 処理シーケンス

```
1. Rails環境ロード
   └─ :environment タスクを依存関係として実行
2. 設定名一覧取得
   └─ Setting.select('name').order('name').pluck('name')で名前順にソートして取得
3. 設定値表示ループ
   └─ 各設定名に対してSetting.send(name)で値を取得しinspectで表示
4. 処理完了
   └─ 正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Rails環境ロード]
    B --> C[設定名一覧取得]
    C --> D{設定あり?}
    D -->|なし| G[バッチ終了]
    D -->|あり| E[設定名と値を表示]
    E --> F{次の設定あり?}
    F -->|あり| E
    F -->|なし| G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定名取得 | settings | SELECT | name列を取得 |
| 設定値取得 | settings | SELECT | 各設定の値を取得 |

### テーブル別操作詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | name | ORDER BY name | 設定名一覧取得 |
| SELECT | value | WHERE name = {設定名} | Setting.send経由で取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ActiveRecord::StatementInvalid | DBエラー | データベース接続不可 | DB接続を確認 |
| ActiveRecord::NoDatabaseError | DBエラー | データベース未作成 | db:create実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. データベース接続エラーの場合はdatabase.ymlを確認
2. テーブル不存在の場合はマイグレーションを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 通常数十件程度 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用のため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 設定情報 | 設定ごと | "{設定名}:\n  {設定値}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- Setting.send(name)を使用しているため、YAMLファイルからの設定も含めて表示される可能性がある
- inspectメソッドで値を表示するため、複雑なオブジェクト構造も確認可能
- セキュリティ上、出力内容に機密情報が含まれる可能性があるため、出力の取り扱いに注意
